% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPartial.R
\name{plotPartial}
\alias{plotPartial}
\alias{plotPartial.partial}
\title{Plotting Partial Dependence Functions}
\usage{
plotPartial(x, ...)

\method{plotPartial}{partial}(x, smooth = FALSE, contour = TRUE,
  rug = FALSE, chull = FALSE, number = 4, overlap = 0.1, train = NULL,
  col.regions = viridis::viridis, ...)
}
\arguments{
\item{x}{An object of class{"partial_1d"} or \code{"partial_2d"}.}

\item{...}{Additional optional arguments to be passed onto \code{levelplot},
\code{wireframe}, or \code{xyplot}.}

\item{smooth}{Logical indicating whether or nor to overlay a loess smoother.
Default is \code{FALSE}.}

\item{contour}{Logical indicating whether or not to use
\code{lattice::levelplot} (\code{TRUE}) or \code{lattice::wireframe}
(\code{FALSE}). Default is \code{TRUE}.}

\item{rug}{Logical indicating whether or not to include a rug representation
to the plot. If \code{TRUE} the user must supply the original data.}

\item{chull}{Logical indicating whether or not to draw the convex hull
around the first two variables. Default is \code{FALSE}.}

\item{number}{Integer specifying the number of conditional intervals for the
panel variables.}

\item{overlap}{Proportion}

\item{train}{Data frame containing the original training data. Only
required if \code{rug = TRUE} or \code{chull = TRUE}.}

\item{col.regions}{Color vector to be used if \code{contour} is \code{TRUE}.}
}
\description{
Plots partial dependence functions using \code{lattice} graphics.
}

