% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{pdf_info}
\alias{pdf_attachments}
\alias{pdf_fonts}
\alias{pdf_info}
\alias{pdf_text}
\alias{pdf_toc}
\alias{pdftools}
\title{PDF utilities}
\usage{
pdf_info(pdf, opw = "", upw = "")

pdf_text(pdf, opw = "", upw = "")

pdf_fonts(pdf, opw = "", upw = "")

pdf_attachments(pdf, opw = "", upw = "")

pdf_toc(pdf, opw = "", upw = "")
}
\arguments{
\item{pdf}{file path or raw vector with pdf data}

\item{opw}{string with owner password to open pdf}

\item{upw}{string with user password to open pdf}
}
\description{
Utilities based on libpoppler for extracting text, fonts,
attachements and metadata from a pdf file.
}
\examples{
download.file("http://arxiv.org/pdf/1403.2805.pdf", "1403.2805.pdf", mode = "wb")
info <- pdf_info("1403.2805.pdf")
text <- pdf_text("1403.2805.pdf")
fonts <- pdf_fonts("1403.2805.pdf")
files <- pdf_attachments("1403.2805.pdf")
}
\seealso{
Other pdftools: \code{\link{pdf_render_page}}
}

