% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ParTrans}
\alias{ParTrans}
\title{Parallel transport}
\usage{
ParTrans(P, V, W)
}
\arguments{
\item{P}{a \eqn{(d,d)}-dimensional HPD matrix.}

\item{V}{a \eqn{(d,d)}-dimensional Hermitian matrix corresponding to a vector in the tangent space of \code{P}.}

\item{W}{a \eqn{(d,d)}-dimensional Hermitian matrix corresponding to a vector in the tangent space of \code{P}.}
}
\value{
a \eqn{(d,d)}-dimensional Hermitian matrix corresponding to the parallel transportation of \code{W} in
the direction of \code{V} along a geodesic curve for a unit time step.
}
\description{
\code{ParTrans()} computes the parallel transport on the manifold of HPD matrices
equipped with the Riemannian metric as described in e.g. (Chau and von Sachs, 2017a). That is,
the function computes the parallel transport  of a vector (Hermitian matrix) \code{W} in the tangent space
at the point (HPD matrix) \code{P} along a geodesic curve in the direction of the vector \code{V}
in the tangent space at \code{P} for a unit time step.
}
\examples{
## Transport the vector W to the tangent space at the identity
W <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
diag(W) <- rnorm(3)
W[lower.tri(W)] <- t(Conj(W))[lower.tri(W)]
p <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
P <- t(Conj(p)) \%*\% p

ParTrans(P, Logm(P, diag(3)), W) ## whitening transport

}
\references{
Chau, J. and von Sachs, R. (2017a). \emph{Positive definite multivariate spectral
estimation: a geometric wavelet approach}. Available at \url{http://arxiv.org/abs/1701.03314}.
}
\seealso{
\code{\link{Expm}, \link{Logm}}
}
