# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

ARMA <- function(Phi, Theta, Z, len) {
    .Call(pdSpecEst_ARMA, Phi, Theta, Z, len)
}

Chol <- function(M) {
    .Call(pdSpecEst_Chol, M)
}

E_coeff <- function(H) {
    .Call(pdSpecEst_E_coeff, H)
}

T_coeff <- function(H, y) {
    .Call(pdSpecEst_T_coeff, H, y)
}

E_coeff_inv <- function(coeff) {
    .Call(pdSpecEst_E_coeff_inv, coeff)
}

T_coeff_inv <- function(coeff, y) {
    .Call(pdSpecEst_T_coeff_inv, coeff, y)
}

#' Exponential map
#'
#' \code{Expm(P, H)} computes the projection of a Hermitian matrix \code{H} from the tangent space at a Hermitian
#' PD matrix \code{P} to the Riemannian manifold of Hermitian PD matrices via the
#' exponential map as in (Pennec, 2006). This is the unique inverse of the logarithmic map \code{\link{Logm}}.
#'
#' @param P a Hermitian positive definite matrix.
#' @param H a Hermitian matrix (of equal dimension as \code{P}).
#'
#' @examples
#'  H <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#'  diag(H) <- rnorm(3)
#'  H[lower.tri(H)] <- t(Conj(H))[lower.tri(H)]
#'  p <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#'  P <- t(Conj(p)) %*% p
#'  Expm(P, H)
#'
#' @references
#' Pennec, X. (2006). Intrinsic statistics on Riemannian manifolds: Basic tools for geometric
#' measurements. \emph{Journal of Mathematical Imaging and Vision} 25(1), 127-154.
#'
#' @seealso \code{\link{Logm}}
#'
#' @export
Expm <- function(P, H) {
    .Call(pdSpecEst_Expm, P, H)
}

iSqrt <- function(M) {
    .Call(pdSpecEst_iSqrt, M)
}

kMean <- function(M, mu) {
    .Call(pdSpecEst_kMean, M, mu)
}

#' Logarithmic map
#'
#' \code{Logm(P, Q)} computes the projection of a Hermitian PD matrix \code{Q} on the Riemannian manifold
#' to the tangent space attached at the Hermitian PD matrix \code{P} via the logarithmic map as in (Pennec, 2006).
#' This is the unique inverse of the exponential map \code{\link{Expm}}.
#'
#' @param P a Hermitian positive definite matrix.
#' @param Q a Hermitian positive definite matrix (of equal dimension as \code{P}).
#'
#' @examples
#'  q <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#'  Q <- t(Conj(q)) %*% q
#'  p <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#'  P <- t(Conj(p)) %*% p
#'  Logm(P, Q)
#'
#' @references
#' Pennec, X. (2006). Intrinsic statistics on Riemannian manifolds: Basic tools for geometric
#' measurements. \emph{Journal of Mathematical Imaging and Vision} 25(1), 127-154.
#'
#' @seealso \code{\link{Expm}}
#'
#' @export
Logm <- function(P, Q) {
    .Call(pdSpecEst_Logm, P, Q)
}

#' Geodesic midpoint between HPD-matrices
#'
#' \code{Mid} calculates the geodesic midpoint between two Hermitian PD matrices as in
#' (Bhatia, 2009, Chapter 6).
#'
#' @param A,B Hermitian positive definite matrices (of equal dimension).
#'
#' @examples
#'  a <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#'  A <- t(Conj(a)) %*% a
#'  b <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
#'  B <- t(Conj(b)) %*% b
#'  Mid(A, B)
#' @references Bhatia, R. (2009). \emph{Positive Definite Matrices}. New Jersey: Princeton University Press.
#'
#' @seealso \code{\link{KarchMean}}
#'
#' @export
Mid <- function(A, B) {
    .Call(pdSpecEst_Mid, A, B)
}

NormF <- function(M) {
    .Call(pdSpecEst_NormF, M)
}

RiemmDist <- function(A, B) {
    .Call(pdSpecEst_RiemmDist, A, B)
}

solveMid <- function(B, C) {
    .Call(pdSpecEst_solveMid, B, C)
}

Sqrt <- function(M) {
    .Call(pdSpecEst_Sqrt, M)
}

