% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcv.R
\name{pcv}
\alias{pcv}
\title{Compute matrix with pseudo-validation set}
\usage{
pcv(
  X,
  ncomp = min(round(nrow(X)/nseg) - 1, col(X), 20),
  nseg = 4,
  scale = FALSE
)
}
\arguments{
\item{X}{matrix with calibration set (IxJ)}

\item{ncomp}{number of components for PCA decomposition}

\item{nseg}{number of segments in cross-validation}

\item{scale}{logical, standardize columns of X prior to decompositon or not}
}
\value{
Pseudo-validation matrix (IxJ)
}
\description{
Compute matrix with pseudo-validation set
}
\details{
This is the old (original) version of PCV algorithm for PCA models. Use \code{\link{pcvpca}}
instead. Ane check project web-site for details: https://github.com/svkucheryavski/pcv

The method computes pseudo-validation matrix Xpv, based on PCA decomposition of calibration set X
and systematic (venetian blinds) cross-validation. It is assumed that data rows are ordered
correctly, so systematic cross-validation can be applied
}
