% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_diversity.R
\name{z_diversity}
\alias{z_diversity}
\alias{plot.zeta_res}
\title{Calculate Zeta Diversity}
\usage{
z_diversity(otutab, group_df = NULL, zetadiv_params = list())

\method{plot}{zeta_res}(x, lm_model = c("exp", "pl")[1], ribbon = FALSE, text = TRUE, ...)
}
\arguments{
\item{otutab}{A matrix or data frame containing OTU (Operational Taxonomic Unit) counts.}

\item{group_df}{A data frame containing group information.}

\item{zetadiv_params}{Additional parameters to be passed to the Zeta.decline.mc function from the zetadiv package.}

\item{x}{Zeta diversity results obtained from z_diversity function.}

\item{lm_model}{The linear model to be used for fitting ('exp' or 'pl').}

\item{ribbon}{Logical, whether to add a ribbon to the plot for standard deviation.}

\item{text}{Logical, whether to add R-squared and p-value text annotations.}

\item{...}{Additional arguments to be passed to ggplot2 functions.}
}
\value{
zeta_res

A ggplot object.
}
\description{
This function calculates Zeta diversity for each group in the provided otutab.

This function plots the Zeta diversity results obtained from the z_diversity function.
}
\examples{
data(otutab, package = "pcutils")
zeta_result <- z_diversity(otutab, metadata["Group"], zetadiv_params = list(sam = 10))
plot(zeta_result, lm_model = "exp", text = TRUE)
}
