% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylogenetic.R
\name{ann_tree}
\alias{ann_tree}
\alias{easy_tree}
\title{Annotate a tree}
\usage{
ann_tree(f_tax, otutab = NULL, level = ncol(f_tax))

easy_tree(
  tree,
  highlight = "Phylum",
  colorfill = "color",
  pal = NULL,
  basic_params = NULL,
  add_abundance = TRUE,
  add_tiplab = TRUE,
  fontsize = NULL
)
}
\arguments{
\item{f_tax}{taxonomy dataframe}

\item{otutab}{otutab, rowname==rowname(taxonomy)}

\item{level}{1~7}

\item{tree}{result from \code{ann_tree}}

\item{highlight}{highlight which level, one of \code{tree$level}}

\item{colorfill}{"color" or "fill"}

\item{pal}{color pal}

\item{basic_params}{parameters parse to \code{\link[ggtree]{ggtree}}}

\item{add_abundance}{logical}

\item{add_tiplab}{logical}

\item{fontsize}{tip label fontsize}
}
\value{
a treedata

a ggplot
}
\description{
Annotate a tree

Easy way to plot a phylogenetic tree
}
\examples{
data(otutab, package = "pcutils")
ann_tree(taxonomy, otutab) -> tree
# run yourself
easy_tree(tree, add_abundance = FALSE) -> p
p

}
