% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyses_fun.R
\name{pcr_dct}
\alias{pcr_dct}
\title{Calculate the delta_ct model}
\usage{
pcr_dct(df, group_var, reference_group, mode = "separate_tube",
  plot = FALSE, ...)
}
\arguments{
\item{df}{A data.frame of \eqn{C_T} values with genes in the columns and
samples in rows rows}

\item{group_var}{A character vector of a grouping variable. The length of
this variable should equal the number of rows of df}

\item{reference_group}{A character string of the control group in group_var}

\item{mode}{A character string of; 'separate_tube' (default) or 'same_tube'.
This is to indicate whether the different genes were run in separate or the
same PCR tube}

\item{plot}{A logical (default is FALSE)}

\item{...}{Arguments passed to customize plot}
}
\value{
A data.frame of 7 columns
\itemize{
  \item group The unique entries in group_var
  \item gene The column names of df
  \item calibrated The average \eqn{C_T} value of target genes after
  subtracting that of the reference_group
  \item fold_change The fold change of genes relative to a reference_group
  \item error The standard deviation of the fold_change
  \item lower The lower interval of the fold_change
  \item upper The upper interval of the fold_change
}
When \code{plot} is TRUE, returns a bar graph of the fold change of
the genes in the column and the groups in the column group. Error bars are
drawn using the columns lower and upper. When more one gene are plotted the
default in dodge bars. When the argument facet is TRUE a separate panel is
 drawn for each gene.
}
\description{
Uses the \eqn{C_T} values and a reference group to calculate the delta \eqn{C_T}
model to estimate the relative fold change of a gene between groups
}
\details{
This method is a variation of the double delta \eqn{C_T} model,
\code{\link{pcr_ddct}}. It can be used to calculate the fold change
of in one sample relative to the others. For example, it can be used to
compare and choosing a control/reference genes.
}
\examples{
# locate and read file
fl <- system.file('extdata', 'ct1.csv', package = 'pcr')
ct1 <- read.csv(fl)

# make a data.frame of two identical columns
pcr_hk <- data.frame(
  GAPDH1 = ct1$GAPDH,
  GAPDH2 = ct1$GAPDH
  )

# add grouping variable
group_var <- rep(c('brain', 'kidney'), each = 6)

# calculate caliberation
pcr_dct(pcr_hk,
        group_var = group_var,
        reference_group = 'brain')

# returns a plot
pcr_dct(pcr_hk,
        group_var = group_var,
        reference_group = 'brain',
        plot = TRUE)

# returns a plot with facets
pcr_dct(pcr_hk,
        group_var = group_var,
        reference_group = 'brain',
        plot = TRUE,
        facet = TRUE)

}
\references{
Livak, Kenneth J, and Thomas D Schmittgen. 2001. “Analysis of
Relative Gene Expression Data Using Real-Time Quantitative PCR and the
Double Delta CT Method.” Methods 25 (4). ELSEVIER.
doi:10.1006/meth.2001.1262.
}
