% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcoxtimeplots.R
\name{plot.pcoxsurvfit}
\alias{plot.pcoxsurvfit}
\title{Plot survival and cumulative hazard curves}
\usage{
\method{plot}{pcoxsurvfit}(
  x,
  ...,
  type = c("surv", "cumhaz"),
  lsize = 0.3,
  lcol = "black",
  compare = FALSE
)
}
\arguments{
\item{x}{a \code{\link[pcoxtime]{pcoxsurvfit.pcoxtime}} or \code{\link[pcoxtime]{pcoxbasehaz.pcoxtime}} object.}

\item{...}{for future implementations}

\item{type}{type of curve to generate. Either \code{type = "surv"} for survival curves or \code{type = "cumhaz"} for cumulative hazard curve.}

\item{lsize}{line size for the curves.}

\item{lcol}{colour for the curves.}

\item{compare}{logical. Whether to return plot with labels to add additional \code{geom} object for comparison. Default is \code{FALSE}.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object.
}
\description{
Plot estimated survival and cumulative  hazard curves for \code{pcoxtime} model.
}
\details{
Depending on the specification in \code{\link[pcoxtime]{pcoxsurvfit.pcoxtime}}, this function plots either average or individual survival or cumulative hazard curves. The plot is a \code{\link[ggplot2]{ggplot}} object, hence can be be customized further, see example below.
}
\examples{

library(ggplot2)
data(heart, package="survival")
lam <- 0.02
alp <- 1
pfit <- pcoxtime(Surv(start, stop, event) ~ age + year + surgery + transplant
	, data = heart
	, lambda = lam
	, alpha = alp
)

# Plot survival curves
psurv <- pcoxsurvfit(pfit)
plot(psurv)

# Baseline survival curve
bsurv <- pcoxbasehaz(pfit, centered = FALSE)
plot(bsurv)

# Compare overall and baseline cumulative hazard
p1 <- plot(psurv, type = "cumhaz", compare = TRUE)
df2 <- data.frame(time = bsurv$time, cumhaz = bsurv$hazard)
p2 <- (p1
	+ geom_step(data = df2, aes(x = time, y = cumhaz, group = 1, col = "baseline"))
	+ scale_colour_manual(name = "C. hazard"
		, values = c("#E41A1C", "#000000")
		, labels = c("baseline", "overall")
	)
)
print(p2)

}
