% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthocfuns.R
\name{predict.pcoxtime}
\alias{predict.pcoxtime}
\title{Prediction for pcoxtime model}
\usage{
\method{predict}{pcoxtime}(
  object,
  ...,
  newdata = NULL,
  type = c("lp", "risk", "expected", "terms", "survival"),
  terms = object$predictors,
  na.action = na.pass
)
}
\arguments{
\item{object}{fitted \code{\link[pcoxtime]{pcoxtime}} object}

\item{...}{for future implementations.}

\item{newdata}{optional data frame containing the variables appearing on the right hand side of \code{\link[pcoxtime]{pcoxtime}} formula. If absent, the predictions are for the data frame used in the original fit.}

\item{type}{the type of predicted value. Either linear predictor (\code{"lp"}), the risk score (\code{"risk"} equivalently \code{exp(lp)}), the expected number of events given the covariates and follow-up time (\code{"expected"}), the terms of linear predictor (\code{"terms"}) and the survival probability for each individual (\code{"survival"}).}

\item{terms}{if \code{type = "terms"}, this argument can be used to specify which terms to be return. Default is all.}

\item{na.action}{defines the missing value action for the \code{newdata}. If \code{newdata} is absent, then the behavior of missing is dictated by the \code{na.action} option of the original fit.}
}
\value{
a vector of predictions, depending on the \code{type}.
}
\description{
Compute fitted values and model terms for the pcoxtime model.
}
\details{
The computation of these predictions similar to those in \code{\link[survival]{predict.coxph}}. Our current implementation does not incorporate stratification.
}
\examples{

data(heart, package="survival")
lam <- 0.1
alp <- 0.8
pfit <- pcoxtime(Surv(start, stop, event) ~ age + year + surgery + transplant
	, data = heart
	, lambda = lam
	, alpha = alp
)

predict(pfit, type = "lp")
predict(pfit, type = "expected")
predict(pfit, type = "risk")
predict(pfit, type = "survival")
predict(pfit, type = "terms")

}
