% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassFunctions.R
\name{summary.NumArcs}
\alias{summary.NumArcs}
\title{Return a summary of a \code{NumArcs} \code{object}}
\usage{
\method{summary}{NumArcs}(object, ...)
}
\arguments{
\item{object}{An \code{object} of class \code{NumArcs}.}

\item{\dots}{Additional parameters for \code{summary}.}
}
\value{
The \code{call} of the \code{object} of class \code{"NumArcs"},
the \code{desc} of the proximity catch digraph (PCD),
total number of arcs in the digraph.
Moreover, in the one Delaunay cell case, the function also provides
vertices of Delaunay cell, and
indices of target points in the Delaunay cell;
and in the multiple Delaunay cell case, it also provides
number of arcs for the induced digraphs for points in the Delaunay cells,
vertices of Delaunay cells or indices of points that form the the Delaunay cells,
indices of target points in the convex hull of nontarget points,
indices of Delaunay cells in which points reside,
and area or length of the the Delaunay cells.
}
\description{
Returns the below information about the \code{object}:

\code{call} of the function defining the \code{object},
the description of the proximity catch digraph (PCD), \code{desc}.
In the one Delaunay cell case, the function provides
the total number of arcs in the digraph,
vertices of Delaunay cell, and
indices of target points in the Delaunay cell.

In the multiple Delaunay cell case, the function provides
total number of arcs in the digraph,
number of arcs for the induced digraphs for points in the Delaunay cells,
vertices of Delaunay cells or indices of points that form the the Delaunay cells,
indices of target points in the convex hull of nontarget points,
indices of Delaunay cells in which points reside,
and area or length of the the Delaunay cells.
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10
Xp<-runif.tri(n,Tr)$g
M<-as.numeric(runif.tri(1,Tr)$g)
Arcs<-arcsAStri(Xp,Tr,M)
Arcs
summary(Arcs)
}

}
\seealso{
\code{\link{print.NumArcs}}, \code{\link{print.summary.NumArcs}},
and \code{\link{plot.NumArcs}}
}
