% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{Idom.num1PEbasic.tri}
\alias{Idom.num1PEbasic.tri}
\title{The indicator for a point being a dominating point or not for
Proportional Edge Proximity Catch Digraphs (PE-PCDs) -
standard basic triangle case}
\usage{
Idom.num1PEbasic.tri(
  p,
  Xp,
  r,
  c1,
  c2,
  M = c(1, 1, 1),
  rv = NULL,
  ch.data.pnt = FALSE
)
}
\arguments{
\item{p}{A 2D point that is to be tested for being a dominating point
or not of the PE-PCD.}

\item{Xp}{A set of 2D points
which constitutes the vertices of the PE-PCD.}

\item{r}{A positive real number
which serves as the expansion parameter in PE proximity region;
must be \eqn{\ge 1}.}

\item{c1, c2}{Positive real numbers
which constitute the vertex of the standard basic triangle
adjacent to the shorter edges; \eqn{c_1} must be in \eqn{[0,1/2]},
\eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.}

\item{M}{A 2D point in Cartesian coordinates
or a 3D point in barycentric coordinates
which serves as a center
in the interior of the standard basic triangle \eqn{T_b}
or the circumcenter of \eqn{T_b}
which may be entered as "CC" as well;
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \eqn{T_b}.}

\item{rv}{Index of the vertex whose region contains point \code{p},
\code{rv} takes the vertex labels as \eqn{1,2,3} as
in the row order of the vertices in \eqn{T_b}.}

\item{ch.data.pnt}{A logical argument for checking
whether point \code{p} is a data point in \code{Xp} or not
(default is \code{FALSE}).}
}
\value{
\eqn{I(}\code{p} is a dominating point of the PE-PCD\eqn{)}
where the vertices of the PE-PCD are the 2D data set \code{Xp},
that is, returns 1 if \code{p} is a dominating point,
and returns 0 otherwise.
}
\description{
Returns \eqn{I(}\code{p} is a dominating point
of the PE-PCD\eqn{)}
where the vertices of the PE-PCD are the 2D data set \code{Xp}
for data in the standard basic triangle
\eqn{T_b=T((0,0),(1,0),(c_1,c_2))},
that is, returns 1 if \code{p} is a dominating point of PE-PCD,
and returns 0 otherwise.

PE proximity regions are defined
with respect to the standard basic triangle \eqn{T_b}.
In the standard basic triangle, \eqn{T_b},
\eqn{c_1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Any given triangle can be mapped to the standard basic triangle
by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling,
preserving uniformity of the points in the
original triangle. Hence, standard basic triangle is useful for simulation
studies under the uniformity hypothesis.

Vertex regions are based on center \eqn{M=(m_1,m_2)} in Cartesian
coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of a standard basic triangle
to the edges on the extension of the lines joining \code{M}
to the vertices or based on the circumcenter of \eqn{T_b};
default is \eqn{M=(1,1,1)}, i.e., the center of mass of \eqn{T_b}.
Point, \code{p}, is in the vertex region of vertex \code{rv}
(default is \code{NULL});
vertices are labeled as \eqn{1,2,3}
in the order they are stacked row-wise.

\code{ch.data.pnt} is for checking
whether point \code{p} is a data point in \code{Xp} or not
(default is \code{FALSE}),
so by default this function checks
whether the point \code{p} would be a dominating point
if it actually were in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
\dontrun{
c1<-.4; c2<-.6;
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C)
n<-10  #try also n<-20

set.seed(1)
Xp<-runif.basic.tri(n,c1,c2)$g

M<-as.numeric(runif.basic.tri(1,c1,c2)$g)  #try also M<-c(.6,.3)
r<-2

P<-c(.4,.2)
Idom.num1PEbasic.tri(P,Xp,r,c1,c2,M)
Idom.num1PEbasic.tri(Xp[1,],Xp,r,c1,c2,M)

Idom.num1PEbasic.tri(c(1,1),Xp,r,c1,c2,M,ch.data.pnt = FALSE)
#gives an error message if ch.data.pnt = TRUE since point p=c(1,1) is not a data point in Xp

#or try
Rv<-rel.vert.basic.tri(Xp[1,],c1,c2,M)$rv
Idom.num1PEbasic.tri(Xp[1,],Xp,r,c1,c2,M,Rv)

gam.vec<-vector()
for (i in 1:n)
{gam.vec<-c(gam.vec,Idom.num1PEbasic.tri(Xp[i,],Xp,r,c1,c2,M))}

ind.gam1<-which(gam.vec==1)
ind.gam1

Xlim<-range(Tb[,1],Xp[,1])
Ylim<-range(Tb[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

if (dimension(M)==3) {M<-bary2cart(M,Tb)}
#need to run this when M is given in barycentric coordinates

if (identical(M,circumcenter.tri(Tb)))
{
  plot(Tb,pch=".",asp=1,xlab="",ylab="",axes=TRUE,
  xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
  polygon(Tb)
  points(Xp,pch=1,col=1)
  Ds<-rbind((B+C)/2,(A+C)/2,(A+B)/2)
} else
{plot(Tb,pch=".",xlab="",ylab="",axes=TRUE,
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
  polygon(Tb)
  points(Xp,pch=1,col=1)
  Ds<-prj.cent2edges.basic.tri(c1,c2,M)}
L<-rbind(M,M,M); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
points(rbind(Xp[ind.gam1,]),pch=4,col=2)

txt<-rbind(Tb,M,Ds)
xc<-txt[,1]+c(-.02,.02,.02,-.02,.03,-.03,.01)
yc<-txt[,2]+c(.02,.02,.02,-.02,.02,.02,-.03)
txt.str<-c("A","B","C","M","D1","D2","D3")
text(xc,yc,txt.str)

Idom.num1PEbasic.tri(c(.2,.1),Xp,r,c1,c2,M,ch.data.pnt=FALSE)
#gives an error message if ch.data.pnt=TRUE since point p is not a data point in Xp
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Idom.num1ASbasic.tri}} and \code{\link{Idom.num1AStri}}
}
\author{
Elvan Ceyhan
}
