% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxGeometry.R
\name{Dist}
\alias{Dist}
\title{The distance between two vectors, matrices, or data frames}
\usage{
Dist(x, y)
}
\arguments{
\item{x, y}{Vectors, matrices or data frames
(both should be of the same type).}
}
\value{
Euclidean distance between \code{x} and \code{y}
}
\description{
Returns the Euclidean distance between \code{x} and \code{y}
which can be vectors
or matrices or data frames of any dimension (\code{x} and \code{y}
should be of same dimension).

This function is different from the \code{\link[stats]{dist}} function
in the \code{stats} package of the standard \code{R} distribution.
\code{dist} requires its argument to be a data matrix
and \code{\link[stats]{dist}} computes
and returns the distance matrix computed
by using the specified distance measure
to compute the distances between the rows of a data matrix
(\insertCite{S-Book:1998;textual}{pcds}),
while \code{Dist} needs two arguments to find the distances between.
For two data matrices \eqn{A} and \eqn{B},
\code{dist(rbind(as.vector(A), as.vector(B)))}
and \code{Dist(A,B)} yield the same result.
}
\examples{
\dontrun{
B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Dist(B,C);
dist(rbind(B,C))

x<-runif(10)
y<-runif(10)
Dist(x,y)

xm<-matrix(x,ncol=2)
ym<-matrix(y,ncol=2)
Dist(xm,ym)
dist(rbind(as.vector(xm),as.vector(ym)))

Dist(xm,xm)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{dist}} from the base package \code{stats}
}
\author{
Elvan Ceyhan
}
