% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PropEdge2D.R
\name{PG2PEtri}
\alias{PG2PEtri}
\title{Asymptotic probability that domination number of Proportional Edge Proximity Catch Digraphs (PE-PCDs)
equals 2 where vertices of the digraph are uniform points in a triangle}
\usage{
PG2PEtri(r)
}
\arguments{
\item{r}{A positive real number which serves as the expansion parameter in PE proximity region;
must be in \eqn{(1,1.5]} to attain non-degenerate asymptotic distribution for the domination number.}
}
\value{
\eqn{P(}domination number\eqn{=2)} for PE-PCD for uniform data on an triangle as the sample size n
goes to infinity
}
\description{
Returns \eqn{P(}domination number\eqn{=2)} for PE-PCD for uniform data in a triangle, when the sample size \eqn{n} goes to
infinity (i.e., asymptotic probability of domination number \eqn{= 2}).

PE proximity regions are constructed with respect to the triangle with the expansion parameter \eqn{r \ge 1} and
\eqn{M}-vertex regions where \eqn{M} is the vertex that renders the asymptotic distribution of the domination
number non-degenerate for the given value of \code{r} in \eqn{(1,1.5]}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:masa-2007,ceyhan:dom-num-NPE-Spat2011;textual}{pcds}).
}
\examples{
\dontrun{
PG2PEtri(r=1.5)
PG2PEtri(r=1.4999999999)

PG2PEtri(r=1.5) / PG2PEtri(r=1.4999999999)

rseq<-seq(1.01,1.49999999999,l=20)  #try also l=100
lrseq<-length(rseq)

pg2<-vector()
for (i in 1:lrseq)
{
  pg2<-c(pg2,PG2PEtri(rseq[i]))
}

plot(rseq, pg2,type="l",xlab="r",ylab=expression(paste("P(", gamma, "=2)")),
     lty=1,xlim=range(rseq)+c(0,.01),ylim=c(0,1))
points(rbind(c(1.50,PG2PEtri(1.50))),pch=".",cex=3)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{PG2PE1D}}
}
\author{
Elvan Ceyhan
}
