% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceFunctions.R
\name{ArcsAS}
\alias{ArcsAS}
\title{The arcs of Arc Slice Proximity Catch Digraph (AS-PCD) for a 2D data set - multiple triangle case}
\usage{
ArcsAS(Xp, Yp, M = "CC")
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangulation. The Delaunay
triangles partition the convex hull of \code{Yp} points.}

\item{M}{The center of the triangle. \code{"CC"} represents the circumcenter of each Delaunay triangle
or 3D point in barycentric coordinates which serves as a center in the interior of each Delaunay triangle;
default is \code{M="CC"} i.e., the circumcenter of each triangle. \code{M} must be entered in barycentric coordinates
unless it is the circumcenter.}
}
\value{
A \code{list} with the elements
\item{type}{A description of the type of the digraph}
\item{parameters}{Parameters of the digraph, here, it is the center used to construct the vertex regions,
default is circumcenter, denoted as \code{"CC"}, otherwise given in barycentric coordinates.}
\item{tess.points}{Points on which the tessellation of the study region is performed, here, tessellation
is the Delaunay triangulation based on \code{Yp} points.}
\item{tess.name}{Name of data set used in tessellation, i.e., \code{Yp}}
\item{vertices}{Vertices of the digraph, \code{Xp}.}
\item{vert.name}{Name of the data set which constitute the vertices of the digraph}
\item{S}{Tails (or sources) of the arcs of AS-PCD for 2D data set \code{Xp} in the multiple triangle case
as the vertices of the digraph}
\item{E}{Heads (or arrow ends) of the arcs of AS-PCD for 2D data set \code{Xp} in the multiple triangle case
as the vertices of the digraph}
\item{mtitle}{Text for \code{"main"} title in the plot of the digraph}
\item{quant}{Various quantities for the digraph: number of vertices, number of partition points,
number of intervals, number of arcs, and arc density.}
}
\description{
An object of class \code{"PCDs"}.
Returns arcs as tails (or sources) and heads (or arrow ends) of AS-PCD whose vertices are the data set \code{Xp}
and related parameters and the quantities of the digraph.

AS proximity regions are defined with respect to the Delaunay triangles based on
\code{Yp} points, i.e., AS proximity regions are defined only for \code{Xp} points
inside the convex hull of \code{Yp} points.
That is, arcs may exist for points only inside the convex hull of \code{Yp} points.
It also provides various descriptions and quantities about the arcs of the AS-PCD
such as number of arcs, arc density, etc.

Vertex regions are based on the center \code{M="CC"}
for circumcenter of each Delaunay triangle or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of each Delaunay triangle; default is \code{M="CC"} i.e., circumcenter of each triangle.
\code{M} must be entered in barycentric coordinates unless it is the circumcenter.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}) for more on AS PCDs.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds})
for more on Delaunay triangulation and the corresponding algorithm.
}
\examples{
\dontrun{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-15; ny<-5;  #try also nx=20; nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,.25),runif(ny,0,.25))+cbind(c(0,0,0.5,1,1),c(0,1,.5,0,1))
#try also Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-c(1,1,1)  #try also M<-c(1,2,3)

Arcs<-ArcsAS(Xp,Yp,M) #try also the default M with Arcs<-ArcsAS(Xp,Yp)
Arcs
summary(Arcs)
plot(Arcs)

ArcsAS(Xp,Yp[1:3,],M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{ArcsAStri}}, \code{\link{ArcsPEtri}}, \code{\link{ArcsCStri}}, \code{\link{ArcsPE}},
and \code{\link{ArcsCS}}
}
\author{
Elvan Ceyhan
}
