% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{Gam1CSTet1}
\alias{Gam1CSTet1}
\title{The indicator for a point being a dominating point for Central Similarity Proximity Catch Digraphs
(CS-PCDs) - standard equilateral triangle case with \eqn{t=1}}
\usage{
Gam1CSTet1(p, Dt, re = NULL, ch.data.pnt = FALSE)
}
\arguments{
\item{p}{A 2D point that is to be tested for being a dominating point or not of the CS-PCD.}

\item{Dt}{A set of 2D points which constitutes the vertices of the CS-PCD.}

\item{re}{The index of the edge region in \eqn{T_e} containing the point, either \code{1,2,3} or \code{NULL}
(default is \code{NULL}).}

\item{ch.data.pnt}{A logical argument for checking whether point \code{p} is a data point
in \code{Dt} or not (default is \code{FALSE}).}
}
\value{
\eqn{I(}\code{p} is a dominating point of the CS-PCD\eqn{)} where the vertices of the CS-PCD are the 2D data set \code{Dt},
that is, returns 1 if \code{p} is a dominating point, returns 0 otherwise.
}
\description{
Returns \eqn{I(}\code{p} is a dominating point of the CS-PCD\eqn{)} where the vertices of the CS-PCD are the 2D data set \code{Dt} in the standard equilateral
triangle \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))}, that is, returns 1 if \code{p} is a dominating point of CS-PCD,
returns 0 otherwise.

Point, \code{p}, is in the edge region of edge re (default is \code{NULL}); vertices are labeled as \eqn{1,2,3}
in the order they are stacked row-wise in \eqn{T_e}, and the opposite edges are labeled with label of the vertices
(that is, edge numbering is \code{1,2}, and \code{3} for edges \eqn{AB}, \eqn{BC}, and \eqn{AC}).

CS proximity region is constructed with respect to \eqn{T_e} with expansion parameter \eqn{t=1}
and edge regions are based on center of mass \eqn{CM=(1/2,\sqrt{3}/6)}.

\code{ch.data.pnt} is for checking whether point \code{p} is a data point in \code{Dt} or not (default is \code{FALSE}), so by default this
function checks whether the point \code{p} would be a dominating point if it actually were in the data set.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
CM<-(A+B+C)/3
Te<-rbind(A,B,C);
n<-20

set.seed(1)
dat<-runifTe(n)$gen.points

Gam1CSTet1(dat[3,],dat)

Gam1CSTet1(c(1,2),dat)

Gam1CSTet1(c(1,2),c(1,2))
Gam1CSTet1(c(1,2),c(1,2),ch.data.pnt = TRUE)

gam.vec<-vector()
for (i in 1:n)
{gam.vec<-c(gam.vec,Gam1CSTet1(dat[i,],dat))}

ind.gam1<-which(gam.vec==1)
ind.gam1

Xlim<-range(Te[,1],dat[,1])
Ylim<-range(Te[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Te,pch=".",xlab="",ylab="",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Te)
points(dat)
L<-Te; R<-matrix(rep(CM,3),ncol=2,byrow=TRUE);
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
points(rbind(dat[ind.gam1,]),pch=4,col=2)
#rbind is to insert the points correctly if there is only one dominating point

txt<-rbind(Te,CM)
xc<-txt[,1]+c(-.02,.02,.01,.05)
yc<-txt[,2]+c(.02,.02,.03,.02)
txt.str<-c("A","B","C","CM")
text(xc,yc,txt.str)

P<-c(.4,.2)
dat.fr<-data.frame(a=dat)
Gam1CSTet1(P,dat.fr)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Gam1CSTe}}
}
\author{
Elvan Ceyhan
}
