% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamicGP.cate.R
\name{dynamicGP.cate}
\alias{dynamicGP.cate}
\title{Get conditional average treatment effect for data with two time points.}
\usage{
dynamicGP.cate(
  jobid,
  x,
  control.tr,
  treat.tr,
  c.margin = NULL,
  token = NULL,
  use.cache = NULL
)
}
\arguments{
\item{jobid}{job id of the "dynamicGP".}

\item{x}{The name of variable which may have the heterogeneous treatment effect. x should be a categorical variable.}

\item{control.tr}{A vector of the values of the treatment variables at all stages as the reference group.}

\item{treat.tr}{A vector of the values of the treatment variables at all stages compared to the reference group.}

\item{c.margin}{An optional vector of user-defined values of c for PrCTE.}

\item{token}{Authentication token.}

\item{use.cache}{Use cached results (default True).}
}
\value{
jobid
}
\description{
Estimate the conditional average treatment effect of user-specified treatment groups.
}
\details{
The contrast of potential outcomes for the reference group and the treatment group is estimated at a list of x values if x is not a factor. If x is a factor, the conditional average treatment effect is estimated at each value of levels of x.
}
\note{
The conditional average treatment effect is estimated based on the sample data. The observations with missing covariates in the model are excluded. For the unspecified variables in the model, the observed data is used to estimate the conditional average treatment effect.
}
