\name{gmInt}
\alias{gmInt}
\docType{data}
\title{Graphical Model 8-Dimensional Interventional Gaussian Example Data}
\description{
This data set contains a matrix with an ensemble of observational and
interventional data from eight Gaussian variables.  The corresponding
(data generating) DAG model is also stored. 
}
\usage{
data(gmInt)
}
\format{
  The format is a list of four components
  \describe{
    \item{x:}{Matrix with 5000 rows (one row a measurement) and 8 columns
      (corresponding to the 8 variables}
    \item{targets:}{List of (mutually exclusive) intervention targets. In this
      example, the three entries \code{integer(0)}, \code{3} and \code{5} 
      indicate that the data set consists of observational data, interventional
      data originating from an intervention at vertex 3, and interventional data
      originating from an intervention at vertex 5.}
    \item{target.index:}{Vector with 5000 elements. Each entry maps a row of 
      \code{x} to the corresponding intervention target.  Example:
      \code{gmInt$target.index[3322] == 2} means that \code{x[3322, ]} was 
      simulated from an intervention at \code{gmInt$targets[[2]]}, i.e. at 
      vertex 3.}
    \item{g:}{Formal class 'graphNEL' [package "graph"] with 6 slots, 
      representing the true DAG from which observational and interventional
      data was sampled.}
  }
}
\details{
The data was generated as indicated below. First, a random DAG model was
generated, then 5000 samples were drawn from this model: 3000 observational
ones, and 1000 each from an intervention at vertex 3 and 5, respectively
(see \code{gmInt$target.index}).
}
\source{
  The data set is \code{\link{identical}} to the one generated by \preformatted{
  set.seed(40)
  p <- 8
  n <- 5000
  gGtrue <- randomDAG(p, prob = 0.3)
  pardag <- as(gGtrue, "GaussParDAG")
  pardag$set.err.var(rep(1, p))
  targets <- list(integer(0), 3, 5)
  target.index <- c(rep(1, 0.6*n), rep(2, n/5), rep(3, n/5))
  
  x1 <- rmvnorm.ivent(0.6*n, pardag)
  x2 <- rmvnorm.ivent(n/5, pardag, targets[[2]], 
                      matrix(rnorm(n/5, mean = 4, sd = 0.02), ncol = 1))
  x3 <- rmvnorm.ivent(n/5, pardag, targets[[3]], 
                      matrix(rnorm(n/5, mean = 4, sd = 0.02), ncol = 1))
  gmInt <- list(x = rbind(x1, x2, x3), 
                targets = targets, 
                target.index = target.index, 
                g = gGtrue)
  }
}
\examples{
data(gmInt)
str(gmInt, max = 3)
pairs(gmInt$x, gap = 0, pch = ".")
}
\keyword{datasets}
