% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KR-modcomp.R
\name{kr-modcomp}
\alias{kr-modcomp}
\alias{KRmodcomp}
\alias{KRmodcomp.lmerMod}
\alias{KRmodcomp_internal}
\alias{KRmodcomp.mer}
\title{F-test and degrees of freedom based on Kenward-Roger approximation}
\usage{
KRmodcomp(largeModel, smallModel, betaH = 0, details = 0)

\method{KRmodcomp}{lmerMod}(largeModel, smallModel, betaH = 0, details = 0)
}
\arguments{
\item{largeModel}{An \code{lmer} model}

\item{smallModel}{An \code{lmer} model or a restriction matrix}

\item{betaH}{A number or a vector of the beta of the hypothesis, e.g. L
beta=L betaH. betaH=0 if modelSmall is a model not a restriction matrix.}

\item{details}{If larger than 0 some timing details are printed.}
}
\description{
An approximate F-test based on the Kenward-Roger approach.
}
\details{
The model \code{object} must be fitted with restricted maximum
    likelihood (i.e. with \code{REML=TRUE}). If the object is fitted with
    maximum likelihood (i.e. with \code{REML=FALSE}) then the model is
    refitted with \code{REML=TRUE} before the p-values are calculated. Put
    differently, the user needs not worry about this issue.

An F test is calculated according to the approach of Kenward and Roger
(1997).  The function works for linear mixed models fitted with the
\code{lmer} function of the \pkg{lme4} package. Only models where the
covariance structure is a sum of known matrices can be compared.

The \code{largeModel} may be a model fitted with \code{lmer} either using
\code{REML=TRUE} or \code{REML=FALSE}.  The \code{smallModel} can be a model
fitted with \code{lmer}. It must have the same covariance structure as
\code{largeModel}. Furthermore, its linear space of expectation must be a
subspace of the space for \code{largeModel}.  The model \code{smallModel}
can also be a restriction matrix \code{L} specifying the hypothesis \eqn{L
\beta = L \beta_H}, where \eqn{L} is a \eqn{k \times p}{k X p} matrix and
\eqn{\beta} is a \eqn{p} column vector the same length as
\code{fixef(largeModel)}.

The \eqn{\beta_H} is a \eqn{p} column vector.

Notice: if you want to test a hypothesis \eqn{L \beta = c} with a \eqn{k}
vector \eqn{c}, a suitable \eqn{\beta_H} is obtained via \eqn{\beta_H=L c}
where \eqn{L_n} is a g-inverse of \eqn{L}.

Notice: It cannot be guaranteed that the results agree with other
implementations of the Kenward-Roger approach!
}
\note{
This functionality is not thoroughly tested and should be used with
    care. Please do report bugs etc.
}
\examples{

(fmLarge <- lmer(Reaction ~ Days + (Days|Subject), sleepstudy))
## removing Days
(fmSmall <- lmer(Reaction ~ 1 + (Days|Subject), sleepstudy))
anova(fmLarge,fmSmall)
KRmodcomp(fmLarge,fmSmall)

## The same test using a restriction matrix
L <- cbind(0,1)
KRmodcomp(fmLarge, L)

## Same example, but with independent intercept and slope effects:
m.large  <- lmer(Reaction ~ Days + (1|Subject) + (0+Days|Subject), data = sleepstudy)
m.small  <- lmer(Reaction ~ 1 + (1|Subject) + (0+Days|Subject), data = sleepstudy)
anova(m.large, m.small)
KRmodcomp(m.large, m.small)


}
\references{
Ulrich Halekoh, Søren Højsgaard (2014)., A Kenward-Roger
    Approximation and Parametric Bootstrap Methods for Tests in Linear Mixed
    Models - The R Package pbkrtest., Journal of Statistical Software,
    58(10), 1-30., \url{https://www.jstatsoft.org/v59/i09/}

Kenward, M. G. and Roger, J. H. (1997), \emph{Small Sample Inference for
Fixed Effects from Restricted Maximum Likelihood}, Biometrics 53: 983-997.
}
\seealso{
\code{\link{getKR}}, \code{\link{lmer}}, \code{\link{vcovAdj}},
    \code{\link{PBmodcomp}}
}
\author{
Ulrich Halekoh \email{uhalekoh@health.sdu.dk}, Søren Højsgaard
    \email{sorenh@math.aau.dk}
}
\keyword{inference}
\keyword{models}
