% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssh_plink.r
\name{ssh_plink}
\alias{check_exec}
\alias{plink}
\alias{run_args}
\alias{ssh}
\alias{ssh_plink}
\title{ssh and plink}
\usage{
ssh(args = "snoweye@192.168.56.101 whoami", intern = .pbd_env$RPC.CT$intern,
  wait = .pbd_env$RPC.CT$wait)

plink(args = "snoweye@192.168.56.101 whoami",
  use.shell.exec = .pbd_env$RPC.CT$use.shell.exec,
  pause = .pbd_env$RPC.CT$pause, intern = .pbd_env$RPC.CT$intern,
  wait = .pbd_env$RPC.CT$wait)

check_exec(exec)

run_args(exec = "ssh", args = "",
  use.shell.exec = .pbd_env$RPC.CT$use.shell.exec,
  pause = .pbd_env$RPC.CT$pause, intern = .pbd_env$RPC.CT$intern,
  wait = .pbd_env$RPC.CT$wait)
}
\arguments{
\item{args}{All in text/characters that are passed to the command line.}

\item{intern, wait}{arguments passed to \code{system()} or \code{shell()}
whereever they are applicable.}

\item{use.shell.exec}{if \code{shell.exec()} is used to execute the \code{plink} command in
windows. No returns can be captured by R when this is \code{TRUE} as
the default, because the authentication may not be generally
available in most windows system. No easy yet secure way to by passing
the password from R to external calls in shell.}

\item{pause}{if pause when \code{shell.exec} is used in Windows.}

\item{exec}{either \code{ssh} (i.e. \code{/usr/bin/ssh}) or a ``full path''
to \code{plink}.}
}
\value{
Mainly the message received at the command line will be returned.
}
\description{
Commend line tools including \code{ssh} for Linux, Mac OSX, Solaris,
or \code{plink} for Windows.
}
\details{
These functions only execute option/command on remote servers via secure
client commands.

NO further input from \code{stdin} is expected.
Outputs or errors may not be captured by R.

\code{ssh()} starts a ssh command.

\code{plink()} starts a plink command used by default for Windows.

\code{check_exec()} runs a quick check on the exec (either ssh or plink)
for rpc.

\code{run_args()} runs a rpc via either \code{ssh} or \code{plink}.
}
\examples{
\dontrun{
library(pbdRPC, quietly = TRUE)
rpcopt_set(user = "snoweye", hostname = "192.168.56.101")

### Check an R session.
cmd <- "Rscript -e 'sessionInfo()'"

### For Linux, Mac OSX, Solaris.
rpc(cmd = cmd, exec.type = "ssh")

### For Windows.
rpc(cmd = cmd, exec.type = "plink")

### Manually
args <- "snoweye@192.168.56.101 Rscript -e 'sessionInfo()'"
ssh(args)      # Note ssh uses "-p" for server port.
plink(args)    # Note plink uses "-P" for server port.

### Manually launch a remoter server at background.
user.hostname <- "snoweye@192.168.56.101"
preload <- "source ./work-my/00_devel_R"
rr <- "nohup Rscript -e 'remoter::server()' > .rrlog 2>&1 < /dev/null &"
args <- paste(user.hostname, " \\"", preload, "; ", rr, "\\"", sep = "")
plink(args)
}

}

