% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_sumstats.r
\docType{methods}
\name{ddmatrix-sumstats}
\alias{ddmatrix-sumstats}
\alias{max,ddmatrix-method}
\alias{mean,ddmatrix-method}
\alias{median,ddmatrix-method}
\alias{min,ddmatrix-method}
\alias{prod,ddmatrix-method}
\alias{sum,ddmatrix-method}
\title{Basic Summary Statistics}
\usage{
\S4method{sum}{ddmatrix}(x, ..., na.rm = FALSE)

\S4method{mean}{ddmatrix}(x, na.rm = FALSE)

\S4method{prod}{ddmatrix}(x, na.rm = FALSE)

\S4method{min}{ddmatrix}(x, na.rm = FALSE)

\S4method{max}{ddmatrix}(x, na.rm = FALSE)

\S4method{median}{ddmatrix}(x, na.rm = FALSE)
}
\arguments{
\item{x}{numeric distributed matrix}

\item{...}{Additional arguments.}

\item{na.rm}{Handling of NA's.}
}
\value{
A single value, owned by all ranks in the MPI communicator.
}
\description{
Get basic summary statistics.
}
\details{
The return is on process 0 only.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

# don't do this in production code
x <- matrix(1:16, ncol=4)
dx <- as.ddmatrix(x) 

summary(dx)

finalize()
}

}
\keyword{Methods}

