% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{apigatewaymanagementapi}
\alias{apigatewaymanagementapi}
\title{AmazonApiGatewayManagementApi}
\usage{
apigatewaymanagementapi(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
The Amazon API Gateway Management API allows you to directly manage
runtime aspects of your deployed APIs. To use it, you must explicitly
set the SDK's endpoint to point to the endpoint of your deployed API.
The endpoint will be of the form
https://\{api-id\}.execute-api.\{region\}.amazonaws.com/\{stage\}, or will be
the endpoint corresponding to your API's custom domain and base path, if
applicable.
}
\section{Service syntax}{
\preformatted{svc <- apigatewaymanagementapi(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=apigatewaymanagementapi_delete_connection]{delete_connection} \tab Delete the connection with the provided id\cr
\link[=apigatewaymanagementapi_get_connection]{get_connection} \tab Get information about the connection with the provided id\cr
\link[=apigatewaymanagementapi_post_to_connection]{post_to_connection} \tab Sends the provided data to the specified connection
}
}

\examples{
\dontrun{
svc <- apigatewaymanagementapi()
svc$delete_connection(
  Foo = 123
)
}

}
