% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_create_framework}
\alias{backup_create_framework}
\title{Creates a framework with one or more controls}
\usage{
backup_create_framework(
  FrameworkName,
  FrameworkDescription = NULL,
  FrameworkControls,
  IdempotencyToken = NULL,
  FrameworkTags = NULL
)
}
\arguments{
\item{FrameworkName}{[required] The unique name of the framework. The name must be between 1 and 256
characters, starting with a letter, and consisting of letters (a-z,
A-Z), numbers (0-9), and underscores (_).}

\item{FrameworkDescription}{An optional description of the framework with a maximum of 1,024
characters.}

\item{FrameworkControls}{[required] The controls that make up the framework. Each control in the list has a
name, input parameters, and scope.}

\item{IdempotencyToken}{A customer-chosen string that you can use to distinguish between
otherwise identical calls to \code{CreateFrameworkInput}. Retrying a
successful request with the same idempotency token results in a success
message with no action taken.}

\item{FrameworkTags}{The tags to assign to the framework.}
}
\description{
Creates a framework with one or more controls. A framework is a collection of controls that you can use to evaluate your backup practices. By using pre-built customizable controls to define your policies, you can evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.

See \url{https://www.paws-r-sdk.com/docs/backup_create_framework/} for full documentation.
}
\keyword{internal}
