% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_create_file_system}
\alias{fsx_create_file_system}
\title{Creates a new, empty Amazon FSx file system}
\usage{
fsx_create_file_system(
  ClientRequestToken = NULL,
  FileSystemType,
  StorageCapacity,
  StorageType = NULL,
  SubnetIds,
  SecurityGroupIds = NULL,
  Tags = NULL,
  KmsKeyId = NULL,
  WindowsConfiguration = NULL,
  LustreConfiguration = NULL,
  OntapConfiguration = NULL,
  FileSystemTypeVersion = NULL,
  OpenZFSConfiguration = NULL
)
}
\arguments{
\item{ClientRequestToken}{A string of up to 63 ASCII characters that Amazon FSx uses to ensure
idempotent creation. This string is automatically filled on your behalf
when you use the Command Line Interface (CLI) or an Amazon Web Services
SDK.}

\item{FileSystemType}{[required] The type of Amazon FSx file system to create. Valid values are
\code{WINDOWS}, \code{LUSTRE}, \code{ONTAP}, and \code{OPENZFS}.}

\item{StorageCapacity}{[required] Sets the storage capacity of the file system that you're creating, in
gibibytes (GiB).

\strong{FSx for Lustre file systems} - The amount of storage capacity that
you can configure depends on the value that you set for \code{StorageType}
and the Lustre \code{DeploymentType}, as follows:
\itemize{
\item For \code{SCRATCH_2}, \code{PERSISTENT_2} and \code{PERSISTENT_1} deployment types
using SSD storage type, the valid values are 1200 GiB, 2400 GiB, and
increments of 2400 GiB.
\item For \code{PERSISTENT_1} HDD file systems, valid values are increments of
6000 GiB for 12 MB/s/TiB file systems and increments of 1800 GiB for
40 MB/s/TiB file systems.
\item For \code{SCRATCH_1} deployment type, valid values are 1200 GiB, 2400
GiB, and increments of 3600 GiB.
}

\strong{FSx for ONTAP file systems} - The amount of storage capacity that you
can configure depends on the value of the \code{HAPairs} property. The
minimum value is calculated as 1,024 * \code{HAPairs} and the maxium is
calculated as 524,288 * \code{HAPairs}..

\strong{FSx for OpenZFS file systems} - The amount of storage capacity that
you can configure is from 64 GiB up to 524,288 GiB (512 TiB).

\strong{FSx for Windows File Server file systems} - The amount of storage
capacity that you can configure depends on the value that you set for
\code{StorageType} as follows:
\itemize{
\item For SSD storage, valid values are 32 GiB-65,536 GiB (64 TiB).
\item For HDD storage, valid values are 2000 GiB-65,536 GiB (64 TiB).
}}

\item{StorageType}{Sets the storage type for the file system that you're creating. Valid
values are \code{SSD} and \code{HDD}.
\itemize{
\item Set to \code{SSD} to use solid state drive storage. SSD is supported on
all Windows, Lustre, ONTAP, and OpenZFS deployment types.
\item Set to \code{HDD} to use hard disk drive storage. HDD is supported on
\code{SINGLE_AZ_2} and \code{MULTI_AZ_1} Windows file system deployment types,
and on \code{PERSISTENT_1} Lustre file system deployment types.
}

Default value is \code{SSD}. For more information, see \href{https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options}{Storage type options}
in the \emph{FSx for Windows File Server User Guide} and \href{https://docs.aws.amazon.com/fsx/latest/LustreGuide/what-is.html#storage-options}{Multiple storage options}
in the \emph{FSx for Lustre User Guide}.}

\item{SubnetIds}{[required] Specifies the IDs of the subnets that the file system will be accessible
from. For Windows and ONTAP \code{MULTI_AZ_1} deployment types,provide
exactly two subnet IDs, one for the preferred file server and one for
the standby file server. You specify one of these subnets as the
preferred subnet using the \code{WindowsConfiguration > PreferredSubnetID} or
\code{OntapConfiguration > PreferredSubnetID} properties. For more
information about Multi-AZ file system configuration, see \href{https://docs.aws.amazon.com/fsx/latest/WindowsGuide/high-availability-multiAZ.html}{Availability and durability: Single-AZ and Multi-AZ file systems}
in the \emph{Amazon FSx for Windows User Guide} and \href{https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/}{Availability and durability} in the
\emph{Amazon FSx for ONTAP User Guide}.

For Windows \code{SINGLE_AZ_1} and \code{SINGLE_AZ_2} and all Lustre deployment
types, provide exactly one subnet ID. The file server is launched in
that subnet's Availability Zone.}

\item{SecurityGroupIds}{A list of IDs specifying the security groups to apply to all network
interfaces created for file system access. This list isn't returned in
later requests to describe the file system.}

\item{Tags}{The tags to apply to the file system that's being created. The key value
of the \code{Name} tag appears in the console as the file system name.}

\item{KmsKeyId}{}

\item{WindowsConfiguration}{The Microsoft Windows configuration for the file system that's being
created.}

\item{LustreConfiguration}{}

\item{OntapConfiguration}{}

\item{FileSystemTypeVersion}{(Optional) For FSx for Lustre file systems, sets the Lustre version for
the file system that you're creating. Valid values are \code{2.10}, \code{2.12},
and \code{2.15}:
\itemize{
\item 2.10 is supported by the Scratch and Persistent_1 Lustre deployment
types.
\item 2.12 and 2.15 are supported by all Lustre deployment types. \code{2.12}
or \code{2.15} is required when setting FSx for Lustre \code{DeploymentType}
to \code{PERSISTENT_2}.
}

Default value = \code{2.10}, except when \code{DeploymentType} is set to
\code{PERSISTENT_2}, then the default is \code{2.12}.

If you set \code{FileSystemTypeVersion} to \code{2.10} for a \code{PERSISTENT_2} Lustre
deployment type, the \code{\link[=fsx_create_file_system]{create_file_system}}
operation fails.}

\item{OpenZFSConfiguration}{The OpenZFS configuration for the file system that's being created.}
}
\description{
Creates a new, empty Amazon FSx file system. You can create the following supported Amazon FSx file systems using the \code{\link[=fsx_create_file_system]{create_file_system}} API operation:

See \url{https://www.paws-r-sdk.com/docs/fsx_create_file_system/} for full documentation.
}
\keyword{internal}
