% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_submit_multi_region_access_point_routes}
\alias{s3control_submit_multi_region_access_point_routes}
\title{Submits an updated route configuration for a Multi-Region Access Point}
\usage{
s3control_submit_multi_region_access_point_routes(
  AccountId,
  Mrap,
  RouteUpdates
)
}
\arguments{
\item{AccountId}{[required] The Amazon Web Services account ID for the owner of the Multi-Region
Access Point.}

\item{Mrap}{[required] The Multi-Region Access Point ARN.}

\item{RouteUpdates}{[required] The different routes that make up the new route configuration. Active
routes return a value of \code{100}, and passive routes return a value of
\code{0}.}
}
\description{
Submits an updated route configuration for a Multi-Region Access Point. This API operation updates the routing status for the specified Regions from active to passive, or from passive to active. A value of \code{0} indicates a passive status, which means that traffic won't be routed to the specified Region. A value of \code{100} indicates an active status, which means that traffic will be routed to the specified Region. At least one Region must be active at all times.

See \url{https://www.paws-r-sdk.com/docs/s3control_submit_multi_region_access_point_routes/} for full documentation.
}
\keyword{internal}
