% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_update_maintenance_start_time}
\alias{storagegateway_update_maintenance_start_time}
\title{Updates a gateway's weekly maintenance start time information, including
day and time of the week}
\usage{
storagegateway_update_maintenance_start_time(GatewayARN, HourOfDay,
  MinuteOfHour, DayOfWeek, DayOfMonth)
}
\arguments{
\item{GatewayARN}{[required]}

\item{HourOfDay}{[required] The hour component of the maintenance start time represented as \emph{hh},
where \emph{hh} is the hour (00 to 23). The hour of the day is in the time
zone of the gateway.}

\item{MinuteOfHour}{[required] The minute component of the maintenance start time represented as \emph{mm},
where \emph{mm} is the minute (00 to 59). The minute of the hour is in the
time zone of the gateway.}

\item{DayOfWeek}{The day of the week component of the maintenance start time week
represented as an ordinal number from 0 to 6, where 0 represents Sunday
and 6 Saturday.}

\item{DayOfMonth}{The day of the month component of the maintenance start time represented
as an ordinal number from 1 to 28, where 1 represents the first day of
the month and 28 represents the last day of the month.

This value is only available for tape and volume gateways.}
}
\description{
Updates a gateway\'s weekly maintenance start time information,
including day and time of the week. The maintenance time is the time in
your gateway\'s time zone.
}
\section{Request syntax}{
\preformatted{svc$update_maintenance_start_time(
  GatewayARN = "string",
  HourOfDay = 123,
  MinuteOfHour = 123,
  DayOfWeek = 123,
  DayOfMonth = 123
)
}
}

\examples{
# Updates a gateway's weekly maintenance start time information, including
# day and time of the week. The maintenance time is in your gateway's time
# zone.
\donttest{svc$update_maintenance_start_time(
  DayOfWeek = 2L,
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B",
  HourOfDay = 0L,
  MinuteOfHour = 30L
)}

}
\keyword{internal}
