% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_update_chap_credentials}
\alias{storagegateway_update_chap_credentials}
\title{Updates the Challenge-Handshake Authentication Protocol (CHAP)
credentials for a specified iSCSI target}
\usage{
storagegateway_update_chap_credentials(TargetARN,
  SecretToAuthenticateInitiator, InitiatorName,
  SecretToAuthenticateTarget)
}
\arguments{
\item{TargetARN}{[required] The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
DescribeStorediSCSIVolumes operation to return the TargetARN for
specified VolumeARN.}

\item{SecretToAuthenticateInitiator}{[required] The secret key that the initiator (for example, the Windows client) must
provide to participate in mutual CHAP with the target.

The secret key must be between 12 and 16 bytes when encoded in UTF-8.}

\item{InitiatorName}{[required] The iSCSI initiator that connects to the target.}

\item{SecretToAuthenticateTarget}{The secret key that the target must provide to participate in mutual
CHAP with the initiator (e.g. Windows client).

Byte constraints: Minimum bytes of 12. Maximum bytes of 16.

The secret key must be between 12 and 16 bytes when encoded in UTF-8.}
}
\description{
Updates the Challenge-Handshake Authentication Protocol (CHAP)
credentials for a specified iSCSI target. By default, a gateway does not
have CHAP enabled; however, for added security, you might use it. This
operation is supported in the volume and tape gateway types.
}
\details{
When you update CHAP credentials, all existing connections on the target
are closed and initiators must reconnect with the new credentials.
}
\section{Request syntax}{
\preformatted{svc$update_chap_credentials(
  TargetARN = "string",
  SecretToAuthenticateInitiator = "string",
  InitiatorName = "string",
  SecretToAuthenticateTarget = "string"
)
}
}

\examples{
# Updates the Challenge-Handshake Authentication Protocol (CHAP)
# credentials for a specified iSCSI target.
\donttest{svc$update_chap_credentials(
  InitiatorName = "iqn.1991-05.com.microsoft:computername.domain.example.com",
  SecretToAuthenticateInitiator = "111111111111",
  SecretToAuthenticateTarget = "222222222222",
  TargetARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/target/iqn..."
)}

}
\keyword{internal}
