% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_create_bucket}
\alias{s3_create_bucket}
\title{Creates a new bucket}
\usage{
s3_create_bucket(ACL, Bucket, CreateBucketConfiguration,
  GrantFullControl, GrantRead, GrantReadACP, GrantWrite, GrantWriteACP,
  ObjectLockEnabledForBucket)
}
\arguments{
\item{ACL}{The canned ACL to apply to the bucket.}

\item{Bucket}{[required] The name of the bucket to create.}

\item{CreateBucketConfiguration}{The configuration information for the bucket.}

\item{GrantFullControl}{Allows grantee the read, write, read ACP, and write ACP permissions on
the bucket.}

\item{GrantRead}{Allows grantee to list the objects in the bucket.}

\item{GrantReadACP}{Allows grantee to read the bucket ACL.}

\item{GrantWrite}{Allows grantee to create, overwrite, and delete any object in the
bucket.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable bucket.}

\item{ObjectLockEnabledForBucket}{Specifies whether you want S3 Object Lock to be enabled for the new
bucket.}
}
\description{
Creates a new bucket. To create a bucket, you must register with Amazon
S3 and have a valid AWS Access Key ID to authenticate requests.
Anonymous requests are never allowed to create buckets. By creating the
bucket, you become the bucket owner.
}
\details{
Not every string is an acceptable bucket name. For information on bucket
naming restrictions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html}{Working with Amazon S3 Buckets}.

By default, the bucket is created in the US East (N. Virginia) Region.
You can optionally specify a Region in the request body. You might
choose a Region to optimize latency, minimize costs, or address
regulatory requirements. For example, if you reside in Europe, you will
probably find it advantageous to create buckets in the EU (Ireland)
Region. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingBucket.html#access-bucket-intro}{How to Select a Region for Your Buckets}.

If you send your create bucket request to the \code{s3.amazonaws.com}
endpoint, the request goes to the us-east-1 Region. Accordingly, the
signature calculations in Signature Version 4 must use us-east-1 as the
Region, even if the location constraint in the request specifies another
Region where the bucket is to be created. If you create a bucket in a
Region other than US East (N. Virginia), your application must be able
to handle 307 redirect. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/VirtualHosting.html}{Virtual Hosting of Buckets}.

When creating a bucket using this operation, you can optionally specify
the accounts or groups that should be granted specific permissions on
the bucket. There are two ways to grant the appropriate permissions
using the request headers.
\itemize{
\item Specify a canned ACL using the \code{x-amz-acl} request header. Amazon S3
supports a set of predefined ACLs, known as \emph{canned ACLs}. Each
canned ACL has a predefined set of grantees and permissions. For
more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#CannedACL}{Canned ACL}.
\item Specify access permissions explicitly using the \code{x-amz-grant-read},
\code{x-amz-grant-write}, \code{x-amz-grant-read-acp},
\code{x-amz-grant-write-acp}, and \code{x-amz-grant-full-control} headers.
These headers map to the set of permissions Amazon S3 supports in an
ACL. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html}{Access Control List (ACL) Overview}.

You specify each grantee as a type=value pair, where the type is one
of the following:
\itemize{
\item \code{emailAddress} -- if the value specified is the email address of
an AWS account
\item \code{id} -- if the value specified is the canonical user ID of an
AWS account
\item \code{uri} -- if you are granting permissions to a predefined group
}

For example, the following \code{x-amz-grant-read} header grants the AWS
accounts identified by email addresses permissions to read object
data and its metadata:

\verb{x-amz-grant-read: emailAddress="xyz@amazon.com", emailAddress="abc@amazon.com" }
}

You can use either a canned ACL or specify access permissions
explicitly. You cannot do both.

The following operations are related to \code{CreateBucket}:
\itemize{
\item PutObject
\item DeleteBucket
}
}
\section{Request syntax}{
\preformatted{svc$create_bucket(
  ACL = "private"|"public-read"|"public-read-write"|"authenticated-read",
  Bucket = "string",
  CreateBucketConfiguration = list(
    LocationConstraint = "EU"|"eu-west-1"|"us-west-1"|"us-west-2"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"sa-east-1"|"cn-north-1"|"eu-central-1"
  ),
  GrantFullControl = "string",
  GrantRead = "string",
  GrantReadACP = "string",
  GrantWrite = "string",
  GrantWriteACP = "string",
  ObjectLockEnabledForBucket = TRUE|FALSE
)
}
}

\examples{
# The following example creates a bucket.
\donttest{svc$create_bucket(
  Bucket = "examplebucket"
)}

# The following example creates a bucket. The request specifies an AWS
# region where to create the bucket.
\donttest{svc$create_bucket(
  Bucket = "examplebucket",
  CreateBucketConfiguration = list(
    LocationConstraint = "eu-west-1"
  )
)}

}
\keyword{internal}
