% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_list_recovery_points_by_resource}
\alias{backup_list_recovery_points_by_resource}
\title{Returns detailed information about recovery points of the type specified
by a resource Amazon Resource Name (ARN)}
\usage{
backup_list_recovery_points_by_resource(ResourceArn, NextToken,
  MaxResults)
}
\arguments{
\item{ResourceArn}{[required] An ARN that uniquely identifies a resource. The format of the ARN
depends on the resource type.}

\item{NextToken}{The next item following a partial list of returned items. For example,
if a request is made to return \code{maxResults} number of items, \code{NextToken}
allows you to return more items in your list starting at the location
pointed to by the next token.}

\item{MaxResults}{The maximum number of items to be returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  NextToken = "string",
  RecoveryPoints = list(
    list(
      RecoveryPointArn = "string",
      CreationDate = as.POSIXct(
        "2015-01-01"
      ),
      Status = "COMPLETED"|"PARTIAL"|"DELETING"|"EXPIRED",
      EncryptionKeyArn = "string",
      BackupSizeBytes = 123,
      BackupVaultName = "string"
    )
  )
)
}
}
\description{
Returns detailed information about recovery points of the type specified
by a resource Amazon Resource Name (ARN).
}
\section{Request syntax}{
\preformatted{svc$list_recovery_points_by_resource(
  ResourceArn = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
