% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_tapes}
\alias{storagegateway_describe_tapes}
\title{Returns a description of the specified Amazon Resource Name (ARN) of
virtual tapes}
\usage{
storagegateway_describe_tapes(GatewayARN, TapeARNs, Marker, Limit)
}
\arguments{
\item{GatewayARN}{[required]}

\item{TapeARNs}{Specifies one or more unique Amazon Resource Names (ARNs) that represent
the virtual tapes you want to describe. If this parameter is not
specified, Tape gateway returns a description of all virtual tapes
associated with the specified gateway.}

\item{Marker}{A marker value, obtained in a previous call to \code{DescribeTapes}. This
marker indicates which page of results to retrieve.

If not specified, the first page of results is retrieved.}

\item{Limit}{Specifies that the number of virtual tapes described be limited to the
specified number.

Amazon Web Services may impose its own limit, if this field is not set.}
}
\description{
Returns a description of the specified Amazon Resource Name (ARN) of
virtual tapes. If a \code{TapeARN} is not specified, returns a description of
all virtual tapes associated with the specified gateway. This operation
is only supported in the tape gateway type.
}
\section{Request syntax}{
\preformatted{svc$describe_tapes(
  GatewayARN = "string",
  TapeARNs = list(
    "string"
  ),
  Marker = "string",
  Limit = 123
)
}
}

\examples{
\dontrun{
# Returns a description of the specified Amazon Resource Name (ARN) of
# virtual tapes. If a TapeARN is not specified, returns a description of
# all virtual tapes.
svc$describe_tapes(
  GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B",
  Limit = 2L,
  Marker = "1",
  TapeARNs = list(
    "arn:aws:storagegateway:us-east-1:999999999999:tape/TEST04A2A1",
    "arn:aws:storagegateway:us-east-1:999999999999:tape/TEST05A2A0"
  )
)
}

}
\keyword{internal}
