% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_get_findings_statistics}
\alias{guardduty_get_findings_statistics}
\title{Lists GuardDuty findings statistics for the specified detector ID}
\usage{
guardduty_get_findings_statistics(
  DetectorId,
  FindingStatisticTypes = NULL,
  FindingCriteria = NULL,
  GroupBy = NULL,
  OrderBy = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{DetectorId}{[required] The ID of the detector whose findings statistics you want to retrieve.

To find the \code{detectorId} in the current Region, see the Settings page in
the GuardDuty console, or run the
\code{\link[=guardduty_list_detectors]{list_detectors}} API.}

\item{FindingStatisticTypes}{The types of finding statistics to retrieve.}

\item{FindingCriteria}{Represents the criteria that is used for querying findings.}

\item{GroupBy}{Displays the findings statistics grouped by one of the listed valid
values.}

\item{OrderBy}{Displays the sorted findings in the requested order. The default value
of \code{orderBy} is \code{DESC}.

You can use this parameter only with the \code{groupBy} parameter.}

\item{MaxResults}{The maximum number of results to be returned in the response. The
default value is 25.

You can use this parameter only with the \code{groupBy} parameter.}
}
\description{
Lists GuardDuty findings statistics for the specified detector ID.

See \url{https://www.paws-r-sdk.com/docs/guardduty_get_findings_statistics/} for full documentation.
}
\keyword{internal}
