# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include securitylake_service.R
NULL

#' Adds a natively supported Amazon Web Services service as an Amazon
#' Security Lake source
#'
#' @description
#' Adds a natively supported Amazon Web Services service as an Amazon Security Lake source. Enables source types for member accounts in required Amazon Web Services Regions, based on the parameters you specify. You can choose any source type in any Region for either accounts that are part of a trusted organization or standalone accounts. Once you add an Amazon Web Services service as a source, Security Lake starts collecting logs and events from it.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_create_aws_log_source/](https://www.paws-r-sdk.com/docs/securitylake_create_aws_log_source/) for full documentation.
#'
#' @param sources &#91;required&#93; Specify the natively-supported Amazon Web Services service to add as a
#' source in Security Lake.
#'
#' @keywords internal
#'
#' @rdname securitylake_create_aws_log_source
securitylake_create_aws_log_source <- function(sources) {
  op <- new_operation(
    name = "CreateAwsLogSource",
    http_method = "POST",
    http_path = "/v1/datalake/logsources/aws",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$create_aws_log_source_input(sources = sources)
  output <- .securitylake$create_aws_log_source_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$create_aws_log_source <- securitylake_create_aws_log_source

#' Adds a third-party custom source in Amazon Security Lake, from the
#' Amazon Web Services Region where you want to create a custom source
#'
#' @description
#' Adds a third-party custom source in Amazon Security Lake, from the Amazon Web Services Region where you want to create a custom source. Security Lake can collect logs and events from third-party custom sources. After creating the appropriate IAM role to invoke Glue crawler, use this API to add a custom source name in Security Lake. This operation creates a partition in the Amazon S3 bucket for Security Lake as the target location for log files from the custom source. In addition, this operation also creates an associated Glue table and an Glue crawler.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_create_custom_log_source/](https://www.paws-r-sdk.com/docs/securitylake_create_custom_log_source/) for full documentation.
#'
#' @param configuration &#91;required&#93; The configuration used for the third-party custom source.
#' @param eventClasses The Open Cybersecurity Schema Framework (OCSF) event classes which
#' describes the type of data that the custom source will send to Security
#' Lake. For the list of supported event classes, see the [Amazon Security
#' Lake User
#' Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/adding-custom-sources.html#ocsf-eventclass).
#' @param sourceName &#91;required&#93; Specify the name for a third-party custom source. This must be a
#' Regionally unique value. The `sourceName` you enter here, is used in the
#' `LogProviderRole` name which follows the convention
#' `AmazonSecurityLake-Provider-{name of the custom source}-{region}`. You
#' must use a `CustomLogSource` name that is shorter than or equal to 20
#' characters. This ensures that the `LogProviderRole` name is below the 64
#' character limit.
#' @param sourceVersion Specify the source version for the third-party custom source, to limit
#' log collection to a specific version of custom data source.
#'
#' @keywords internal
#'
#' @rdname securitylake_create_custom_log_source
securitylake_create_custom_log_source <- function(configuration, eventClasses = NULL, sourceName, sourceVersion = NULL) {
  op <- new_operation(
    name = "CreateCustomLogSource",
    http_method = "POST",
    http_path = "/v1/datalake/logsources/custom",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$create_custom_log_source_input(configuration = configuration, eventClasses = eventClasses, sourceName = sourceName, sourceVersion = sourceVersion)
  output <- .securitylake$create_custom_log_source_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$create_custom_log_source <- securitylake_create_custom_log_source

#' Initializes an Amazon Security Lake instance with the provided (or
#' default) configuration
#'
#' @description
#' Initializes an Amazon Security Lake instance with the provided (or default) configuration. You can enable Security Lake in Amazon Web Services Regions with customized settings before enabling log collection in Regions. To specify particular Regions, configure these Regions using the `configurations` parameter. If you have already enabled Security Lake in a Region when you call this command, the command will update the Region if you provide new configuration parameters. If you have not already enabled Security Lake in the Region when you call this API, it will set up the data lake in the Region with the specified configurations.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_create_data_lake/](https://www.paws-r-sdk.com/docs/securitylake_create_data_lake/) for full documentation.
#'
#' @param configurations &#91;required&#93; Specify the Region or Regions that will contribute data to the rollup
#' region.
#' @param metaStoreManagerRoleArn &#91;required&#93; The Amazon Resource Name (ARN) used to create and update the Glue table.
#' This table contains partitions generated by the ingestion and
#' normalization of Amazon Web Services log sources and custom sources.
#' @param tags An array of objects, one for each tag to associate with the data lake
#' configuration. For each tag, you must specify both a tag key and a tag
#' value. A tag value cannot be null, but it can be an empty string.
#'
#' @keywords internal
#'
#' @rdname securitylake_create_data_lake
securitylake_create_data_lake <- function(configurations, metaStoreManagerRoleArn, tags = NULL) {
  op <- new_operation(
    name = "CreateDataLake",
    http_method = "POST",
    http_path = "/v1/datalake",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$create_data_lake_input(configurations = configurations, metaStoreManagerRoleArn = metaStoreManagerRoleArn, tags = tags)
  output <- .securitylake$create_data_lake_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$create_data_lake <- securitylake_create_data_lake

#' Creates the specified notification subscription in Amazon Security Lake
#' for the organization you specify
#'
#' @description
#' Creates the specified notification subscription in Amazon Security Lake for the organization you specify. The notification subscription is created for exceptions that cannot be resolved by Security Lake automatically.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_create_data_lake_exception_subscription/](https://www.paws-r-sdk.com/docs/securitylake_create_data_lake_exception_subscription/) for full documentation.
#'
#' @param exceptionTimeToLive The expiration period and time-to-live (TTL). It is the duration of time
#' until which the exception message remains.
#' @param notificationEndpoint &#91;required&#93; The Amazon Web Services account where you want to receive exception
#' notifications.
#' @param subscriptionProtocol &#91;required&#93; The subscription protocol to which exception notifications are posted.
#'
#' @keywords internal
#'
#' @rdname securitylake_create_data_lake_exception_subscription
securitylake_create_data_lake_exception_subscription <- function(exceptionTimeToLive = NULL, notificationEndpoint, subscriptionProtocol) {
  op <- new_operation(
    name = "CreateDataLakeExceptionSubscription",
    http_method = "POST",
    http_path = "/v1/datalake/exceptions/subscription",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$create_data_lake_exception_subscription_input(exceptionTimeToLive = exceptionTimeToLive, notificationEndpoint = notificationEndpoint, subscriptionProtocol = subscriptionProtocol)
  output <- .securitylake$create_data_lake_exception_subscription_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$create_data_lake_exception_subscription <- securitylake_create_data_lake_exception_subscription

#' Automatically enables Amazon Security Lake for new member accounts in
#' your organization
#'
#' @description
#' Automatically enables Amazon Security Lake for new member accounts in your organization. Security Lake is not automatically enabled for any existing member accounts in your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_create_data_lake_organization_configuration/](https://www.paws-r-sdk.com/docs/securitylake_create_data_lake_organization_configuration/) for full documentation.
#'
#' @param autoEnableNewAccount Enable Security Lake with the specified configuration settings, to begin
#' collecting security data for new accounts in your organization.
#'
#' @keywords internal
#'
#' @rdname securitylake_create_data_lake_organization_configuration
securitylake_create_data_lake_organization_configuration <- function(autoEnableNewAccount = NULL) {
  op <- new_operation(
    name = "CreateDataLakeOrganizationConfiguration",
    http_method = "POST",
    http_path = "/v1/datalake/organization/configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$create_data_lake_organization_configuration_input(autoEnableNewAccount = autoEnableNewAccount)
  output <- .securitylake$create_data_lake_organization_configuration_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$create_data_lake_organization_configuration <- securitylake_create_data_lake_organization_configuration

#' Creates a subscriber for accounts that are already enabled in Amazon
#' Security Lake
#'
#' @description
#' Creates a subscriber for accounts that are already enabled in Amazon Security Lake. You can create a subscriber with access to data in the current Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_create_subscriber/](https://www.paws-r-sdk.com/docs/securitylake_create_subscriber/) for full documentation.
#'
#' @param accessTypes The Amazon S3 or Lake Formation access type.
#' @param sources &#91;required&#93; The supported Amazon Web Services services from which logs and events
#' are collected. Security Lake supports log and event collection for
#' natively supported Amazon Web Services services.
#' @param subscriberDescription The description for your subscriber account in Security Lake.
#' @param subscriberIdentity &#91;required&#93; The Amazon Web Services identity used to access your data.
#' @param subscriberName &#91;required&#93; The name of your Security Lake subscriber account.
#' @param tags An array of objects, one for each tag to associate with the subscriber.
#' For each tag, you must specify both a tag key and a tag value. A tag
#' value cannot be null, but it can be an empty string.
#'
#' @keywords internal
#'
#' @rdname securitylake_create_subscriber
securitylake_create_subscriber <- function(accessTypes = NULL, sources, subscriberDescription = NULL, subscriberIdentity, subscriberName, tags = NULL) {
  op <- new_operation(
    name = "CreateSubscriber",
    http_method = "POST",
    http_path = "/v1/subscribers",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$create_subscriber_input(accessTypes = accessTypes, sources = sources, subscriberDescription = subscriberDescription, subscriberIdentity = subscriberIdentity, subscriberName = subscriberName, tags = tags)
  output <- .securitylake$create_subscriber_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$create_subscriber <- securitylake_create_subscriber

#' Notifies the subscriber when new data is written to the data lake for
#' the sources that the subscriber consumes in Security Lake
#'
#' @description
#' Notifies the subscriber when new data is written to the data lake for the sources that the subscriber consumes in Security Lake. You can create only one subscriber notification per subscriber.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_create_subscriber_notification/](https://www.paws-r-sdk.com/docs/securitylake_create_subscriber_notification/) for full documentation.
#'
#' @param configuration &#91;required&#93; Specify the configuration using which you want to create the subscriber
#' notification.
#' @param subscriberId &#91;required&#93; The subscriber ID for the notification subscription.
#'
#' @keywords internal
#'
#' @rdname securitylake_create_subscriber_notification
securitylake_create_subscriber_notification <- function(configuration, subscriberId) {
  op <- new_operation(
    name = "CreateSubscriberNotification",
    http_method = "POST",
    http_path = "/v1/subscribers/{subscriberId}/notification",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$create_subscriber_notification_input(configuration = configuration, subscriberId = subscriberId)
  output <- .securitylake$create_subscriber_notification_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$create_subscriber_notification <- securitylake_create_subscriber_notification

#' Removes a natively supported Amazon Web Services service as an Amazon
#' Security Lake source
#'
#' @description
#' Removes a natively supported Amazon Web Services service as an Amazon Security Lake source. You can remove a source for one or more Regions. When you remove the source, Security Lake stops collecting data from that source in the specified Regions and accounts, and subscribers can no longer consume new data from the source. However, subscribers can still consume data that Security Lake collected from the source before removal.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_delete_aws_log_source/](https://www.paws-r-sdk.com/docs/securitylake_delete_aws_log_source/) for full documentation.
#'
#' @param sources &#91;required&#93; Specify the natively-supported Amazon Web Services service to remove as
#' a source in Security Lake.
#'
#' @keywords internal
#'
#' @rdname securitylake_delete_aws_log_source
securitylake_delete_aws_log_source <- function(sources) {
  op <- new_operation(
    name = "DeleteAwsLogSource",
    http_method = "POST",
    http_path = "/v1/datalake/logsources/aws/delete",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$delete_aws_log_source_input(sources = sources)
  output <- .securitylake$delete_aws_log_source_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$delete_aws_log_source <- securitylake_delete_aws_log_source

#' Removes a custom log source from Amazon Security Lake, to stop sending
#' data from the custom source to Security Lake
#'
#' @description
#' Removes a custom log source from Amazon Security Lake, to stop sending data from the custom source to Security Lake.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_delete_custom_log_source/](https://www.paws-r-sdk.com/docs/securitylake_delete_custom_log_source/) for full documentation.
#'
#' @param sourceName &#91;required&#93; The source name of custom log source that you want to delete.
#' @param sourceVersion The source version for the third-party custom source. You can limit the
#' custom source removal to the specified source version.
#'
#' @keywords internal
#'
#' @rdname securitylake_delete_custom_log_source
securitylake_delete_custom_log_source <- function(sourceName, sourceVersion = NULL) {
  op <- new_operation(
    name = "DeleteCustomLogSource",
    http_method = "DELETE",
    http_path = "/v1/datalake/logsources/custom/{sourceName}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$delete_custom_log_source_input(sourceName = sourceName, sourceVersion = sourceVersion)
  output <- .securitylake$delete_custom_log_source_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$delete_custom_log_source <- securitylake_delete_custom_log_source

#' When you disable Amazon Security Lake from your account, Security Lake
#' is disabled in all Amazon Web Services Regions and it stops collecting
#' data from your sources
#'
#' @description
#' When you disable Amazon Security Lake from your account, Security Lake is disabled in all Amazon Web Services Regions and it stops collecting data from your sources. Also, this API automatically takes steps to remove the account from Security Lake. However, Security Lake retains all of your existing settings and the resources that it created in your Amazon Web Services account in the current Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_delete_data_lake/](https://www.paws-r-sdk.com/docs/securitylake_delete_data_lake/) for full documentation.
#'
#' @param regions &#91;required&#93; The list of Regions where Security Lake is enabled.
#'
#' @keywords internal
#'
#' @rdname securitylake_delete_data_lake
securitylake_delete_data_lake <- function(regions) {
  op <- new_operation(
    name = "DeleteDataLake",
    http_method = "POST",
    http_path = "/v1/datalake/delete",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$delete_data_lake_input(regions = regions)
  output <- .securitylake$delete_data_lake_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$delete_data_lake <- securitylake_delete_data_lake

#' Deletes the specified notification subscription in Amazon Security Lake
#' for the organization you specify
#'
#' @description
#' Deletes the specified notification subscription in Amazon Security Lake for the organization you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_delete_data_lake_exception_subscription/](https://www.paws-r-sdk.com/docs/securitylake_delete_data_lake_exception_subscription/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname securitylake_delete_data_lake_exception_subscription
securitylake_delete_data_lake_exception_subscription <- function() {
  op <- new_operation(
    name = "DeleteDataLakeExceptionSubscription",
    http_method = "DELETE",
    http_path = "/v1/datalake/exceptions/subscription",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$delete_data_lake_exception_subscription_input()
  output <- .securitylake$delete_data_lake_exception_subscription_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$delete_data_lake_exception_subscription <- securitylake_delete_data_lake_exception_subscription

#' Turns off automatic enablement of Amazon Security Lake for member
#' accounts that are added to an organization in Organizations
#'
#' @description
#' Turns off automatic enablement of Amazon Security Lake for member accounts that are added to an organization in Organizations. Only the delegated Security Lake administrator for an organization can perform this operation. If the delegated Security Lake administrator performs this operation, new member accounts won't automatically contribute data to the data lake.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_delete_data_lake_organization_configuration/](https://www.paws-r-sdk.com/docs/securitylake_delete_data_lake_organization_configuration/) for full documentation.
#'
#' @param autoEnableNewAccount Turns off automatic enablement of Security Lake for member accounts that
#' are added to an organization.
#'
#' @keywords internal
#'
#' @rdname securitylake_delete_data_lake_organization_configuration
securitylake_delete_data_lake_organization_configuration <- function(autoEnableNewAccount = NULL) {
  op <- new_operation(
    name = "DeleteDataLakeOrganizationConfiguration",
    http_method = "POST",
    http_path = "/v1/datalake/organization/configuration/delete",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$delete_data_lake_organization_configuration_input(autoEnableNewAccount = autoEnableNewAccount)
  output <- .securitylake$delete_data_lake_organization_configuration_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$delete_data_lake_organization_configuration <- securitylake_delete_data_lake_organization_configuration

#' Deletes the subscription permission and all notification settings for
#' accounts that are already enabled in Amazon Security Lake
#'
#' @description
#' Deletes the subscription permission and all notification settings for accounts that are already enabled in Amazon Security Lake. When you run [`delete_subscriber`][securitylake_delete_subscriber], the subscriber will no longer consume data from Security Lake and the subscriber is removed. This operation deletes the subscriber and removes access to data in the current Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_delete_subscriber/](https://www.paws-r-sdk.com/docs/securitylake_delete_subscriber/) for full documentation.
#'
#' @param subscriberId &#91;required&#93; A value created by Security Lake that uniquely identifies your
#' [`delete_subscriber`][securitylake_delete_subscriber] API request.
#'
#' @keywords internal
#'
#' @rdname securitylake_delete_subscriber
securitylake_delete_subscriber <- function(subscriberId) {
  op <- new_operation(
    name = "DeleteSubscriber",
    http_method = "DELETE",
    http_path = "/v1/subscribers/{subscriberId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$delete_subscriber_input(subscriberId = subscriberId)
  output <- .securitylake$delete_subscriber_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$delete_subscriber <- securitylake_delete_subscriber

#' Deletes the specified subscription notification in Amazon Security Lake
#' for the organization you specify
#'
#' @description
#' Deletes the specified subscription notification in Amazon Security Lake for the organization you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_delete_subscriber_notification/](https://www.paws-r-sdk.com/docs/securitylake_delete_subscriber_notification/) for full documentation.
#'
#' @param subscriberId &#91;required&#93; The ID of the Security Lake subscriber account.
#'
#' @keywords internal
#'
#' @rdname securitylake_delete_subscriber_notification
securitylake_delete_subscriber_notification <- function(subscriberId) {
  op <- new_operation(
    name = "DeleteSubscriberNotification",
    http_method = "DELETE",
    http_path = "/v1/subscribers/{subscriberId}/notification",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$delete_subscriber_notification_input(subscriberId = subscriberId)
  output <- .securitylake$delete_subscriber_notification_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$delete_subscriber_notification <- securitylake_delete_subscriber_notification

#' Deletes the Amazon Security Lake delegated administrator account for the
#' organization
#'
#' @description
#' Deletes the Amazon Security Lake delegated administrator account for the organization. This API can only be called by the organization management account. The organization management account cannot be the delegated administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_deregister_data_lake_delegated_administrator/](https://www.paws-r-sdk.com/docs/securitylake_deregister_data_lake_delegated_administrator/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname securitylake_deregister_data_lake_delegated_administrator
securitylake_deregister_data_lake_delegated_administrator <- function() {
  op <- new_operation(
    name = "DeregisterDataLakeDelegatedAdministrator",
    http_method = "DELETE",
    http_path = "/v1/datalake/delegate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$deregister_data_lake_delegated_administrator_input()
  output <- .securitylake$deregister_data_lake_delegated_administrator_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$deregister_data_lake_delegated_administrator <- securitylake_deregister_data_lake_delegated_administrator

#' Retrieves the protocol and endpoint that were provided when subscribing
#' to Amazon SNS topics for exception notifications
#'
#' @description
#' Retrieves the protocol and endpoint that were provided when subscribing to Amazon SNS topics for exception notifications.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_get_data_lake_exception_subscription/](https://www.paws-r-sdk.com/docs/securitylake_get_data_lake_exception_subscription/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname securitylake_get_data_lake_exception_subscription
securitylake_get_data_lake_exception_subscription <- function() {
  op <- new_operation(
    name = "GetDataLakeExceptionSubscription",
    http_method = "GET",
    http_path = "/v1/datalake/exceptions/subscription",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$get_data_lake_exception_subscription_input()
  output <- .securitylake$get_data_lake_exception_subscription_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$get_data_lake_exception_subscription <- securitylake_get_data_lake_exception_subscription

#' Retrieves the configuration that will be automatically set up for
#' accounts added to the organization after the organization has onboarded
#' to Amazon Security Lake
#'
#' @description
#' Retrieves the configuration that will be automatically set up for accounts added to the organization after the organization has onboarded to Amazon Security Lake. This API does not take input parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_get_data_lake_organization_configuration/](https://www.paws-r-sdk.com/docs/securitylake_get_data_lake_organization_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname securitylake_get_data_lake_organization_configuration
securitylake_get_data_lake_organization_configuration <- function() {
  op <- new_operation(
    name = "GetDataLakeOrganizationConfiguration",
    http_method = "GET",
    http_path = "/v1/datalake/organization/configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$get_data_lake_organization_configuration_input()
  output <- .securitylake$get_data_lake_organization_configuration_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$get_data_lake_organization_configuration <- securitylake_get_data_lake_organization_configuration

#' Retrieves a snapshot of the current Region, including whether Amazon
#' Security Lake is enabled for those accounts and which sources Security
#' Lake is collecting data from
#'
#' @description
#' Retrieves a snapshot of the current Region, including whether Amazon Security Lake is enabled for those accounts and which sources Security Lake is collecting data from.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_get_data_lake_sources/](https://www.paws-r-sdk.com/docs/securitylake_get_data_lake_sources/) for full documentation.
#'
#' @param accounts The Amazon Web Services account ID for which a static snapshot of the
#' current Amazon Web Services Region, including enabled accounts and log
#' sources, is retrieved.
#' @param maxResults The maximum limit of accounts for which the static snapshot of the
#' current Region, including enabled accounts and log sources, is
#' retrieved.
#' @param nextToken Lists if there are more results available. The value of nextToken is a
#' unique pagination token for each page. Repeat the call using the
#' returned token to retrieve the next page. Keep all other arguments
#' unchanged.
#' 
#' Each pagination token expires after 24 hours. Using an expired
#' pagination token will return an HTTP 400 InvalidToken error.
#'
#' @keywords internal
#'
#' @rdname securitylake_get_data_lake_sources
securitylake_get_data_lake_sources <- function(accounts = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "GetDataLakeSources",
    http_method = "POST",
    http_path = "/v1/datalake/sources",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "dataLakeSources"),
    stream_api = FALSE
  )
  input <- .securitylake$get_data_lake_sources_input(accounts = accounts, maxResults = maxResults, nextToken = nextToken)
  output <- .securitylake$get_data_lake_sources_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$get_data_lake_sources <- securitylake_get_data_lake_sources

#' Retrieves the subscription information for the specified subscription ID
#'
#' @description
#' Retrieves the subscription information for the specified subscription ID. You can get information about a specific subscriber.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_get_subscriber/](https://www.paws-r-sdk.com/docs/securitylake_get_subscriber/) for full documentation.
#'
#' @param subscriberId &#91;required&#93; A value created by Amazon Security Lake that uniquely identifies your
#' [`get_subscriber`][securitylake_get_subscriber] API request.
#'
#' @keywords internal
#'
#' @rdname securitylake_get_subscriber
securitylake_get_subscriber <- function(subscriberId) {
  op <- new_operation(
    name = "GetSubscriber",
    http_method = "GET",
    http_path = "/v1/subscribers/{subscriberId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$get_subscriber_input(subscriberId = subscriberId)
  output <- .securitylake$get_subscriber_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$get_subscriber <- securitylake_get_subscriber

#' Lists the Amazon Security Lake exceptions that you can use to find the
#' source of problems and fix them
#'
#' @description
#' Lists the Amazon Security Lake exceptions that you can use to find the source of problems and fix them.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_list_data_lake_exceptions/](https://www.paws-r-sdk.com/docs/securitylake_list_data_lake_exceptions/) for full documentation.
#'
#' @param maxResults Lists the maximum number of failures in Security Lake.
#' @param nextToken Lists if there are more results available. The value of nextToken is a
#' unique pagination token for each page. Repeat the call using the
#' returned token to retrieve the next page. Keep all other arguments
#' unchanged.
#' 
#' Each pagination token expires after 24 hours. Using an expired
#' pagination token will return an HTTP 400 InvalidToken error.
#' @param regions The Amazon Web Services Regions from which exceptions are retrieved.
#'
#' @keywords internal
#'
#' @rdname securitylake_list_data_lake_exceptions
securitylake_list_data_lake_exceptions <- function(maxResults = NULL, nextToken = NULL, regions = NULL) {
  op <- new_operation(
    name = "ListDataLakeExceptions",
    http_method = "POST",
    http_path = "/v1/datalake/exceptions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "exceptions"),
    stream_api = FALSE
  )
  input <- .securitylake$list_data_lake_exceptions_input(maxResults = maxResults, nextToken = nextToken, regions = regions)
  output <- .securitylake$list_data_lake_exceptions_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$list_data_lake_exceptions <- securitylake_list_data_lake_exceptions

#' Retrieves the Amazon Security Lake configuration object for the
#' specified Amazon Web Services Regions
#'
#' @description
#' Retrieves the Amazon Security Lake configuration object for the specified Amazon Web Services Regions. You can use this operation to determine whether Security Lake is enabled for a Region.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_list_data_lakes/](https://www.paws-r-sdk.com/docs/securitylake_list_data_lakes/) for full documentation.
#'
#' @param regions The list of Regions where Security Lake is enabled.
#'
#' @keywords internal
#'
#' @rdname securitylake_list_data_lakes
securitylake_list_data_lakes <- function(regions = NULL) {
  op <- new_operation(
    name = "ListDataLakes",
    http_method = "GET",
    http_path = "/v1/datalakes",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$list_data_lakes_input(regions = regions)
  output <- .securitylake$list_data_lakes_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$list_data_lakes <- securitylake_list_data_lakes

#' Retrieves the log sources
#'
#' @description
#' Retrieves the log sources.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_list_log_sources/](https://www.paws-r-sdk.com/docs/securitylake_list_log_sources/) for full documentation.
#'
#' @param accounts The list of Amazon Web Services accounts for which log sources are
#' displayed.
#' @param maxResults The maximum number of accounts for which the log sources are displayed.
#' @param nextToken If nextToken is returned, there are more results available. You can
#' repeat the call using the returned token to retrieve the next page.
#' @param regions The list of Regions for which log sources are displayed.
#' @param sources The list of sources for which log sources are displayed.
#'
#' @keywords internal
#'
#' @rdname securitylake_list_log_sources
securitylake_list_log_sources <- function(accounts = NULL, maxResults = NULL, nextToken = NULL, regions = NULL, sources = NULL) {
  op <- new_operation(
    name = "ListLogSources",
    http_method = "POST",
    http_path = "/v1/datalake/logsources/list",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "sources"),
    stream_api = FALSE
  )
  input <- .securitylake$list_log_sources_input(accounts = accounts, maxResults = maxResults, nextToken = nextToken, regions = regions, sources = sources)
  output <- .securitylake$list_log_sources_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$list_log_sources <- securitylake_list_log_sources

#' Lists all subscribers for the specific Amazon Security Lake account ID
#'
#' @description
#' Lists all subscribers for the specific Amazon Security Lake account ID. You can retrieve a list of subscriptions associated with a specific organization or Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_list_subscribers/](https://www.paws-r-sdk.com/docs/securitylake_list_subscribers/) for full documentation.
#'
#' @param maxResults The maximum number of accounts for which the configuration is displayed.
#' @param nextToken If nextToken is returned, there are more results available. You can
#' repeat the call using the returned token to retrieve the next page.
#'
#' @keywords internal
#'
#' @rdname securitylake_list_subscribers
securitylake_list_subscribers <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSubscribers",
    http_method = "GET",
    http_path = "/v1/subscribers",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "subscribers"),
    stream_api = FALSE
  )
  input <- .securitylake$list_subscribers_input(maxResults = maxResults, nextToken = nextToken)
  output <- .securitylake$list_subscribers_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$list_subscribers <- securitylake_list_subscribers

#' Retrieves the tags (keys and values) that are associated with an Amazon
#' Security Lake resource: a subscriber, or the data lake configuration for
#' your Amazon Web Services account in a particular Amazon Web Services
#' Region
#'
#' @description
#' Retrieves the tags (keys and values) that are associated with an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/securitylake_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Security Lake resource for
#' which you want to retrieve the tags.
#'
#' @keywords internal
#'
#' @rdname securitylake_list_tags_for_resource
securitylake_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v1/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .securitylake$list_tags_for_resource_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$list_tags_for_resource <- securitylake_list_tags_for_resource

#' Designates the Amazon Security Lake delegated administrator account for
#' the organization
#'
#' @description
#' Designates the Amazon Security Lake delegated administrator account for the organization. This API can only be called by the organization management account. The organization management account cannot be the delegated administrator account.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_register_data_lake_delegated_administrator/](https://www.paws-r-sdk.com/docs/securitylake_register_data_lake_delegated_administrator/) for full documentation.
#'
#' @param accountId &#91;required&#93; The Amazon Web Services account ID of the Security Lake delegated
#' administrator.
#'
#' @keywords internal
#'
#' @rdname securitylake_register_data_lake_delegated_administrator
securitylake_register_data_lake_delegated_administrator <- function(accountId) {
  op <- new_operation(
    name = "RegisterDataLakeDelegatedAdministrator",
    http_method = "POST",
    http_path = "/v1/datalake/delegate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$register_data_lake_delegated_administrator_input(accountId = accountId)
  output <- .securitylake$register_data_lake_delegated_administrator_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$register_data_lake_delegated_administrator <- securitylake_register_data_lake_delegated_administrator

#' Adds or updates one or more tags that are associated with an Amazon
#' Security Lake resource: a subscriber, or the data lake configuration for
#' your Amazon Web Services account in a particular Amazon Web Services
#' Region
#'
#' @description
#' Adds or updates one or more tags that are associated with an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region. A *tag* is a label that you can define and associate with Amazon Web Services resources. Each tag consists of a required *tag key* and an associated *tag value*. A *tag key* is a general label that acts as a category for a more specific tag value. A *tag value* acts as a descriptor for a tag key. Tags can help you identify, categorize, and manage resources in different ways, such as by owner, environment, or other criteria. For more information, see [Tagging Amazon Security Lake resources](https://docs.aws.amazon.com/security-lake/latest/userguide/tagging-resources.html) in the *Amazon Security Lake User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_tag_resource/](https://www.paws-r-sdk.com/docs/securitylake_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Security Lake resource to
#' add or update the tags for.
#' @param tags &#91;required&#93; An array of objects, one for each tag (key and value) to associate with
#' the Amazon Security Lake resource. For each tag, you must specify both a
#' tag key and a tag value. A tag value cannot be null, but it can be an
#' empty string.
#'
#' @keywords internal
#'
#' @rdname securitylake_tag_resource
securitylake_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v1/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .securitylake$tag_resource_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$tag_resource <- securitylake_tag_resource

#' Removes one or more tags (keys and values) from an Amazon Security Lake
#' resource: a subscriber, or the data lake configuration for your Amazon
#' Web Services account in a particular Amazon Web Services Region
#'
#' @description
#' Removes one or more tags (keys and values) from an Amazon Security Lake resource: a subscriber, or the data lake configuration for your Amazon Web Services account in a particular Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_untag_resource/](https://www.paws-r-sdk.com/docs/securitylake_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon Security Lake resource to
#' remove one or more tags from.
#' @param tagKeys &#91;required&#93; A list of one or more tag keys. For each value in the list, specify the
#' tag key for a tag to remove from the Amazon Security Lake resource.
#'
#' @keywords internal
#'
#' @rdname securitylake_untag_resource
securitylake_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v1/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .securitylake$untag_resource_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$untag_resource <- securitylake_untag_resource

#' You can use UpdateDataLake to specify where to store your security data,
#' how it should be encrypted at rest and for how long
#'
#' @description
#' You can use [`update_data_lake`][securitylake_update_data_lake] to specify where to store your security data, how it should be encrypted at rest and for how long. You can add a [Rollup Region](https://docs.aws.amazon.com/security-lake/latest/userguide/manage-regions.html#add-rollup-region) to consolidate data from multiple Amazon Web Services Regions, replace default encryption (SSE-S3) with [Customer Manged Key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk), or specify transition and expiration actions through storage [Lifecycle management](https://docs.aws.amazon.com/security-lake/latest/userguide/lifecycle-management.html). The [`update_data_lake`][securitylake_update_data_lake] API works as an "upsert" operation that performs an insert if the specified item or record does not exist, or an update if it already exists. Security Lake securely stores your data at rest using Amazon Web Services encryption solutions. For more details, see [Data protection in Amazon Security Lake](https://docs.aws.amazon.com/security-lake/latest/userguide/data-protection.html).
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_update_data_lake/](https://www.paws-r-sdk.com/docs/securitylake_update_data_lake/) for full documentation.
#'
#' @param configurations &#91;required&#93; Specifies the Region or Regions that will contribute data to the rollup
#' region.
#' @param metaStoreManagerRoleArn The Amazon Resource Name (ARN) used to create and update the Glue table.
#' This table contains partitions generated by the ingestion and
#' normalization of Amazon Web Services log sources and custom sources.
#'
#' @keywords internal
#'
#' @rdname securitylake_update_data_lake
securitylake_update_data_lake <- function(configurations, metaStoreManagerRoleArn = NULL) {
  op <- new_operation(
    name = "UpdateDataLake",
    http_method = "PUT",
    http_path = "/v1/datalake",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$update_data_lake_input(configurations = configurations, metaStoreManagerRoleArn = metaStoreManagerRoleArn)
  output <- .securitylake$update_data_lake_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$update_data_lake <- securitylake_update_data_lake

#' Updates the specified notification subscription in Amazon Security Lake
#' for the organization you specify
#'
#' @description
#' Updates the specified notification subscription in Amazon Security Lake for the organization you specify.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_update_data_lake_exception_subscription/](https://www.paws-r-sdk.com/docs/securitylake_update_data_lake_exception_subscription/) for full documentation.
#'
#' @param exceptionTimeToLive The time-to-live (TTL) for the exception message to remain. It is the
#' duration of time until which the exception message remains.
#' @param notificationEndpoint &#91;required&#93; The account that is subscribed to receive exception notifications.
#' @param subscriptionProtocol &#91;required&#93; The subscription protocol to which exception messages are posted.
#'
#' @keywords internal
#'
#' @rdname securitylake_update_data_lake_exception_subscription
securitylake_update_data_lake_exception_subscription <- function(exceptionTimeToLive = NULL, notificationEndpoint, subscriptionProtocol) {
  op <- new_operation(
    name = "UpdateDataLakeExceptionSubscription",
    http_method = "PUT",
    http_path = "/v1/datalake/exceptions/subscription",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$update_data_lake_exception_subscription_input(exceptionTimeToLive = exceptionTimeToLive, notificationEndpoint = notificationEndpoint, subscriptionProtocol = subscriptionProtocol)
  output <- .securitylake$update_data_lake_exception_subscription_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$update_data_lake_exception_subscription <- securitylake_update_data_lake_exception_subscription

#' Updates an existing subscription for the given Amazon Security Lake
#' account ID
#'
#' @description
#' Updates an existing subscription for the given Amazon Security Lake account ID. You can update a subscriber by changing the sources that the subscriber consumes data from.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_update_subscriber/](https://www.paws-r-sdk.com/docs/securitylake_update_subscriber/) for full documentation.
#'
#' @param sources The supported Amazon Web Services services from which logs and events
#' are collected. For the list of supported Amazon Web Services services,
#' see the [Amazon Security Lake User
#' Guide](https://docs.aws.amazon.com/security-lake/latest/userguide/internal-sources.html).
#' @param subscriberDescription The description of the Security Lake account subscriber.
#' @param subscriberId &#91;required&#93; A value created by Security Lake that uniquely identifies your
#' subscription.
#' @param subscriberIdentity The Amazon Web Services identity used to access your data.
#' @param subscriberName The name of the Security Lake account subscriber.
#'
#' @keywords internal
#'
#' @rdname securitylake_update_subscriber
securitylake_update_subscriber <- function(sources = NULL, subscriberDescription = NULL, subscriberId, subscriberIdentity = NULL, subscriberName = NULL) {
  op <- new_operation(
    name = "UpdateSubscriber",
    http_method = "PUT",
    http_path = "/v1/subscribers/{subscriberId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$update_subscriber_input(sources = sources, subscriberDescription = subscriberDescription, subscriberId = subscriberId, subscriberIdentity = subscriberIdentity, subscriberName = subscriberName)
  output <- .securitylake$update_subscriber_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$update_subscriber <- securitylake_update_subscriber

#' Updates an existing notification method for the subscription (SQS or
#' HTTPs endpoint) or switches the notification subscription endpoint for a
#' subscriber
#'
#' @description
#' Updates an existing notification method for the subscription (SQS or HTTPs endpoint) or switches the notification subscription endpoint for a subscriber.
#'
#' See [https://www.paws-r-sdk.com/docs/securitylake_update_subscriber_notification/](https://www.paws-r-sdk.com/docs/securitylake_update_subscriber_notification/) for full documentation.
#'
#' @param configuration &#91;required&#93; The configuration for subscriber notification.
#' @param subscriberId &#91;required&#93; The subscription ID for which the subscription notification is
#' specified.
#'
#' @keywords internal
#'
#' @rdname securitylake_update_subscriber_notification
securitylake_update_subscriber_notification <- function(configuration, subscriberId) {
  op <- new_operation(
    name = "UpdateSubscriberNotification",
    http_method = "PUT",
    http_path = "/v1/subscribers/{subscriberId}/notification",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .securitylake$update_subscriber_notification_input(configuration = configuration, subscriberId = subscriberId)
  output <- .securitylake$update_subscriber_notification_output()
  config <- get_config()
  svc <- .securitylake$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.securitylake$operations$update_subscriber_notification <- securitylake_update_subscriber_notification
