# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cleanroomsml_service.R
NULL

#' Submits a request to cancel the trained model job
#'
#' @description
#' Submits a request to cancel the trained model job.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_cancel_trained_model/](https://www.paws-r-sdk.com/docs/cleanroomsml_cancel_trained_model/) for full documentation.
#'
#' @param membershipIdentifier &#91;required&#93; The membership ID of the trained model job that you want to cancel.
#' @param trainedModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the trained model job that you want to
#' cancel.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_cancel_trained_model
cleanroomsml_cancel_trained_model <- function(membershipIdentifier, trainedModelArn) {
  op <- new_operation(
    name = "CancelTrainedModel",
    http_method = "PATCH",
    http_path = "/memberships/{membershipIdentifier}/trained-models/{trainedModelArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$cancel_trained_model_input(membershipIdentifier = membershipIdentifier, trainedModelArn = trainedModelArn)
  output <- .cleanroomsml$cancel_trained_model_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$cancel_trained_model <- cleanroomsml_cancel_trained_model

#' Submits a request to cancel a trained model inference job
#'
#' @description
#' Submits a request to cancel a trained model inference job.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_cancel_trained_model_inference_job/](https://www.paws-r-sdk.com/docs/cleanroomsml_cancel_trained_model_inference_job/) for full documentation.
#'
#' @param membershipIdentifier &#91;required&#93; The membership ID of the trained model inference job that you want to
#' cancel.
#' @param trainedModelInferenceJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the trained model inference job that
#' you want to cancel.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_cancel_trained_model_inference_job
cleanroomsml_cancel_trained_model_inference_job <- function(membershipIdentifier, trainedModelInferenceJobArn) {
  op <- new_operation(
    name = "CancelTrainedModelInferenceJob",
    http_method = "PATCH",
    http_path = "/memberships/{membershipIdentifier}/trained-model-inference-jobs/{trainedModelInferenceJobArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$cancel_trained_model_inference_job_input(membershipIdentifier = membershipIdentifier, trainedModelInferenceJobArn = trainedModelInferenceJobArn)
  output <- .cleanroomsml$cancel_trained_model_inference_job_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$cancel_trained_model_inference_job <- cleanroomsml_cancel_trained_model_inference_job

#' Defines the information necessary to create an audience model
#'
#' @description
#' Defines the information necessary to create an audience model. An audience model is a machine learning model that Clean Rooms ML trains to measure similarity between users. Clean Rooms ML manages training and storing the audience model. The audience model can be used in multiple calls to the [`start_audience_generation_job`][cleanroomsml_start_audience_generation_job] API.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_create_audience_model/](https://www.paws-r-sdk.com/docs/cleanroomsml_create_audience_model/) for full documentation.
#'
#' @param trainingDataStartTime The start date and time of the training window.
#' @param trainingDataEndTime The end date and time of the training window.
#' @param name &#91;required&#93; The name of the audience model resource.
#' @param trainingDatasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the training dataset for this audience
#' model.
#' @param kmsKeyArn The Amazon Resource Name (ARN) of the KMS key. This key is used to
#' encrypt and decrypt customer-owned data in the trained ML model and the
#' associated data.
#' @param tags The optional metadata that you apply to the resource to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use aws:, AWS:, or any upper or lowercase combination of such
#'     as a prefix for keys as it is reserved for AWS use. You cannot edit
#'     or delete tag keys with this prefix. Values can have this prefix. If
#'     a tag value has aws as its prefix but the key does not, then Clean
#'     Rooms ML considers it to be a user tag and will count against the
#'     limit of 50 tags. Tags with only the key prefix of aws do not count
#'     against your tags per resource limit.
#' @param description The description of the audience model.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_create_audience_model
cleanroomsml_create_audience_model <- function(trainingDataStartTime = NULL, trainingDataEndTime = NULL, name, trainingDatasetArn, kmsKeyArn = NULL, tags = NULL, description = NULL) {
  op <- new_operation(
    name = "CreateAudienceModel",
    http_method = "POST",
    http_path = "/audience-model",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$create_audience_model_input(trainingDataStartTime = trainingDataStartTime, trainingDataEndTime = trainingDataEndTime, name = name, trainingDatasetArn = trainingDatasetArn, kmsKeyArn = kmsKeyArn, tags = tags, description = description)
  output <- .cleanroomsml$create_audience_model_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$create_audience_model <- cleanroomsml_create_audience_model

#' Defines the information necessary to create a configured audience model
#'
#' @description
#' Defines the information necessary to create a configured audience model.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_create_configured_audience_model/](https://www.paws-r-sdk.com/docs/cleanroomsml_create_configured_audience_model/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the configured audience model.
#' @param audienceModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the audience model to use for the
#' configured audience model.
#' @param outputConfig &#91;required&#93; Configure the Amazon S3 location and IAM Role for audiences created
#' using this configured audience model. Each audience will have a unique
#' location. The IAM Role must have `s3:PutObject` permission on the
#' destination Amazon S3 location. If the destination is protected with
#' Amazon S3 KMS-SSE, then the Role must also have the required KMS
#' permissions.
#' @param description The description of the configured audience model.
#' @param sharedAudienceMetrics &#91;required&#93; Whether audience metrics are shared.
#' @param minMatchingSeedSize The minimum number of users from the seed audience that must match with
#' users in the training data of the audience model. The default value is
#' 500.
#' @param audienceSizeConfig Configure the list of output sizes of audiences that can be created
#' using this configured audience model. A request to
#' [`start_audience_generation_job`][cleanroomsml_start_audience_generation_job]
#' that uses this configured audience model must have an `audienceSize`
#' selected from this list. You can use the `ABSOLUTE` AudienceSize to
#' configure out audience sizes using the count of identifiers in the
#' output. You can use the `Percentage` AudienceSize to configure sizes in
#' the range 1-100 percent.
#' @param tags The optional metadata that you apply to the resource to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use aws:, AWS:, or any upper or lowercase combination of such
#'     as a prefix for keys as it is reserved for AWS use. You cannot edit
#'     or delete tag keys with this prefix. Values can have this prefix. If
#'     a tag value has aws as its prefix but the key does not, then Clean
#'     Rooms ML considers it to be a user tag and will count against the
#'     limit of 50 tags. Tags with only the key prefix of aws do not count
#'     against your tags per resource limit.
#' @param childResourceTagOnCreatePolicy Configure how the service tags audience generation jobs created using
#' this configured audience model. If you specify `NONE`, the tags from the
#' [`start_audience_generation_job`][cleanroomsml_start_audience_generation_job]
#' request determine the tags of the audience generation job. If you
#' specify `FROM_PARENT_RESOURCE`, the audience generation job inherits the
#' tags from the configured audience model, by default. Tags in the
#' [`start_audience_generation_job`][cleanroomsml_start_audience_generation_job]
#' will override the default.
#' 
#' When the client is in a different account than the configured audience
#' model, the tags from the client are never applied to a resource in the
#' caller's account.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_create_configured_audience_model
cleanroomsml_create_configured_audience_model <- function(name, audienceModelArn, outputConfig, description = NULL, sharedAudienceMetrics, minMatchingSeedSize = NULL, audienceSizeConfig = NULL, tags = NULL, childResourceTagOnCreatePolicy = NULL) {
  op <- new_operation(
    name = "CreateConfiguredAudienceModel",
    http_method = "POST",
    http_path = "/configured-audience-model",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$create_configured_audience_model_input(name = name, audienceModelArn = audienceModelArn, outputConfig = outputConfig, description = description, sharedAudienceMetrics = sharedAudienceMetrics, minMatchingSeedSize = minMatchingSeedSize, audienceSizeConfig = audienceSizeConfig, tags = tags, childResourceTagOnCreatePolicy = childResourceTagOnCreatePolicy)
  output <- .cleanroomsml$create_configured_audience_model_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$create_configured_audience_model <- cleanroomsml_create_configured_audience_model

#' Creates a configured model algorithm using a container image stored in
#' an ECR repository
#'
#' @description
#' Creates a configured model algorithm using a container image stored in an ECR repository.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_create_configured_model_algorithm/](https://www.paws-r-sdk.com/docs/cleanroomsml_create_configured_model_algorithm/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the configured model algorithm.
#' @param description The description of the configured model algorithm.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the role that is used to access the
#' repository.
#' @param trainingContainerConfig Configuration information for the training container, including
#' entrypoints and arguments.
#' @param inferenceContainerConfig Configuration information for the inference container that is used when
#' you run an inference job on a configured model algorithm.
#' @param tags The optional metadata that you apply to the resource to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use aws:, AWS:, or any upper or lowercase combination of such
#'     as a prefix for keys as it is reserved for AWS use. You cannot edit
#'     or delete tag keys with this prefix. Values can have this prefix. If
#'     a tag value has aws as its prefix but the key does not, then Clean
#'     Rooms ML considers it to be a user tag and will count against the
#'     limit of 50 tags. Tags with only the key prefix of aws do not count
#'     against your tags per resource limit.
#' @param kmsKeyArn The Amazon Resource Name (ARN) of the KMS key. This key is used to
#' encrypt and decrypt customer-owned data in the configured ML model
#' algorithm and associated data.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_create_configured_model_algorithm
cleanroomsml_create_configured_model_algorithm <- function(name, description = NULL, roleArn, trainingContainerConfig = NULL, inferenceContainerConfig = NULL, tags = NULL, kmsKeyArn = NULL) {
  op <- new_operation(
    name = "CreateConfiguredModelAlgorithm",
    http_method = "POST",
    http_path = "/configured-model-algorithms",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$create_configured_model_algorithm_input(name = name, description = description, roleArn = roleArn, trainingContainerConfig = trainingContainerConfig, inferenceContainerConfig = inferenceContainerConfig, tags = tags, kmsKeyArn = kmsKeyArn)
  output <- .cleanroomsml$create_configured_model_algorithm_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$create_configured_model_algorithm <- cleanroomsml_create_configured_model_algorithm

#' Associates a configured model algorithm to a collaboration for use by
#' any member of the collaboration
#'
#' @description
#' Associates a configured model algorithm to a collaboration for use by any member of the collaboration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_create_configured_model_algorithm_association/](https://www.paws-r-sdk.com/docs/cleanroomsml_create_configured_model_algorithm_association/) for full documentation.
#'
#' @param membershipIdentifier &#91;required&#93; The membership ID of the member who is associating this configured model
#' algorithm.
#' @param configuredModelAlgorithmArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured model algorithm that
#' you want to associate.
#' @param name &#91;required&#93; The name of the configured model algorithm association.
#' @param description The description of the configured model algorithm association.
#' @param privacyConfiguration Specifies the privacy configuration information for the configured model
#' algorithm association. This information includes the maximum data size
#' that can be exported.
#' @param tags The optional metadata that you apply to the resource to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use aws:, AWS:, or any upper or lowercase combination of such
#'     as a prefix for keys as it is reserved for AWS use. You cannot edit
#'     or delete tag keys with this prefix. Values can have this prefix. If
#'     a tag value has aws as its prefix but the key does not, then Clean
#'     Rooms ML considers it to be a user tag and will count against the
#'     limit of 50 tags. Tags with only the key prefix of aws do not count
#'     against your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_create_configured_model_algorithm_association
cleanroomsml_create_configured_model_algorithm_association <- function(membershipIdentifier, configuredModelAlgorithmArn, name, description = NULL, privacyConfiguration = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateConfiguredModelAlgorithmAssociation",
    http_method = "POST",
    http_path = "/memberships/{membershipIdentifier}/configured-model-algorithm-associations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$create_configured_model_algorithm_association_input(membershipIdentifier = membershipIdentifier, configuredModelAlgorithmArn = configuredModelAlgorithmArn, name = name, description = description, privacyConfiguration = privacyConfiguration, tags = tags)
  output <- .cleanroomsml$create_configured_model_algorithm_association_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$create_configured_model_algorithm_association <- cleanroomsml_create_configured_model_algorithm_association

#' Provides the information to create an ML input channel
#'
#' @description
#' Provides the information to create an ML input channel. An ML input channel is the result of a query that can be used for ML modeling.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_create_ml_input_channel/](https://www.paws-r-sdk.com/docs/cleanroomsml_create_ml_input_channel/) for full documentation.
#'
#' @param membershipIdentifier &#91;required&#93; The membership ID of the member that is creating the ML input channel.
#' @param configuredModelAlgorithmAssociations &#91;required&#93; The associated configured model algorithms that are necessary to create
#' this ML input channel.
#' @param inputChannel &#91;required&#93; The input data that is used to create this ML input channel.
#' @param name &#91;required&#93; The name of the ML input channel.
#' @param retentionInDays &#91;required&#93; The number of days that the data in the ML input channel is retained.
#' @param description The description of the ML input channel.
#' @param kmsKeyArn The Amazon Resource Name (ARN) of the KMS key that is used to access the
#' input channel.
#' @param tags The optional metadata that you apply to the resource to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use aws:, AWS:, or any upper or lowercase combination of such
#'     as a prefix for keys as it is reserved for AWS use. You cannot edit
#'     or delete tag keys with this prefix. Values can have this prefix. If
#'     a tag value has aws as its prefix but the key does not, then Clean
#'     Rooms ML considers it to be a user tag and will count against the
#'     limit of 50 tags. Tags with only the key prefix of aws do not count
#'     against your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_create_ml_input_channel
cleanroomsml_create_ml_input_channel <- function(membershipIdentifier, configuredModelAlgorithmAssociations, inputChannel, name, retentionInDays, description = NULL, kmsKeyArn = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateMLInputChannel",
    http_method = "POST",
    http_path = "/memberships/{membershipIdentifier}/ml-input-channels",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$create_ml_input_channel_input(membershipIdentifier = membershipIdentifier, configuredModelAlgorithmAssociations = configuredModelAlgorithmAssociations, inputChannel = inputChannel, name = name, retentionInDays = retentionInDays, description = description, kmsKeyArn = kmsKeyArn, tags = tags)
  output <- .cleanroomsml$create_ml_input_channel_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$create_ml_input_channel <- cleanroomsml_create_ml_input_channel

#' Creates a trained model from an associated configured model algorithm
#' using data from any member of the collaboration
#'
#' @description
#' Creates a trained model from an associated configured model algorithm using data from any member of the collaboration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_create_trained_model/](https://www.paws-r-sdk.com/docs/cleanroomsml_create_trained_model/) for full documentation.
#'
#' @param membershipIdentifier &#91;required&#93; The membership ID of the member that is creating the trained model.
#' @param name &#91;required&#93; The name of the trained model.
#' @param configuredModelAlgorithmAssociationArn &#91;required&#93; The associated configured model algorithm used to train this model.
#' @param hyperparameters Algorithm-specific parameters that influence the quality of the model.
#' You set hyperparameters before you start the learning process.
#' @param environment The environment variables to set in the Docker container.
#' @param resourceConfig &#91;required&#93; Information about the EC2 resources that are used to train this model.
#' @param stoppingCondition The criteria that is used to stop model training.
#' @param dataChannels &#91;required&#93; Defines the data channels that are used as input for the trained model
#' request.
#' @param description The description of the trained model.
#' @param kmsKeyArn The Amazon Resource Name (ARN) of the KMS key. This key is used to
#' encrypt and decrypt customer-owned data in the trained ML model and the
#' associated data.
#' @param tags The optional metadata that you apply to the resource to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use aws:, AWS:, or any upper or lowercase combination of such
#'     as a prefix for keys as it is reserved for AWS use. You cannot edit
#'     or delete tag keys with this prefix. Values can have this prefix. If
#'     a tag value has aws as its prefix but the key does not, then Clean
#'     Rooms ML considers it to be a user tag and will count against the
#'     limit of 50 tags. Tags with only the key prefix of aws do not count
#'     against your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_create_trained_model
cleanroomsml_create_trained_model <- function(membershipIdentifier, name, configuredModelAlgorithmAssociationArn, hyperparameters = NULL, environment = NULL, resourceConfig, stoppingCondition = NULL, dataChannels, description = NULL, kmsKeyArn = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateTrainedModel",
    http_method = "POST",
    http_path = "/memberships/{membershipIdentifier}/trained-models",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$create_trained_model_input(membershipIdentifier = membershipIdentifier, name = name, configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn, hyperparameters = hyperparameters, environment = environment, resourceConfig = resourceConfig, stoppingCondition = stoppingCondition, dataChannels = dataChannels, description = description, kmsKeyArn = kmsKeyArn, tags = tags)
  output <- .cleanroomsml$create_trained_model_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$create_trained_model <- cleanroomsml_create_trained_model

#' Defines the information necessary to create a training dataset
#'
#' @description
#' Defines the information necessary to create a training dataset. In Clean Rooms ML, the `TrainingDataset` is metadata that points to a Glue table, which is read only during `AudienceModel` creation.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_create_training_dataset/](https://www.paws-r-sdk.com/docs/cleanroomsml_create_training_dataset/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the training dataset. This name must be unique in your
#' account and region.
#' @param roleArn &#91;required&#93; The ARN of the IAM role that Clean Rooms ML can assume to read the data
#' referred to in the `dataSource` field of each dataset.
#' 
#' Passing a role across AWS accounts is not allowed. If you pass a role
#' that isn't in your account, you get an `AccessDeniedException` error.
#' @param trainingData &#91;required&#93; An array of information that lists the Dataset objects, which specifies
#' the dataset type and details on its location and schema. You must
#' provide a role that has read access to these tables.
#' @param tags The optional metadata that you apply to the resource to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use aws:, AWS:, or any upper or lowercase combination of such
#'     as a prefix for keys as it is reserved for AWS use. You cannot edit
#'     or delete tag keys with this prefix. Values can have this prefix. If
#'     a tag value has aws as its prefix but the key does not, then Clean
#'     Rooms ML considers it to be a user tag and will count against the
#'     limit of 50 tags. Tags with only the key prefix of aws do not count
#'     against your tags per resource limit.
#' @param description The description of the training dataset.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_create_training_dataset
cleanroomsml_create_training_dataset <- function(name, roleArn, trainingData, tags = NULL, description = NULL) {
  op <- new_operation(
    name = "CreateTrainingDataset",
    http_method = "POST",
    http_path = "/training-dataset",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$create_training_dataset_input(name = name, roleArn = roleArn, trainingData = trainingData, tags = tags, description = description)
  output <- .cleanroomsml$create_training_dataset_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$create_training_dataset <- cleanroomsml_create_training_dataset

#' Deletes the specified audience generation job, and removes all data
#' associated with the job
#'
#' @description
#' Deletes the specified audience generation job, and removes all data associated with the job.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_delete_audience_generation_job/](https://www.paws-r-sdk.com/docs/cleanroomsml_delete_audience_generation_job/) for full documentation.
#'
#' @param audienceGenerationJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the audience generation job that you
#' want to delete.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_delete_audience_generation_job
cleanroomsml_delete_audience_generation_job <- function(audienceGenerationJobArn) {
  op <- new_operation(
    name = "DeleteAudienceGenerationJob",
    http_method = "DELETE",
    http_path = "/audience-generation-job/{audienceGenerationJobArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$delete_audience_generation_job_input(audienceGenerationJobArn = audienceGenerationJobArn)
  output <- .cleanroomsml$delete_audience_generation_job_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$delete_audience_generation_job <- cleanroomsml_delete_audience_generation_job

#' Specifies an audience model that you want to delete
#'
#' @description
#' Specifies an audience model that you want to delete. You can't delete an audience model if there are any configured audience models that depend on the audience model.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_delete_audience_model/](https://www.paws-r-sdk.com/docs/cleanroomsml_delete_audience_model/) for full documentation.
#'
#' @param audienceModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the audience model that you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_delete_audience_model
cleanroomsml_delete_audience_model <- function(audienceModelArn) {
  op <- new_operation(
    name = "DeleteAudienceModel",
    http_method = "DELETE",
    http_path = "/audience-model/{audienceModelArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$delete_audience_model_input(audienceModelArn = audienceModelArn)
  output <- .cleanroomsml$delete_audience_model_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$delete_audience_model <- cleanroomsml_delete_audience_model

#' Deletes the specified configured audience model
#'
#' @description
#' Deletes the specified configured audience model. You can't delete a configured audience model if there are any lookalike models that use the configured audience model. If you delete a configured audience model, it will be removed from any collaborations that it is associated to.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_delete_configured_audience_model/](https://www.paws-r-sdk.com/docs/cleanroomsml_delete_configured_audience_model/) for full documentation.
#'
#' @param configuredAudienceModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured audience model that you
#' want to delete.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_delete_configured_audience_model
cleanroomsml_delete_configured_audience_model <- function(configuredAudienceModelArn) {
  op <- new_operation(
    name = "DeleteConfiguredAudienceModel",
    http_method = "DELETE",
    http_path = "/configured-audience-model/{configuredAudienceModelArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$delete_configured_audience_model_input(configuredAudienceModelArn = configuredAudienceModelArn)
  output <- .cleanroomsml$delete_configured_audience_model_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$delete_configured_audience_model <- cleanroomsml_delete_configured_audience_model

#' Deletes the specified configured audience model policy
#'
#' @description
#' Deletes the specified configured audience model policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_delete_configured_audience_model_policy/](https://www.paws-r-sdk.com/docs/cleanroomsml_delete_configured_audience_model_policy/) for full documentation.
#'
#' @param configuredAudienceModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured audience model policy
#' that you want to delete.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_delete_configured_audience_model_policy
cleanroomsml_delete_configured_audience_model_policy <- function(configuredAudienceModelArn) {
  op <- new_operation(
    name = "DeleteConfiguredAudienceModelPolicy",
    http_method = "DELETE",
    http_path = "/configured-audience-model/{configuredAudienceModelArn}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$delete_configured_audience_model_policy_input(configuredAudienceModelArn = configuredAudienceModelArn)
  output <- .cleanroomsml$delete_configured_audience_model_policy_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$delete_configured_audience_model_policy <- cleanroomsml_delete_configured_audience_model_policy

#' Deletes a configured model algorithm
#'
#' @description
#' Deletes a configured model algorithm.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_delete_configured_model_algorithm/](https://www.paws-r-sdk.com/docs/cleanroomsml_delete_configured_model_algorithm/) for full documentation.
#'
#' @param configuredModelAlgorithmArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured model algorithm that
#' you want to delete.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_delete_configured_model_algorithm
cleanroomsml_delete_configured_model_algorithm <- function(configuredModelAlgorithmArn) {
  op <- new_operation(
    name = "DeleteConfiguredModelAlgorithm",
    http_method = "DELETE",
    http_path = "/configured-model-algorithms/{configuredModelAlgorithmArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$delete_configured_model_algorithm_input(configuredModelAlgorithmArn = configuredModelAlgorithmArn)
  output <- .cleanroomsml$delete_configured_model_algorithm_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$delete_configured_model_algorithm <- cleanroomsml_delete_configured_model_algorithm

#' Deletes a configured model algorithm association
#'
#' @description
#' Deletes a configured model algorithm association.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_delete_configured_model_algorithm_association/](https://www.paws-r-sdk.com/docs/cleanroomsml_delete_configured_model_algorithm_association/) for full documentation.
#'
#' @param configuredModelAlgorithmAssociationArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured model algorithm
#' association that you want to delete.
#' @param membershipIdentifier &#91;required&#93; The membership ID of the member that is deleting the configured model
#' algorithm association.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_delete_configured_model_algorithm_association
cleanroomsml_delete_configured_model_algorithm_association <- function(configuredModelAlgorithmAssociationArn, membershipIdentifier) {
  op <- new_operation(
    name = "DeleteConfiguredModelAlgorithmAssociation",
    http_method = "DELETE",
    http_path = "/memberships/{membershipIdentifier}/configured-model-algorithm-associations/{configuredModelAlgorithmAssociationArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$delete_configured_model_algorithm_association_input(configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn, membershipIdentifier = membershipIdentifier)
  output <- .cleanroomsml$delete_configured_model_algorithm_association_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$delete_configured_model_algorithm_association <- cleanroomsml_delete_configured_model_algorithm_association

#' Deletes a ML modeling configuration
#'
#' @description
#' Deletes a ML modeling configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_delete_ml_configuration/](https://www.paws-r-sdk.com/docs/cleanroomsml_delete_ml_configuration/) for full documentation.
#'
#' @param membershipIdentifier &#91;required&#93; The membership ID of the of the member that is deleting the ML modeling
#' configuration.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_delete_ml_configuration
cleanroomsml_delete_ml_configuration <- function(membershipIdentifier) {
  op <- new_operation(
    name = "DeleteMLConfiguration",
    http_method = "DELETE",
    http_path = "/memberships/{membershipIdentifier}/ml-configurations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$delete_ml_configuration_input(membershipIdentifier = membershipIdentifier)
  output <- .cleanroomsml$delete_ml_configuration_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$delete_ml_configuration <- cleanroomsml_delete_ml_configuration

#' Provides the information necessary to delete an ML input channel
#'
#' @description
#' Provides the information necessary to delete an ML input channel.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_delete_ml_input_channel_data/](https://www.paws-r-sdk.com/docs/cleanroomsml_delete_ml_input_channel_data/) for full documentation.
#'
#' @param mlInputChannelArn &#91;required&#93; The Amazon Resource Name (ARN) of the ML input channel that you want to
#' delete.
#' @param membershipIdentifier &#91;required&#93; The membership ID of the membership that contains the ML input channel
#' you want to delete.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_delete_ml_input_channel_data
cleanroomsml_delete_ml_input_channel_data <- function(mlInputChannelArn, membershipIdentifier) {
  op <- new_operation(
    name = "DeleteMLInputChannelData",
    http_method = "DELETE",
    http_path = "/memberships/{membershipIdentifier}/ml-input-channels/{mlInputChannelArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$delete_ml_input_channel_data_input(mlInputChannelArn = mlInputChannelArn, membershipIdentifier = membershipIdentifier)
  output <- .cleanroomsml$delete_ml_input_channel_data_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$delete_ml_input_channel_data <- cleanroomsml_delete_ml_input_channel_data

#' Deletes the output of a trained model
#'
#' @description
#' Deletes the output of a trained model.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_delete_trained_model_output/](https://www.paws-r-sdk.com/docs/cleanroomsml_delete_trained_model_output/) for full documentation.
#'
#' @param trainedModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the trained model whose output you
#' want to delete.
#' @param membershipIdentifier &#91;required&#93; The membership ID of the member that is deleting the trained model
#' output.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_delete_trained_model_output
cleanroomsml_delete_trained_model_output <- function(trainedModelArn, membershipIdentifier) {
  op <- new_operation(
    name = "DeleteTrainedModelOutput",
    http_method = "DELETE",
    http_path = "/memberships/{membershipIdentifier}/trained-models/{trainedModelArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$delete_trained_model_output_input(trainedModelArn = trainedModelArn, membershipIdentifier = membershipIdentifier)
  output <- .cleanroomsml$delete_trained_model_output_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$delete_trained_model_output <- cleanroomsml_delete_trained_model_output

#' Specifies a training dataset that you want to delete
#'
#' @description
#' Specifies a training dataset that you want to delete. You can't delete a training dataset if there are any audience models that depend on the training dataset. In Clean Rooms ML, the `TrainingDataset` is metadata that points to a Glue table, which is read only during `AudienceModel` creation. This action deletes the metadata.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_delete_training_dataset/](https://www.paws-r-sdk.com/docs/cleanroomsml_delete_training_dataset/) for full documentation.
#'
#' @param trainingDatasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the training dataset that you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_delete_training_dataset
cleanroomsml_delete_training_dataset <- function(trainingDatasetArn) {
  op <- new_operation(
    name = "DeleteTrainingDataset",
    http_method = "DELETE",
    http_path = "/training-dataset/{trainingDatasetArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$delete_training_dataset_input(trainingDatasetArn = trainingDatasetArn)
  output <- .cleanroomsml$delete_training_dataset_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$delete_training_dataset <- cleanroomsml_delete_training_dataset

#' Returns information about an audience generation job
#'
#' @description
#' Returns information about an audience generation job.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_audience_generation_job/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_audience_generation_job/) for full documentation.
#'
#' @param audienceGenerationJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the audience generation job that you
#' are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_audience_generation_job
cleanroomsml_get_audience_generation_job <- function(audienceGenerationJobArn) {
  op <- new_operation(
    name = "GetAudienceGenerationJob",
    http_method = "GET",
    http_path = "/audience-generation-job/{audienceGenerationJobArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_audience_generation_job_input(audienceGenerationJobArn = audienceGenerationJobArn)
  output <- .cleanroomsml$get_audience_generation_job_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_audience_generation_job <- cleanroomsml_get_audience_generation_job

#' Returns information about an audience model
#'
#' @description
#' Returns information about an audience model
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_audience_model/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_audience_model/) for full documentation.
#'
#' @param audienceModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the audience model that you are
#' interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_audience_model
cleanroomsml_get_audience_model <- function(audienceModelArn) {
  op <- new_operation(
    name = "GetAudienceModel",
    http_method = "GET",
    http_path = "/audience-model/{audienceModelArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_audience_model_input(audienceModelArn = audienceModelArn)
  output <- .cleanroomsml$get_audience_model_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_audience_model <- cleanroomsml_get_audience_model

#' Returns information about the configured model algorithm association in
#' a collaboration
#'
#' @description
#' Returns information about the configured model algorithm association in a collaboration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_collaboration_configured_model_algorithm_association/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_collaboration_configured_model_algorithm_association/) for full documentation.
#'
#' @param configuredModelAlgorithmAssociationArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured model algorithm
#' association that you want to return information about.
#' @param collaborationIdentifier &#91;required&#93; The collaboration ID for the collaboration that contains the configured
#' model algorithm association that you want to return information about.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_collab_config_model_algori_associ
cleanroomsml_get_collaboration_configured_model_algorithm_association <- function(configuredModelAlgorithmAssociationArn, collaborationIdentifier) {
  op <- new_operation(
    name = "GetCollaborationConfiguredModelAlgorithmAssociation",
    http_method = "GET",
    http_path = "/collaborations/{collaborationIdentifier}/configured-model-algorithm-associations/{configuredModelAlgorithmAssociationArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_collaboration_configured_model_algorithm_association_input(configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn, collaborationIdentifier = collaborationIdentifier)
  output <- .cleanroomsml$get_collaboration_configured_model_algorithm_association_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_collaboration_configured_model_algorithm_association <- cleanroomsml_get_collaboration_configured_model_algorithm_association

#' Returns information about a specific ML input channel in a collaboration
#'
#' @description
#' Returns information about a specific ML input channel in a collaboration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_collaboration_ml_input_channel/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_collaboration_ml_input_channel/) for full documentation.
#'
#' @param mlInputChannelArn &#91;required&#93; The Amazon Resource Name (ARN) of the ML input channel that you want to
#' get.
#' @param collaborationIdentifier &#91;required&#93; The collaboration ID of the collaboration that contains the ML input
#' channel that you want to get.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_collaboration_ml_input_channel
cleanroomsml_get_collaboration_ml_input_channel <- function(mlInputChannelArn, collaborationIdentifier) {
  op <- new_operation(
    name = "GetCollaborationMLInputChannel",
    http_method = "GET",
    http_path = "/collaborations/{collaborationIdentifier}/ml-input-channels/{mlInputChannelArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_collaboration_ml_input_channel_input(mlInputChannelArn = mlInputChannelArn, collaborationIdentifier = collaborationIdentifier)
  output <- .cleanroomsml$get_collaboration_ml_input_channel_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_collaboration_ml_input_channel <- cleanroomsml_get_collaboration_ml_input_channel

#' Returns information about a trained model in a collaboration
#'
#' @description
#' Returns information about a trained model in a collaboration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_collaboration_trained_model/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_collaboration_trained_model/) for full documentation.
#'
#' @param trainedModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the trained model that you want to
#' return information about.
#' @param collaborationIdentifier &#91;required&#93; The collaboration ID that contains the trained model that you want to
#' return information about.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_collaboration_trained_model
cleanroomsml_get_collaboration_trained_model <- function(trainedModelArn, collaborationIdentifier) {
  op <- new_operation(
    name = "GetCollaborationTrainedModel",
    http_method = "GET",
    http_path = "/collaborations/{collaborationIdentifier}/trained-models/{trainedModelArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_collaboration_trained_model_input(trainedModelArn = trainedModelArn, collaborationIdentifier = collaborationIdentifier)
  output <- .cleanroomsml$get_collaboration_trained_model_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_collaboration_trained_model <- cleanroomsml_get_collaboration_trained_model

#' Returns information about a specified configured audience model
#'
#' @description
#' Returns information about a specified configured audience model.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_configured_audience_model/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_configured_audience_model/) for full documentation.
#'
#' @param configuredAudienceModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured audience model that you
#' are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_configured_audience_model
cleanroomsml_get_configured_audience_model <- function(configuredAudienceModelArn) {
  op <- new_operation(
    name = "GetConfiguredAudienceModel",
    http_method = "GET",
    http_path = "/configured-audience-model/{configuredAudienceModelArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_configured_audience_model_input(configuredAudienceModelArn = configuredAudienceModelArn)
  output <- .cleanroomsml$get_configured_audience_model_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_configured_audience_model <- cleanroomsml_get_configured_audience_model

#' Returns information about a configured audience model policy
#'
#' @description
#' Returns information about a configured audience model policy.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_configured_audience_model_policy/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_configured_audience_model_policy/) for full documentation.
#'
#' @param configuredAudienceModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured audience model that you
#' are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_configured_audience_model_policy
cleanroomsml_get_configured_audience_model_policy <- function(configuredAudienceModelArn) {
  op <- new_operation(
    name = "GetConfiguredAudienceModelPolicy",
    http_method = "GET",
    http_path = "/configured-audience-model/{configuredAudienceModelArn}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_configured_audience_model_policy_input(configuredAudienceModelArn = configuredAudienceModelArn)
  output <- .cleanroomsml$get_configured_audience_model_policy_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_configured_audience_model_policy <- cleanroomsml_get_configured_audience_model_policy

#' Returns information about a configured model algorithm
#'
#' @description
#' Returns information about a configured model algorithm.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_configured_model_algorithm/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_configured_model_algorithm/) for full documentation.
#'
#' @param configuredModelAlgorithmArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured model algorithm that
#' you want to return information about.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_configured_model_algorithm
cleanroomsml_get_configured_model_algorithm <- function(configuredModelAlgorithmArn) {
  op <- new_operation(
    name = "GetConfiguredModelAlgorithm",
    http_method = "GET",
    http_path = "/configured-model-algorithms/{configuredModelAlgorithmArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_configured_model_algorithm_input(configuredModelAlgorithmArn = configuredModelAlgorithmArn)
  output <- .cleanroomsml$get_configured_model_algorithm_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_configured_model_algorithm <- cleanroomsml_get_configured_model_algorithm

#' Returns information about a configured model algorithm association
#'
#' @description
#' Returns information about a configured model algorithm association.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_configured_model_algorithm_association/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_configured_model_algorithm_association/) for full documentation.
#'
#' @param configuredModelAlgorithmAssociationArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured model algorithm
#' association that you want to return information about.
#' @param membershipIdentifier &#91;required&#93; The membership ID of the member that created the configured model
#' algorithm association.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_configured_model_algorithm_association
cleanroomsml_get_configured_model_algorithm_association <- function(configuredModelAlgorithmAssociationArn, membershipIdentifier) {
  op <- new_operation(
    name = "GetConfiguredModelAlgorithmAssociation",
    http_method = "GET",
    http_path = "/memberships/{membershipIdentifier}/configured-model-algorithm-associations/{configuredModelAlgorithmAssociationArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_configured_model_algorithm_association_input(configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn, membershipIdentifier = membershipIdentifier)
  output <- .cleanroomsml$get_configured_model_algorithm_association_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_configured_model_algorithm_association <- cleanroomsml_get_configured_model_algorithm_association

#' Returns information about a specific ML configuration
#'
#' @description
#' Returns information about a specific ML configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_ml_configuration/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_ml_configuration/) for full documentation.
#'
#' @param membershipIdentifier &#91;required&#93; The membership ID of the member that owns the ML configuration you want
#' to return information about.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_ml_configuration
cleanroomsml_get_ml_configuration <- function(membershipIdentifier) {
  op <- new_operation(
    name = "GetMLConfiguration",
    http_method = "GET",
    http_path = "/memberships/{membershipIdentifier}/ml-configurations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_ml_configuration_input(membershipIdentifier = membershipIdentifier)
  output <- .cleanroomsml$get_ml_configuration_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_ml_configuration <- cleanroomsml_get_ml_configuration

#' Returns information about an ML input channel
#'
#' @description
#' Returns information about an ML input channel.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_ml_input_channel/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_ml_input_channel/) for full documentation.
#'
#' @param mlInputChannelArn &#91;required&#93; The Amazon Resource Name (ARN) of the ML input channel that you want to
#' get.
#' @param membershipIdentifier &#91;required&#93; The membership ID of the membership that contains the ML input channel
#' that you want to get.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_ml_input_channel
cleanroomsml_get_ml_input_channel <- function(mlInputChannelArn, membershipIdentifier) {
  op <- new_operation(
    name = "GetMLInputChannel",
    http_method = "GET",
    http_path = "/memberships/{membershipIdentifier}/ml-input-channels/{mlInputChannelArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_ml_input_channel_input(mlInputChannelArn = mlInputChannelArn, membershipIdentifier = membershipIdentifier)
  output <- .cleanroomsml$get_ml_input_channel_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_ml_input_channel <- cleanroomsml_get_ml_input_channel

#' Returns information about a trained model
#'
#' @description
#' Returns information about a trained model.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_trained_model/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_trained_model/) for full documentation.
#'
#' @param trainedModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the trained model that you are
#' interested in.
#' @param membershipIdentifier &#91;required&#93; The membership ID of the member that created the trained model that you
#' are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_trained_model
cleanroomsml_get_trained_model <- function(trainedModelArn, membershipIdentifier) {
  op <- new_operation(
    name = "GetTrainedModel",
    http_method = "GET",
    http_path = "/memberships/{membershipIdentifier}/trained-models/{trainedModelArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_trained_model_input(trainedModelArn = trainedModelArn, membershipIdentifier = membershipIdentifier)
  output <- .cleanroomsml$get_trained_model_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_trained_model <- cleanroomsml_get_trained_model

#' Returns information about a trained model inference job
#'
#' @description
#' Returns information about a trained model inference job.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_trained_model_inference_job/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_trained_model_inference_job/) for full documentation.
#'
#' @param membershipIdentifier &#91;required&#93; Provides the membership ID of the membership that contains the trained
#' model inference job that you are interested in.
#' @param trainedModelInferenceJobArn &#91;required&#93; Provides the Amazon Resource Name (ARN) of the trained model inference
#' job that you are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_trained_model_inference_job
cleanroomsml_get_trained_model_inference_job <- function(membershipIdentifier, trainedModelInferenceJobArn) {
  op <- new_operation(
    name = "GetTrainedModelInferenceJob",
    http_method = "GET",
    http_path = "/memberships/{membershipIdentifier}/trained-model-inference-jobs/{trainedModelInferenceJobArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_trained_model_inference_job_input(membershipIdentifier = membershipIdentifier, trainedModelInferenceJobArn = trainedModelInferenceJobArn)
  output <- .cleanroomsml$get_trained_model_inference_job_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_trained_model_inference_job <- cleanroomsml_get_trained_model_inference_job

#' Returns information about a training dataset
#'
#' @description
#' Returns information about a training dataset.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_get_training_dataset/](https://www.paws-r-sdk.com/docs/cleanroomsml_get_training_dataset/) for full documentation.
#'
#' @param trainingDatasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the training dataset that you are
#' interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_get_training_dataset
cleanroomsml_get_training_dataset <- function(trainingDatasetArn) {
  op <- new_operation(
    name = "GetTrainingDataset",
    http_method = "GET",
    http_path = "/training-dataset/{trainingDatasetArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$get_training_dataset_input(trainingDatasetArn = trainingDatasetArn)
  output <- .cleanroomsml$get_training_dataset_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$get_training_dataset <- cleanroomsml_get_training_dataset

#' Returns a list of the audience export jobs
#'
#' @description
#' Returns a list of the audience export jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_audience_export_jobs/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_audience_export_jobs/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#' @param audienceGenerationJobArn The Amazon Resource Name (ARN) of the audience generation job that you
#' are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_audience_export_jobs
cleanroomsml_list_audience_export_jobs <- function(nextToken = NULL, maxResults = NULL, audienceGenerationJobArn = NULL) {
  op <- new_operation(
    name = "ListAudienceExportJobs",
    http_method = "GET",
    http_path = "/audience-export-job",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "audienceExportJobs"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_audience_export_jobs_input(nextToken = nextToken, maxResults = maxResults, audienceGenerationJobArn = audienceGenerationJobArn)
  output <- .cleanroomsml$list_audience_export_jobs_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_audience_export_jobs <- cleanroomsml_list_audience_export_jobs

#' Returns a list of audience generation jobs
#'
#' @description
#' Returns a list of audience generation jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_audience_generation_jobs/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_audience_generation_jobs/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#' @param configuredAudienceModelArn The Amazon Resource Name (ARN) of the configured audience model that was
#' used for the audience generation jobs that you are interested in.
#' @param collaborationId The identifier of the collaboration that contains the audience
#' generation jobs that you are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_audience_generation_jobs
cleanroomsml_list_audience_generation_jobs <- function(nextToken = NULL, maxResults = NULL, configuredAudienceModelArn = NULL, collaborationId = NULL) {
  op <- new_operation(
    name = "ListAudienceGenerationJobs",
    http_method = "GET",
    http_path = "/audience-generation-job",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "audienceGenerationJobs"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_audience_generation_jobs_input(nextToken = nextToken, maxResults = maxResults, configuredAudienceModelArn = configuredAudienceModelArn, collaborationId = collaborationId)
  output <- .cleanroomsml$list_audience_generation_jobs_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_audience_generation_jobs <- cleanroomsml_list_audience_generation_jobs

#' Returns a list of audience models
#'
#' @description
#' Returns a list of audience models.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_audience_models/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_audience_models/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_audience_models
cleanroomsml_list_audience_models <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAudienceModels",
    http_method = "GET",
    http_path = "/audience-model",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "audienceModels"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_audience_models_input(nextToken = nextToken, maxResults = maxResults)
  output <- .cleanroomsml$list_audience_models_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_audience_models <- cleanroomsml_list_audience_models

#' Returns a list of the configured model algorithm associations in a
#' collaboration
#'
#' @description
#' Returns a list of the configured model algorithm associations in a collaboration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_collaboration_configured_model_algorithm_associations/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_collaboration_configured_model_algorithm_associations/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#' @param collaborationIdentifier &#91;required&#93; The collaboration ID of the collaboration that contains the configured
#' model algorithm associations that you are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_collab_config_model_algori_associ
cleanroomsml_list_collaboration_configured_model_algorithm_associations <- function(nextToken = NULL, maxResults = NULL, collaborationIdentifier) {
  op <- new_operation(
    name = "ListCollaborationConfiguredModelAlgorithmAssociations",
    http_method = "GET",
    http_path = "/collaborations/{collaborationIdentifier}/configured-model-algorithm-associations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "collaborationConfiguredModelAlgorithmAssociations"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_collaboration_configured_model_algorithm_associations_input(nextToken = nextToken, maxResults = maxResults, collaborationIdentifier = collaborationIdentifier)
  output <- .cleanroomsml$list_collaboration_configured_model_algorithm_associations_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_collaboration_configured_model_algorithm_associations <- cleanroomsml_list_collaboration_configured_model_algorithm_associations

#' Returns a list of the ML input channels in a collaboration
#'
#' @description
#' Returns a list of the ML input channels in a collaboration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_collaboration_ml_input_channels/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_collaboration_ml_input_channels/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum number of results to return.
#' @param collaborationIdentifier &#91;required&#93; The collaboration ID of the collaboration that contains the ML input
#' channels that you want to list.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_collaboration_ml_input_channels
cleanroomsml_list_collaboration_ml_input_channels <- function(nextToken = NULL, maxResults = NULL, collaborationIdentifier) {
  op <- new_operation(
    name = "ListCollaborationMLInputChannels",
    http_method = "GET",
    http_path = "/collaborations/{collaborationIdentifier}/ml-input-channels",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "collaborationMLInputChannelsList"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_collaboration_ml_input_channels_input(nextToken = nextToken, maxResults = maxResults, collaborationIdentifier = collaborationIdentifier)
  output <- .cleanroomsml$list_collaboration_ml_input_channels_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_collaboration_ml_input_channels <- cleanroomsml_list_collaboration_ml_input_channels

#' Returns a list of the export jobs for a trained model in a collaboration
#'
#' @description
#' Returns a list of the export jobs for a trained model in a collaboration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_collaboration_trained_model_export_jobs/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_collaboration_trained_model_export_jobs/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#' @param collaborationIdentifier &#91;required&#93; The collaboration ID of the collaboration that contains the trained
#' model export jobs that you are interested in.
#' @param trainedModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the trained model that was used to
#' create the export jobs that you are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_collaboration_trained_model_export_jobs
cleanroomsml_list_collaboration_trained_model_export_jobs <- function(nextToken = NULL, maxResults = NULL, collaborationIdentifier, trainedModelArn) {
  op <- new_operation(
    name = "ListCollaborationTrainedModelExportJobs",
    http_method = "GET",
    http_path = "/collaborations/{collaborationIdentifier}/trained-models/{trainedModelArn}/export-jobs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "collaborationTrainedModelExportJobs"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_collaboration_trained_model_export_jobs_input(nextToken = nextToken, maxResults = maxResults, collaborationIdentifier = collaborationIdentifier, trainedModelArn = trainedModelArn)
  output <- .cleanroomsml$list_collaboration_trained_model_export_jobs_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_collaboration_trained_model_export_jobs <- cleanroomsml_list_collaboration_trained_model_export_jobs

#' Returns a list of trained model inference jobs in a specified
#' collaboration
#'
#' @description
#' Returns a list of trained model inference jobs in a specified collaboration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_collaboration_trained_model_inference_jobs/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_collaboration_trained_model_inference_jobs/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#' @param collaborationIdentifier &#91;required&#93; The collaboration ID of the collaboration that contains the trained
#' model inference jobs that you are interested in.
#' @param trainedModelArn The Amazon Resource Name (ARN) of the trained model that was used to
#' create the trained model inference jobs that you are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_collaboration_trained_model_inference_jobs
cleanroomsml_list_collaboration_trained_model_inference_jobs <- function(nextToken = NULL, maxResults = NULL, collaborationIdentifier, trainedModelArn = NULL) {
  op <- new_operation(
    name = "ListCollaborationTrainedModelInferenceJobs",
    http_method = "GET",
    http_path = "/collaborations/{collaborationIdentifier}/trained-model-inference-jobs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "collaborationTrainedModelInferenceJobs"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_collaboration_trained_model_inference_jobs_input(nextToken = nextToken, maxResults = maxResults, collaborationIdentifier = collaborationIdentifier, trainedModelArn = trainedModelArn)
  output <- .cleanroomsml$list_collaboration_trained_model_inference_jobs_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_collaboration_trained_model_inference_jobs <- cleanroomsml_list_collaboration_trained_model_inference_jobs

#' Returns a list of the trained models in a collaboration
#'
#' @description
#' Returns a list of the trained models in a collaboration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_collaboration_trained_models/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_collaboration_trained_models/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#' @param collaborationIdentifier &#91;required&#93; The collaboration ID of the collaboration that contains the trained
#' models you are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_collaboration_trained_models
cleanroomsml_list_collaboration_trained_models <- function(nextToken = NULL, maxResults = NULL, collaborationIdentifier) {
  op <- new_operation(
    name = "ListCollaborationTrainedModels",
    http_method = "GET",
    http_path = "/collaborations/{collaborationIdentifier}/trained-models",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "collaborationTrainedModels"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_collaboration_trained_models_input(nextToken = nextToken, maxResults = maxResults, collaborationIdentifier = collaborationIdentifier)
  output <- .cleanroomsml$list_collaboration_trained_models_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_collaboration_trained_models <- cleanroomsml_list_collaboration_trained_models

#' Returns a list of the configured audience models
#'
#' @description
#' Returns a list of the configured audience models.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_configured_audience_models/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_configured_audience_models/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_configured_audience_models
cleanroomsml_list_configured_audience_models <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListConfiguredAudienceModels",
    http_method = "GET",
    http_path = "/configured-audience-model",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "configuredAudienceModels"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_configured_audience_models_input(nextToken = nextToken, maxResults = maxResults)
  output <- .cleanroomsml$list_configured_audience_models_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_configured_audience_models <- cleanroomsml_list_configured_audience_models

#' Returns a list of configured model algorithm associations
#'
#' @description
#' Returns a list of configured model algorithm associations.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_configured_model_algorithm_associations/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_configured_model_algorithm_associations/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#' @param membershipIdentifier &#91;required&#93; The membership ID of the member that created the configured model
#' algorithm associations you are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_configured_model_algorithm_associations
cleanroomsml_list_configured_model_algorithm_associations <- function(nextToken = NULL, maxResults = NULL, membershipIdentifier) {
  op <- new_operation(
    name = "ListConfiguredModelAlgorithmAssociations",
    http_method = "GET",
    http_path = "/memberships/{membershipIdentifier}/configured-model-algorithm-associations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "configuredModelAlgorithmAssociations"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_configured_model_algorithm_associations_input(nextToken = nextToken, maxResults = maxResults, membershipIdentifier = membershipIdentifier)
  output <- .cleanroomsml$list_configured_model_algorithm_associations_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_configured_model_algorithm_associations <- cleanroomsml_list_configured_model_algorithm_associations

#' Returns a list of configured model algorithms
#'
#' @description
#' Returns a list of configured model algorithms.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_configured_model_algorithms/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_configured_model_algorithms/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_configured_model_algorithms
cleanroomsml_list_configured_model_algorithms <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListConfiguredModelAlgorithms",
    http_method = "GET",
    http_path = "/configured-model-algorithms",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "configuredModelAlgorithms"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_configured_model_algorithms_input(nextToken = nextToken, maxResults = maxResults)
  output <- .cleanroomsml$list_configured_model_algorithms_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_configured_model_algorithms <- cleanroomsml_list_configured_model_algorithms

#' Returns a list of ML input channels
#'
#' @description
#' Returns a list of ML input channels.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_ml_input_channels/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_ml_input_channels/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum number of ML input channels to return.
#' @param membershipIdentifier &#91;required&#93; The membership ID of the membership that contains the ML input channels
#' that you want to list.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_ml_input_channels
cleanroomsml_list_ml_input_channels <- function(nextToken = NULL, maxResults = NULL, membershipIdentifier) {
  op <- new_operation(
    name = "ListMLInputChannels",
    http_method = "GET",
    http_path = "/memberships/{membershipIdentifier}/ml-input-channels",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "mlInputChannelsList"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_ml_input_channels_input(nextToken = nextToken, maxResults = maxResults, membershipIdentifier = membershipIdentifier)
  output <- .cleanroomsml$list_ml_input_channels_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_ml_input_channels <- cleanroomsml_list_ml_input_channels

#' Returns a list of tags for a provided resource
#'
#' @description
#' Returns a list of tags for a provided resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you are interested
#' in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_tags_for_resource
cleanroomsml_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .cleanroomsml$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_tags_for_resource <- cleanroomsml_list_tags_for_resource

#' Returns a list of trained model inference jobs that match the request
#' parameters
#'
#' @description
#' Returns a list of trained model inference jobs that match the request parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_trained_model_inference_jobs/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_trained_model_inference_jobs/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#' @param membershipIdentifier &#91;required&#93; The membership
#' @param trainedModelArn The Amazon Resource Name (ARN) of a trained model that was used to
#' create the trained model inference jobs that you are interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_trained_model_inference_jobs
cleanroomsml_list_trained_model_inference_jobs <- function(nextToken = NULL, maxResults = NULL, membershipIdentifier, trainedModelArn = NULL) {
  op <- new_operation(
    name = "ListTrainedModelInferenceJobs",
    http_method = "GET",
    http_path = "/memberships/{membershipIdentifier}/trained-model-inference-jobs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "trainedModelInferenceJobs"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_trained_model_inference_jobs_input(nextToken = nextToken, maxResults = maxResults, membershipIdentifier = membershipIdentifier, trainedModelArn = trainedModelArn)
  output <- .cleanroomsml$list_trained_model_inference_jobs_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_trained_model_inference_jobs <- cleanroomsml_list_trained_model_inference_jobs

#' Returns a list of trained models
#'
#' @description
#' Returns a list of trained models.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_trained_models/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_trained_models/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#' @param membershipIdentifier &#91;required&#93; The membership ID of the member that created the trained models you are
#' interested in.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_trained_models
cleanroomsml_list_trained_models <- function(nextToken = NULL, maxResults = NULL, membershipIdentifier) {
  op <- new_operation(
    name = "ListTrainedModels",
    http_method = "GET",
    http_path = "/memberships/{membershipIdentifier}/trained-models",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "trainedModels"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_trained_models_input(nextToken = nextToken, maxResults = maxResults, membershipIdentifier = membershipIdentifier)
  output <- .cleanroomsml$list_trained_models_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_trained_models <- cleanroomsml_list_trained_models

#' Returns a list of training datasets
#'
#' @description
#' Returns a list of training datasets.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_list_training_datasets/](https://www.paws-r-sdk.com/docs/cleanroomsml_list_training_datasets/) for full documentation.
#'
#' @param nextToken The token value retrieved from a previous call to access the next page
#' of results.
#' @param maxResults The maximum size of the results that is returned per call.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_list_training_datasets
cleanroomsml_list_training_datasets <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListTrainingDatasets",
    http_method = "GET",
    http_path = "/training-dataset",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "trainingDatasets"),
    stream_api = FALSE
  )
  input <- .cleanroomsml$list_training_datasets_input(nextToken = nextToken, maxResults = maxResults)
  output <- .cleanroomsml$list_training_datasets_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$list_training_datasets <- cleanroomsml_list_training_datasets

#' Create or update the resource policy for a configured audience model
#'
#' @description
#' Create or update the resource policy for a configured audience model.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_put_configured_audience_model_policy/](https://www.paws-r-sdk.com/docs/cleanroomsml_put_configured_audience_model_policy/) for full documentation.
#'
#' @param configuredAudienceModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured audience model that the
#' resource policy will govern.
#' @param configuredAudienceModelPolicy &#91;required&#93; The IAM resource policy.
#' @param previousPolicyHash A cryptographic hash of the contents of the policy used to prevent
#' unexpected concurrent modification of the policy.
#' @param policyExistenceCondition Use this to prevent unexpected concurrent modification of the policy.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_put_configured_audience_model_policy
cleanroomsml_put_configured_audience_model_policy <- function(configuredAudienceModelArn, configuredAudienceModelPolicy, previousPolicyHash = NULL, policyExistenceCondition = NULL) {
  op <- new_operation(
    name = "PutConfiguredAudienceModelPolicy",
    http_method = "PUT",
    http_path = "/configured-audience-model/{configuredAudienceModelArn}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$put_configured_audience_model_policy_input(configuredAudienceModelArn = configuredAudienceModelArn, configuredAudienceModelPolicy = configuredAudienceModelPolicy, previousPolicyHash = previousPolicyHash, policyExistenceCondition = policyExistenceCondition)
  output <- .cleanroomsml$put_configured_audience_model_policy_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$put_configured_audience_model_policy <- cleanroomsml_put_configured_audience_model_policy

#' Assigns information about an ML configuration
#'
#' @description
#' Assigns information about an ML configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_put_ml_configuration/](https://www.paws-r-sdk.com/docs/cleanroomsml_put_ml_configuration/) for full documentation.
#'
#' @param membershipIdentifier &#91;required&#93; The membership ID of the member that is being configured.
#' @param defaultOutputLocation &#91;required&#93; The default Amazon S3 location where ML output is stored for the
#' specified member.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_put_ml_configuration
cleanroomsml_put_ml_configuration <- function(membershipIdentifier, defaultOutputLocation) {
  op <- new_operation(
    name = "PutMLConfiguration",
    http_method = "PUT",
    http_path = "/memberships/{membershipIdentifier}/ml-configurations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$put_ml_configuration_input(membershipIdentifier = membershipIdentifier, defaultOutputLocation = defaultOutputLocation)
  output <- .cleanroomsml$put_ml_configuration_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$put_ml_configuration <- cleanroomsml_put_ml_configuration

#' Export an audience of a specified size after you have generated an
#' audience
#'
#' @description
#' Export an audience of a specified size after you have generated an audience.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_start_audience_export_job/](https://www.paws-r-sdk.com/docs/cleanroomsml_start_audience_export_job/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the audience export job.
#' @param audienceGenerationJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the audience generation job that you
#' want to export.
#' @param audienceSize &#91;required&#93; 
#' @param description The description of the audience export job.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_start_audience_export_job
cleanroomsml_start_audience_export_job <- function(name, audienceGenerationJobArn, audienceSize, description = NULL) {
  op <- new_operation(
    name = "StartAudienceExportJob",
    http_method = "POST",
    http_path = "/audience-export-job",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$start_audience_export_job_input(name = name, audienceGenerationJobArn = audienceGenerationJobArn, audienceSize = audienceSize, description = description)
  output <- .cleanroomsml$start_audience_export_job_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$start_audience_export_job <- cleanroomsml_start_audience_export_job

#' Information necessary to start the audience generation job
#'
#' @description
#' Information necessary to start the audience generation job.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_start_audience_generation_job/](https://www.paws-r-sdk.com/docs/cleanroomsml_start_audience_generation_job/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the audience generation job.
#' @param configuredAudienceModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured audience model that is
#' used for this audience generation job.
#' @param seedAudience &#91;required&#93; The seed audience that is used to generate the audience.
#' @param includeSeedInOutput Whether the seed audience is included in the audience generation output.
#' @param collaborationId The identifier of the collaboration that contains the audience
#' generation job.
#' @param description The description of the audience generation job.
#' @param tags The optional metadata that you apply to the resource to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use aws:, AWS:, or any upper or lowercase combination of such
#'     as a prefix for keys as it is reserved for AWS use. You cannot edit
#'     or delete tag keys with this prefix. Values can have this prefix. If
#'     a tag value has aws as its prefix but the key does not, then Clean
#'     Rooms ML considers it to be a user tag and will count against the
#'     limit of 50 tags. Tags with only the key prefix of aws do not count
#'     against your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_start_audience_generation_job
cleanroomsml_start_audience_generation_job <- function(name, configuredAudienceModelArn, seedAudience, includeSeedInOutput = NULL, collaborationId = NULL, description = NULL, tags = NULL) {
  op <- new_operation(
    name = "StartAudienceGenerationJob",
    http_method = "POST",
    http_path = "/audience-generation-job",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$start_audience_generation_job_input(name = name, configuredAudienceModelArn = configuredAudienceModelArn, seedAudience = seedAudience, includeSeedInOutput = includeSeedInOutput, collaborationId = collaborationId, description = description, tags = tags)
  output <- .cleanroomsml$start_audience_generation_job_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$start_audience_generation_job <- cleanroomsml_start_audience_generation_job

#' Provides the information necessary to start a trained model export job
#'
#' @description
#' Provides the information necessary to start a trained model export job.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_start_trained_model_export_job/](https://www.paws-r-sdk.com/docs/cleanroomsml_start_trained_model_export_job/) for full documentation.
#'
#' @param name &#91;required&#93; The name of the trained model export job.
#' @param trainedModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the trained model that you want to
#' export.
#' @param membershipIdentifier &#91;required&#93; The membership ID of the member that is receiving the exported trained
#' model artifacts.
#' @param outputConfiguration &#91;required&#93; The output configuration information for the trained model export job.
#' @param description The description of the trained model export job.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_start_trained_model_export_job
cleanroomsml_start_trained_model_export_job <- function(name, trainedModelArn, membershipIdentifier, outputConfiguration, description = NULL) {
  op <- new_operation(
    name = "StartTrainedModelExportJob",
    http_method = "POST",
    http_path = "/memberships/{membershipIdentifier}/trained-models/{trainedModelArn}/export-jobs",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$start_trained_model_export_job_input(name = name, trainedModelArn = trainedModelArn, membershipIdentifier = membershipIdentifier, outputConfiguration = outputConfiguration, description = description)
  output <- .cleanroomsml$start_trained_model_export_job_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$start_trained_model_export_job <- cleanroomsml_start_trained_model_export_job

#' Defines the information necessary to begin a trained model inference job
#'
#' @description
#' Defines the information necessary to begin a trained model inference job.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_start_trained_model_inference_job/](https://www.paws-r-sdk.com/docs/cleanroomsml_start_trained_model_inference_job/) for full documentation.
#'
#' @param membershipIdentifier &#91;required&#93; The membership ID of the membership that contains the trained model
#' inference job.
#' @param name &#91;required&#93; The name of the trained model inference job.
#' @param trainedModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the trained model that is used for
#' this trained model inference job.
#' @param configuredModelAlgorithmAssociationArn The Amazon Resource Name (ARN) of the configured model algorithm
#' association that is used for this trained model inference job.
#' @param resourceConfig &#91;required&#93; Defines the resource configuration for the trained model inference job.
#' @param outputConfiguration &#91;required&#93; Defines the output configuration information for the trained model
#' inference job.
#' @param dataSource &#91;required&#93; Defines the data source that is used for the trained model inference
#' job.
#' @param description The description of the trained model inference job.
#' @param containerExecutionParameters The execution parameters for the container.
#' @param environment The environment variables to set in the Docker container.
#' @param kmsKeyArn The Amazon Resource Name (ARN) of the KMS key. This key is used to
#' encrypt and decrypt customer-owned data in the ML inference job and
#' associated data.
#' @param tags The optional metadata that you apply to the resource to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use aws:, AWS:, or any upper or lowercase combination of such
#'     as a prefix for keys as it is reserved for AWS use. You cannot edit
#'     or delete tag keys with this prefix. Values can have this prefix. If
#'     a tag value has aws as its prefix but the key does not, then Clean
#'     Rooms ML considers it to be a user tag and will count against the
#'     limit of 50 tags. Tags with only the key prefix of aws do not count
#'     against your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_start_trained_model_inference_job
cleanroomsml_start_trained_model_inference_job <- function(membershipIdentifier, name, trainedModelArn, configuredModelAlgorithmAssociationArn = NULL, resourceConfig, outputConfiguration, dataSource, description = NULL, containerExecutionParameters = NULL, environment = NULL, kmsKeyArn = NULL, tags = NULL) {
  op <- new_operation(
    name = "StartTrainedModelInferenceJob",
    http_method = "POST",
    http_path = "/memberships/{membershipIdentifier}/trained-model-inference-jobs",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$start_trained_model_inference_job_input(membershipIdentifier = membershipIdentifier, name = name, trainedModelArn = trainedModelArn, configuredModelAlgorithmAssociationArn = configuredModelAlgorithmAssociationArn, resourceConfig = resourceConfig, outputConfiguration = outputConfiguration, dataSource = dataSource, description = description, containerExecutionParameters = containerExecutionParameters, environment = environment, kmsKeyArn = kmsKeyArn, tags = tags)
  output <- .cleanroomsml$start_trained_model_inference_job_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$start_trained_model_inference_job <- cleanroomsml_start_trained_model_inference_job

#' Adds metadata tags to a specified resource
#'
#' @description
#' Adds metadata tags to a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_tag_resource/](https://www.paws-r-sdk.com/docs/cleanroomsml_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to assign
#' tags.
#' @param tags &#91;required&#93; The optional metadata that you apply to the resource to help you
#' categorize and organize them. Each tag consists of a key and an optional
#' value, both of which you define.
#' 
#' The following basic restrictions apply to tags:
#' 
#' -   Maximum number of tags per resource - 50.
#' 
#' -   For each resource, each tag key must be unique, and each tag key can
#'     have only one value.
#' 
#' -   Maximum key length - 128 Unicode characters in UTF-8.
#' 
#' -   Maximum value length - 256 Unicode characters in UTF-8.
#' 
#' -   If your tagging schema is used across multiple services and
#'     resources, remember that other services may have restrictions on
#'     allowed characters. Generally allowed characters are: letters,
#'     numbers, and spaces representable in UTF-8, and the following
#'     characters: + - = . _ : / @@.
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Do not use aws:, AWS:, or any upper or lowercase combination of such
#'     as a prefix for keys as it is reserved for AWS use. You cannot edit
#'     or delete tag keys with this prefix. Values can have this prefix. If
#'     a tag value has aws as its prefix but the key does not, then Clean
#'     Rooms considers it to be a user tag and will count against the limit
#'     of 50 tags. Tags with only the key prefix of aws do not count
#'     against your tags per resource limit.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_tag_resource
cleanroomsml_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .cleanroomsml$tag_resource_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$tag_resource <- cleanroomsml_tag_resource

#' Removes metadata tags from a specified resource
#'
#' @description
#' Removes metadata tags from a specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_untag_resource/](https://www.paws-r-sdk.com/docs/cleanroomsml_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to remove
#' tags from.
#' @param tagKeys &#91;required&#93; The key values of tags that you want to remove.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_untag_resource
cleanroomsml_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .cleanroomsml$untag_resource_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$untag_resource <- cleanroomsml_untag_resource

#' Provides the information necessary to update a configured audience model
#'
#' @description
#' Provides the information necessary to update a configured audience model. Updates that impact audience generation jobs take effect when a new job starts, but do not impact currently running jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/cleanroomsml_update_configured_audience_model/](https://www.paws-r-sdk.com/docs/cleanroomsml_update_configured_audience_model/) for full documentation.
#'
#' @param configuredAudienceModelArn &#91;required&#93; The Amazon Resource Name (ARN) of the configured audience model that you
#' want to update.
#' @param outputConfig The new output configuration.
#' @param audienceModelArn The Amazon Resource Name (ARN) of the new audience model that you want
#' to use.
#' @param sharedAudienceMetrics The new value for whether to share audience metrics.
#' @param minMatchingSeedSize The minimum number of users from the seed audience that must match with
#' users in the training data of the audience model.
#' @param audienceSizeConfig The new audience size configuration.
#' @param description The new description of the configured audience model.
#'
#' @keywords internal
#'
#' @rdname cleanroomsml_update_configured_audience_model
cleanroomsml_update_configured_audience_model <- function(configuredAudienceModelArn, outputConfig = NULL, audienceModelArn = NULL, sharedAudienceMetrics = NULL, minMatchingSeedSize = NULL, audienceSizeConfig = NULL, description = NULL) {
  op <- new_operation(
    name = "UpdateConfiguredAudienceModel",
    http_method = "PATCH",
    http_path = "/configured-audience-model/{configuredAudienceModelArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .cleanroomsml$update_configured_audience_model_input(configuredAudienceModelArn = configuredAudienceModelArn, outputConfig = outputConfig, audienceModelArn = audienceModelArn, sharedAudienceMetrics = sharedAudienceMetrics, minMatchingSeedSize = minMatchingSeedSize, audienceSizeConfig = audienceSizeConfig, description = description)
  output <- .cleanroomsml$update_configured_audience_model_output()
  config <- get_config()
  svc <- .cleanroomsml$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cleanroomsml$operations$update_configured_audience_model <- cleanroomsml_update_configured_audience_model
