% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_create_api_key}
\alias{wafv2_create_api_key}
\title{Creates an API key that contains a set of token domains}
\usage{
wafv2_create_api_key(Scope, TokenDomains)
}
\arguments{
\item{Scope}{[required] Specifies whether this is for an Amazon CloudFront distribution or for a
regional application. A regional application can be an Application Load
Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
an Amazon Cognito user pool, an App Runner service, or an Amazon Web
Services Verified Access instance.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{TokenDomains}{[required] The client application domains that you want to use this API key for.

Example JSON: \verb{"TokenDomains": ["abc.com", "store.abc.com"]}

Public suffixes aren't allowed. For example, you can't use \code{gov.au} or
\code{co.uk} as token domains.}
}
\description{
Creates an API key that contains a set of token domains.

See \url{https://www.paws-r-sdk.com/docs/wafv2_create_api_key/} for full documentation.
}
\keyword{internal}
