# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include waf_service.R
NULL

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_byte_match_set/](https://www.paws-r-sdk.com/docs/waf_create_byte_match_set/) for full documentation.
#'
#' @param Name &#91;required&#93; A friendly name or description of the ByteMatchSet. You can't change
#' `Name` after you create a `ByteMatchSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_create_byte_match_set
waf_create_byte_match_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateByteMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_byte_match_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_byte_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_byte_match_set <- waf_create_byte_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_geo_match_set/](https://www.paws-r-sdk.com/docs/waf_create_geo_match_set/) for full documentation.
#'
#' @param Name &#91;required&#93; A friendly name or description of the GeoMatchSet. You can't change
#' `Name` after you create the `GeoMatchSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_create_geo_match_set
waf_create_geo_match_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateGeoMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_geo_match_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_geo_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_geo_match_set <- waf_create_geo_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_ip_set/](https://www.paws-r-sdk.com/docs/waf_create_ip_set/) for full documentation.
#'
#' @param Name &#91;required&#93; A friendly name or description of the IPSet. You can't change `Name`
#' after you create the `IPSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_create_ip_set
waf_create_ip_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateIPSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_ip_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_ip_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_ip_set <- waf_create_ip_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_rate_based_rule/](https://www.paws-r-sdk.com/docs/waf_create_rate_based_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; A friendly name or description of the RateBasedRule. You can't change
#' the name of a `RateBasedRule` after you create it.
#' @param MetricName &#91;required&#93; A friendly name or description for the metrics for this `RateBasedRule`.
#' The name can contain only alphanumeric characters (A-Z, a-z, 0-9), with
#' maximum length 128 and minimum length one. It can't contain whitespace
#' or metric names reserved for AWS WAF, including "All" and
#' "Default_Action." You can't change the name of the metric after you
#' create the `RateBasedRule`.
#' @param RateKey &#91;required&#93; The field that AWS WAF uses to determine if requests are likely arriving
#' from a single source and thus subject to rate monitoring. The only valid
#' value for `RateKey` is `IP`. `IP` indicates that requests that arrive
#' from the same IP address are subject to the `RateLimit` that is
#' specified in the `RateBasedRule`.
#' @param RateLimit &#91;required&#93; The maximum number of requests, which have an identical value in the
#' field that is specified by `RateKey`, allowed in a five-minute period.
#' If the number of requests exceeds the `RateLimit` and the other
#' predicates specified in the rule are also met, AWS WAF triggers the
#' action that is specified for this rule.
#' @param ChangeToken &#91;required&#93; The `ChangeToken` that you used to submit the
#' [`create_rate_based_rule`][waf_create_rate_based_rule] request. You can
#' also use this value to query the status of the request. For more
#' information, see
#' [`get_change_token_status`][waf_get_change_token_status].
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname waf_create_rate_based_rule
waf_create_rate_based_rule <- function(Name, MetricName, RateKey, RateLimit, ChangeToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateRateBasedRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_rate_based_rule_input(Name = Name, MetricName = MetricName, RateKey = RateKey, RateLimit = RateLimit, ChangeToken = ChangeToken, Tags = Tags)
  output <- .waf$create_rate_based_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_rate_based_rule <- waf_create_rate_based_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_regex_match_set/](https://www.paws-r-sdk.com/docs/waf_create_regex_match_set/) for full documentation.
#'
#' @param Name &#91;required&#93; A friendly name or description of the RegexMatchSet. You can't change
#' `Name` after you create a `RegexMatchSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_create_regex_match_set
waf_create_regex_match_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateRegexMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_regex_match_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_regex_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_regex_match_set <- waf_create_regex_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_regex_pattern_set/](https://www.paws-r-sdk.com/docs/waf_create_regex_pattern_set/) for full documentation.
#'
#' @param Name &#91;required&#93; A friendly name or description of the RegexPatternSet. You can't change
#' `Name` after you create a `RegexPatternSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_create_regex_pattern_set
waf_create_regex_pattern_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateRegexPatternSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_regex_pattern_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_regex_pattern_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_regex_pattern_set <- waf_create_regex_pattern_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_rule/](https://www.paws-r-sdk.com/docs/waf_create_rule/) for full documentation.
#'
#' @param Name &#91;required&#93; A friendly name or description of the Rule. You can't change the name of
#' a `Rule` after you create it.
#' @param MetricName &#91;required&#93; A friendly name or description for the metrics for this `Rule`. The name
#' can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum
#' length 128 and minimum length one. It can't contain whitespace or metric
#' names reserved for AWS WAF, including "All" and "Default_Action." You
#' can't change the name of the metric after you create the `Rule`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname waf_create_rule
waf_create_rule <- function(Name, MetricName, ChangeToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_rule_input(Name = Name, MetricName = MetricName, ChangeToken = ChangeToken, Tags = Tags)
  output <- .waf$create_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_rule <- waf_create_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_rule_group/](https://www.paws-r-sdk.com/docs/waf_create_rule_group/) for full documentation.
#'
#' @param Name &#91;required&#93; A friendly name or description of the RuleGroup. You can't change `Name`
#' after you create a `RuleGroup`.
#' @param MetricName &#91;required&#93; A friendly name or description for the metrics for this `RuleGroup`. The
#' name can contain only alphanumeric characters (A-Z, a-z, 0-9), with
#' maximum length 128 and minimum length one. It can't contain whitespace
#' or metric names reserved for AWS WAF, including "All" and
#' "Default_Action." You can't change the name of the metric after you
#' create the `RuleGroup`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname waf_create_rule_group
waf_create_rule_group <- function(Name, MetricName, ChangeToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_rule_group_input(Name = Name, MetricName = MetricName, ChangeToken = ChangeToken, Tags = Tags)
  output <- .waf$create_rule_group_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_rule_group <- waf_create_rule_group

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_size_constraint_set/](https://www.paws-r-sdk.com/docs/waf_create_size_constraint_set/) for full documentation.
#'
#' @param Name &#91;required&#93; A friendly name or description of the SizeConstraintSet. You can't
#' change `Name` after you create a `SizeConstraintSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_create_size_constraint_set
waf_create_size_constraint_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateSizeConstraintSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_size_constraint_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_size_constraint_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_size_constraint_set <- waf_create_size_constraint_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_sql_injection_match_set/](https://www.paws-r-sdk.com/docs/waf_create_sql_injection_match_set/) for full documentation.
#'
#' @param Name &#91;required&#93; A friendly name or description for the SqlInjectionMatchSet that you're
#' creating. You can't change `Name` after you create the
#' `SqlInjectionMatchSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_create_sql_injection_match_set
waf_create_sql_injection_match_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateSqlInjectionMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_sql_injection_match_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_sql_injection_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_sql_injection_match_set <- waf_create_sql_injection_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_web_acl/](https://www.paws-r-sdk.com/docs/waf_create_web_acl/) for full documentation.
#'
#' @param Name &#91;required&#93; A friendly name or description of the WebACL. You can't change `Name`
#' after you create the `WebACL`.
#' @param MetricName &#91;required&#93; A friendly name or description for the metrics for this `WebACL`.The
#' name can contain only alphanumeric characters (A-Z, a-z, 0-9), with
#' maximum length 128 and minimum length one. It can't contain whitespace
#' or metric names reserved for AWS WAF, including "All" and
#' "Default_Action." You can't change `MetricName` after you create the
#' `WebACL`.
#' @param DefaultAction &#91;required&#93; The action that you want AWS WAF to take when a request doesn't match
#' the criteria specified in any of the `Rule` objects that are associated
#' with the `WebACL`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname waf_create_web_acl
waf_create_web_acl <- function(Name, MetricName, DefaultAction, ChangeToken, Tags = NULL) {
  op <- new_operation(
    name = "CreateWebACL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_web_acl_input(Name = Name, MetricName = MetricName, DefaultAction = DefaultAction, ChangeToken = ChangeToken, Tags = Tags)
  output <- .waf$create_web_acl_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_web_acl <- waf_create_web_acl

#' Creates an AWS CloudFormation WAFV2 template for the specified web ACL
#' in the specified Amazon S3 bucket
#'
#' @description
#' Creates an AWS CloudFormation WAFV2 template for the specified web ACL in the specified Amazon S3 bucket. Then, in CloudFormation, you create a stack from the template, to create the web ACL and its resources in AWS WAFV2. Use this to migrate your AWS WAF Classic web ACL to the latest version of AWS WAF.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_web_acl_migration_stack/](https://www.paws-r-sdk.com/docs/waf_create_web_acl_migration_stack/) for full documentation.
#'
#' @param WebACLId &#91;required&#93; The UUID of the WAF Classic web ACL that you want to migrate to WAF v2.
#' @param S3BucketName &#91;required&#93; The name of the Amazon S3 bucket to store the CloudFormation template
#' in. The S3 bucket must be configured as follows for the migration:
#' 
#' -   The bucket name must start with `aws-waf-migration-`. For example,
#'     `aws-waf-migration-my-web-acl`.
#' 
#' -   The bucket must be in the Region where you are deploying the
#'     template. For example, for a web ACL in us-west-2, you must use an
#'     Amazon S3 bucket in us-west-2 and you must deploy the template stack
#'     to us-west-2.
#' 
#' -   The bucket policies must permit the migration process to write data.
#'     For listings of the bucket policies, see the Examples section.
#' @param IgnoreUnsupportedType &#91;required&#93; Indicates whether to exclude entities that can't be migrated or to stop
#' the migration. Set this to true to ignore unsupported entities in the
#' web ACL during the migration. Otherwise, if AWS WAF encounters
#' unsupported entities, it stops the process and throws an exception.
#'
#' @keywords internal
#'
#' @rdname waf_create_web_acl_migration_stack
waf_create_web_acl_migration_stack <- function(WebACLId, S3BucketName, IgnoreUnsupportedType) {
  op <- new_operation(
    name = "CreateWebACLMigrationStack",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_web_acl_migration_stack_input(WebACLId = WebACLId, S3BucketName = S3BucketName, IgnoreUnsupportedType = IgnoreUnsupportedType)
  output <- .waf$create_web_acl_migration_stack_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_web_acl_migration_stack <- waf_create_web_acl_migration_stack

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_create_xss_match_set/](https://www.paws-r-sdk.com/docs/waf_create_xss_match_set/) for full documentation.
#'
#' @param Name &#91;required&#93; A friendly name or description for the XssMatchSet that you're creating.
#' You can't change `Name` after you create the `XssMatchSet`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_create_xss_match_set
waf_create_xss_match_set <- function(Name, ChangeToken) {
  op <- new_operation(
    name = "CreateXssMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$create_xss_match_set_input(Name = Name, ChangeToken = ChangeToken)
  output <- .waf$create_xss_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$create_xss_match_set <- waf_create_xss_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_byte_match_set/](https://www.paws-r-sdk.com/docs/waf_delete_byte_match_set/) for full documentation.
#'
#' @param ByteMatchSetId &#91;required&#93; The `ByteMatchSetId` of the ByteMatchSet that you want to delete.
#' `ByteMatchSetId` is returned by
#' [`create_byte_match_set`][waf_create_byte_match_set] and by
#' [`list_byte_match_sets`][waf_list_byte_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_delete_byte_match_set
waf_delete_byte_match_set <- function(ByteMatchSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteByteMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_byte_match_set_input(ByteMatchSetId = ByteMatchSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_byte_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_byte_match_set <- waf_delete_byte_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_geo_match_set/](https://www.paws-r-sdk.com/docs/waf_delete_geo_match_set/) for full documentation.
#'
#' @param GeoMatchSetId &#91;required&#93; The `GeoMatchSetID` of the GeoMatchSet that you want to delete.
#' `GeoMatchSetId` is returned by
#' [`create_geo_match_set`][waf_create_geo_match_set] and by
#' [`list_geo_match_sets`][waf_list_geo_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_delete_geo_match_set
waf_delete_geo_match_set <- function(GeoMatchSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteGeoMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_geo_match_set_input(GeoMatchSetId = GeoMatchSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_geo_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_geo_match_set <- waf_delete_geo_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_ip_set/](https://www.paws-r-sdk.com/docs/waf_delete_ip_set/) for full documentation.
#'
#' @param IPSetId &#91;required&#93; The `IPSetId` of the IPSet that you want to delete. `IPSetId` is
#' returned by [`create_ip_set`][waf_create_ip_set] and by
#' [`list_ip_sets`][waf_list_ip_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_delete_ip_set
waf_delete_ip_set <- function(IPSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteIPSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_ip_set_input(IPSetId = IPSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_ip_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_ip_set <- waf_delete_ip_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_logging_configuration/](https://www.paws-r-sdk.com/docs/waf_delete_logging_configuration/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the web ACL from which you want to
#' delete the LoggingConfiguration.
#'
#' @keywords internal
#'
#' @rdname waf_delete_logging_configuration
waf_delete_logging_configuration <- function(ResourceArn) {
  op <- new_operation(
    name = "DeleteLoggingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_logging_configuration_input(ResourceArn = ResourceArn)
  output <- .waf$delete_logging_configuration_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_logging_configuration <- waf_delete_logging_configuration

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_permission_policy/](https://www.paws-r-sdk.com/docs/waf_delete_permission_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the RuleGroup from which you want to
#' delete the policy.
#' 
#' The user making the request must be the owner of the RuleGroup.
#'
#' @keywords internal
#'
#' @rdname waf_delete_permission_policy
waf_delete_permission_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "DeletePermissionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_permission_policy_input(ResourceArn = ResourceArn)
  output <- .waf$delete_permission_policy_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_permission_policy <- waf_delete_permission_policy

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_rate_based_rule/](https://www.paws-r-sdk.com/docs/waf_delete_rate_based_rule/) for full documentation.
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the RateBasedRule that you want to delete. `RuleId` is
#' returned by [`create_rate_based_rule`][waf_create_rate_based_rule] and
#' by [`list_rate_based_rules`][waf_list_rate_based_rules].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_delete_rate_based_rule
waf_delete_rate_based_rule <- function(RuleId, ChangeToken) {
  op <- new_operation(
    name = "DeleteRateBasedRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_rate_based_rule_input(RuleId = RuleId, ChangeToken = ChangeToken)
  output <- .waf$delete_rate_based_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_rate_based_rule <- waf_delete_rate_based_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_regex_match_set/](https://www.paws-r-sdk.com/docs/waf_delete_regex_match_set/) for full documentation.
#'
#' @param RegexMatchSetId &#91;required&#93; The `RegexMatchSetId` of the RegexMatchSet that you want to delete.
#' `RegexMatchSetId` is returned by
#' [`create_regex_match_set`][waf_create_regex_match_set] and by
#' [`list_regex_match_sets`][waf_list_regex_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_delete_regex_match_set
waf_delete_regex_match_set <- function(RegexMatchSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteRegexMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_regex_match_set_input(RegexMatchSetId = RegexMatchSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_regex_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_regex_match_set <- waf_delete_regex_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_regex_pattern_set/](https://www.paws-r-sdk.com/docs/waf_delete_regex_pattern_set/) for full documentation.
#'
#' @param RegexPatternSetId &#91;required&#93; The `RegexPatternSetId` of the RegexPatternSet that you want to delete.
#' `RegexPatternSetId` is returned by
#' [`create_regex_pattern_set`][waf_create_regex_pattern_set] and by
#' [`list_regex_pattern_sets`][waf_list_regex_pattern_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_delete_regex_pattern_set
waf_delete_regex_pattern_set <- function(RegexPatternSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteRegexPatternSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_regex_pattern_set_input(RegexPatternSetId = RegexPatternSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_regex_pattern_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_regex_pattern_set <- waf_delete_regex_pattern_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_rule/](https://www.paws-r-sdk.com/docs/waf_delete_rule/) for full documentation.
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the Rule that you want to delete. `RuleId` is returned
#' by [`create_rule`][waf_create_rule] and by
#' [`list_rules`][waf_list_rules].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_delete_rule
waf_delete_rule <- function(RuleId, ChangeToken) {
  op <- new_operation(
    name = "DeleteRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_rule_input(RuleId = RuleId, ChangeToken = ChangeToken)
  output <- .waf$delete_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_rule <- waf_delete_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_rule_group/](https://www.paws-r-sdk.com/docs/waf_delete_rule_group/) for full documentation.
#'
#' @param RuleGroupId &#91;required&#93; The `RuleGroupId` of the RuleGroup that you want to delete.
#' `RuleGroupId` is returned by
#' [`create_rule_group`][waf_create_rule_group] and by
#' [`list_rule_groups`][waf_list_rule_groups].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_delete_rule_group
waf_delete_rule_group <- function(RuleGroupId, ChangeToken) {
  op <- new_operation(
    name = "DeleteRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_rule_group_input(RuleGroupId = RuleGroupId, ChangeToken = ChangeToken)
  output <- .waf$delete_rule_group_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_rule_group <- waf_delete_rule_group

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_size_constraint_set/](https://www.paws-r-sdk.com/docs/waf_delete_size_constraint_set/) for full documentation.
#'
#' @param SizeConstraintSetId &#91;required&#93; The `SizeConstraintSetId` of the SizeConstraintSet that you want to
#' delete. `SizeConstraintSetId` is returned by
#' [`create_size_constraint_set`][waf_create_size_constraint_set] and by
#' [`list_size_constraint_sets`][waf_list_size_constraint_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_delete_size_constraint_set
waf_delete_size_constraint_set <- function(SizeConstraintSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteSizeConstraintSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_size_constraint_set_input(SizeConstraintSetId = SizeConstraintSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_size_constraint_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_size_constraint_set <- waf_delete_size_constraint_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_sql_injection_match_set/](https://www.paws-r-sdk.com/docs/waf_delete_sql_injection_match_set/) for full documentation.
#'
#' @param SqlInjectionMatchSetId &#91;required&#93; The `SqlInjectionMatchSetId` of the SqlInjectionMatchSet that you want
#' to delete. `SqlInjectionMatchSetId` is returned by
#' [`create_sql_injection_match_set`][waf_create_sql_injection_match_set]
#' and by
#' [`list_sql_injection_match_sets`][waf_list_sql_injection_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_delete_sql_injection_match_set
waf_delete_sql_injection_match_set <- function(SqlInjectionMatchSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteSqlInjectionMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_sql_injection_match_set_input(SqlInjectionMatchSetId = SqlInjectionMatchSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_sql_injection_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_sql_injection_match_set <- waf_delete_sql_injection_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_web_acl/](https://www.paws-r-sdk.com/docs/waf_delete_web_acl/) for full documentation.
#'
#' @param WebACLId &#91;required&#93; The `WebACLId` of the WebACL that you want to delete. `WebACLId` is
#' returned by [`create_web_acl`][waf_create_web_acl] and by
#' [`list_web_ac_ls`][waf_list_web_ac_ls].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_delete_web_acl
waf_delete_web_acl <- function(WebACLId, ChangeToken) {
  op <- new_operation(
    name = "DeleteWebACL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_web_acl_input(WebACLId = WebACLId, ChangeToken = ChangeToken)
  output <- .waf$delete_web_acl_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_web_acl <- waf_delete_web_acl

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_delete_xss_match_set/](https://www.paws-r-sdk.com/docs/waf_delete_xss_match_set/) for full documentation.
#'
#' @param XssMatchSetId &#91;required&#93; The `XssMatchSetId` of the XssMatchSet that you want to delete.
#' `XssMatchSetId` is returned by
#' [`create_xss_match_set`][waf_create_xss_match_set] and by
#' [`list_xss_match_sets`][waf_list_xss_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_delete_xss_match_set
waf_delete_xss_match_set <- function(XssMatchSetId, ChangeToken) {
  op <- new_operation(
    name = "DeleteXssMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$delete_xss_match_set_input(XssMatchSetId = XssMatchSetId, ChangeToken = ChangeToken)
  output <- .waf$delete_xss_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$delete_xss_match_set <- waf_delete_xss_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_byte_match_set/](https://www.paws-r-sdk.com/docs/waf_get_byte_match_set/) for full documentation.
#'
#' @param ByteMatchSetId &#91;required&#93; The `ByteMatchSetId` of the ByteMatchSet that you want to get.
#' `ByteMatchSetId` is returned by
#' [`create_byte_match_set`][waf_create_byte_match_set] and by
#' [`list_byte_match_sets`][waf_list_byte_match_sets].
#'
#' @keywords internal
#'
#' @rdname waf_get_byte_match_set
waf_get_byte_match_set <- function(ByteMatchSetId) {
  op <- new_operation(
    name = "GetByteMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_byte_match_set_input(ByteMatchSetId = ByteMatchSetId)
  output <- .waf$get_byte_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_byte_match_set <- waf_get_byte_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_change_token/](https://www.paws-r-sdk.com/docs/waf_get_change_token/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname waf_get_change_token
waf_get_change_token <- function() {
  op <- new_operation(
    name = "GetChangeToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_change_token_input()
  output <- .waf$get_change_token_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_change_token <- waf_get_change_token

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_change_token_status/](https://www.paws-r-sdk.com/docs/waf_get_change_token_status/) for full documentation.
#'
#' @param ChangeToken &#91;required&#93; The change token for which you want to get the status. This change token
#' was previously returned in the
#' [`get_change_token`][waf_get_change_token] response.
#'
#' @keywords internal
#'
#' @rdname waf_get_change_token_status
waf_get_change_token_status <- function(ChangeToken) {
  op <- new_operation(
    name = "GetChangeTokenStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_change_token_status_input(ChangeToken = ChangeToken)
  output <- .waf$get_change_token_status_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_change_token_status <- waf_get_change_token_status

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_geo_match_set/](https://www.paws-r-sdk.com/docs/waf_get_geo_match_set/) for full documentation.
#'
#' @param GeoMatchSetId &#91;required&#93; The `GeoMatchSetId` of the GeoMatchSet that you want to get.
#' `GeoMatchSetId` is returned by
#' [`create_geo_match_set`][waf_create_geo_match_set] and by
#' [`list_geo_match_sets`][waf_list_geo_match_sets].
#'
#' @keywords internal
#'
#' @rdname waf_get_geo_match_set
waf_get_geo_match_set <- function(GeoMatchSetId) {
  op <- new_operation(
    name = "GetGeoMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_geo_match_set_input(GeoMatchSetId = GeoMatchSetId)
  output <- .waf$get_geo_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_geo_match_set <- waf_get_geo_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_ip_set/](https://www.paws-r-sdk.com/docs/waf_get_ip_set/) for full documentation.
#'
#' @param IPSetId &#91;required&#93; The `IPSetId` of the IPSet that you want to get. `IPSetId` is returned
#' by [`create_ip_set`][waf_create_ip_set] and by
#' [`list_ip_sets`][waf_list_ip_sets].
#'
#' @keywords internal
#'
#' @rdname waf_get_ip_set
waf_get_ip_set <- function(IPSetId) {
  op <- new_operation(
    name = "GetIPSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_ip_set_input(IPSetId = IPSetId)
  output <- .waf$get_ip_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_ip_set <- waf_get_ip_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_logging_configuration/](https://www.paws-r-sdk.com/docs/waf_get_logging_configuration/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the web ACL for which you want to get
#' the LoggingConfiguration.
#'
#' @keywords internal
#'
#' @rdname waf_get_logging_configuration
waf_get_logging_configuration <- function(ResourceArn) {
  op <- new_operation(
    name = "GetLoggingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_logging_configuration_input(ResourceArn = ResourceArn)
  output <- .waf$get_logging_configuration_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_logging_configuration <- waf_get_logging_configuration

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_permission_policy/](https://www.paws-r-sdk.com/docs/waf_get_permission_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the RuleGroup for which you want to
#' get the policy.
#'
#' @keywords internal
#'
#' @rdname waf_get_permission_policy
waf_get_permission_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "GetPermissionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_permission_policy_input(ResourceArn = ResourceArn)
  output <- .waf$get_permission_policy_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_permission_policy <- waf_get_permission_policy

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_rate_based_rule/](https://www.paws-r-sdk.com/docs/waf_get_rate_based_rule/) for full documentation.
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the RateBasedRule that you want to get. `RuleId` is
#' returned by [`create_rate_based_rule`][waf_create_rate_based_rule] and
#' by [`list_rate_based_rules`][waf_list_rate_based_rules].
#'
#' @keywords internal
#'
#' @rdname waf_get_rate_based_rule
waf_get_rate_based_rule <- function(RuleId) {
  op <- new_operation(
    name = "GetRateBasedRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_rate_based_rule_input(RuleId = RuleId)
  output <- .waf$get_rate_based_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_rate_based_rule <- waf_get_rate_based_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_rate_based_rule_managed_keys/](https://www.paws-r-sdk.com/docs/waf_get_rate_based_rule_managed_keys/) for full documentation.
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the RateBasedRule for which you want to get a list of
#' `ManagedKeys`. `RuleId` is returned by
#' [`create_rate_based_rule`][waf_create_rate_based_rule] and by
#' [`list_rate_based_rules`][waf_list_rate_based_rules].
#' @param NextMarker A null value and not currently used. Do not include this in your
#' request.
#'
#' @keywords internal
#'
#' @rdname waf_get_rate_based_rule_managed_keys
waf_get_rate_based_rule_managed_keys <- function(RuleId, NextMarker = NULL) {
  op <- new_operation(
    name = "GetRateBasedRuleManagedKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_rate_based_rule_managed_keys_input(RuleId = RuleId, NextMarker = NextMarker)
  output <- .waf$get_rate_based_rule_managed_keys_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_rate_based_rule_managed_keys <- waf_get_rate_based_rule_managed_keys

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_regex_match_set/](https://www.paws-r-sdk.com/docs/waf_get_regex_match_set/) for full documentation.
#'
#' @param RegexMatchSetId &#91;required&#93; The `RegexMatchSetId` of the RegexMatchSet that you want to get.
#' `RegexMatchSetId` is returned by
#' [`create_regex_match_set`][waf_create_regex_match_set] and by
#' [`list_regex_match_sets`][waf_list_regex_match_sets].
#'
#' @keywords internal
#'
#' @rdname waf_get_regex_match_set
waf_get_regex_match_set <- function(RegexMatchSetId) {
  op <- new_operation(
    name = "GetRegexMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_regex_match_set_input(RegexMatchSetId = RegexMatchSetId)
  output <- .waf$get_regex_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_regex_match_set <- waf_get_regex_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_regex_pattern_set/](https://www.paws-r-sdk.com/docs/waf_get_regex_pattern_set/) for full documentation.
#'
#' @param RegexPatternSetId &#91;required&#93; The `RegexPatternSetId` of the RegexPatternSet that you want to get.
#' `RegexPatternSetId` is returned by
#' [`create_regex_pattern_set`][waf_create_regex_pattern_set] and by
#' [`list_regex_pattern_sets`][waf_list_regex_pattern_sets].
#'
#' @keywords internal
#'
#' @rdname waf_get_regex_pattern_set
waf_get_regex_pattern_set <- function(RegexPatternSetId) {
  op <- new_operation(
    name = "GetRegexPatternSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_regex_pattern_set_input(RegexPatternSetId = RegexPatternSetId)
  output <- .waf$get_regex_pattern_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_regex_pattern_set <- waf_get_regex_pattern_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_rule/](https://www.paws-r-sdk.com/docs/waf_get_rule/) for full documentation.
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the Rule that you want to get. `RuleId` is returned by
#' [`create_rule`][waf_create_rule] and by [`list_rules`][waf_list_rules].
#'
#' @keywords internal
#'
#' @rdname waf_get_rule
waf_get_rule <- function(RuleId) {
  op <- new_operation(
    name = "GetRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_rule_input(RuleId = RuleId)
  output <- .waf$get_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_rule <- waf_get_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_rule_group/](https://www.paws-r-sdk.com/docs/waf_get_rule_group/) for full documentation.
#'
#' @param RuleGroupId &#91;required&#93; The `RuleGroupId` of the RuleGroup that you want to get. `RuleGroupId`
#' is returned by [`create_rule_group`][waf_create_rule_group] and by
#' [`list_rule_groups`][waf_list_rule_groups].
#'
#' @keywords internal
#'
#' @rdname waf_get_rule_group
waf_get_rule_group <- function(RuleGroupId) {
  op <- new_operation(
    name = "GetRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_rule_group_input(RuleGroupId = RuleGroupId)
  output <- .waf$get_rule_group_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_rule_group <- waf_get_rule_group

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_sampled_requests/](https://www.paws-r-sdk.com/docs/waf_get_sampled_requests/) for full documentation.
#'
#' @param WebAclId &#91;required&#93; The `WebACLId` of the `WebACL` for which you want
#' [`get_sampled_requests`][waf_get_sampled_requests] to return a sample of
#' requests.
#' @param RuleId &#91;required&#93; `RuleId` is one of three values:
#' 
#' -   The `RuleId` of the `Rule` or the `RuleGroupId` of the `RuleGroup`
#'     for which you want
#'     [`get_sampled_requests`][waf_get_sampled_requests] to return a
#'     sample of requests.
#' 
#' -   `Default_Action`, which causes
#'     [`get_sampled_requests`][waf_get_sampled_requests] to return a
#'     sample of the requests that didn't match any of the rules in the
#'     specified `WebACL`.
#' @param TimeWindow &#91;required&#93; The start date and time and the end date and time of the range for which
#' you want [`get_sampled_requests`][waf_get_sampled_requests] to return a
#' sample of requests. You must specify the times in Coordinated Universal
#' Time (UTC) format. UTC format includes the special designator, `Z`. For
#' example, `"2016-09-27T14:50Z"`. You can specify any time range in the
#' previous three hours.
#' @param MaxItems &#91;required&#93; The number of requests that you want AWS WAF to return from among the
#' first 5,000 requests that your AWS resource received during the time
#' range. If your resource received fewer requests than the value of
#' `MaxItems`, [`get_sampled_requests`][waf_get_sampled_requests] returns
#' information about all of them.
#'
#' @keywords internal
#'
#' @rdname waf_get_sampled_requests
waf_get_sampled_requests <- function(WebAclId, RuleId, TimeWindow, MaxItems) {
  op <- new_operation(
    name = "GetSampledRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_sampled_requests_input(WebAclId = WebAclId, RuleId = RuleId, TimeWindow = TimeWindow, MaxItems = MaxItems)
  output <- .waf$get_sampled_requests_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_sampled_requests <- waf_get_sampled_requests

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_size_constraint_set/](https://www.paws-r-sdk.com/docs/waf_get_size_constraint_set/) for full documentation.
#'
#' @param SizeConstraintSetId &#91;required&#93; The `SizeConstraintSetId` of the SizeConstraintSet that you want to get.
#' `SizeConstraintSetId` is returned by
#' [`create_size_constraint_set`][waf_create_size_constraint_set] and by
#' [`list_size_constraint_sets`][waf_list_size_constraint_sets].
#'
#' @keywords internal
#'
#' @rdname waf_get_size_constraint_set
waf_get_size_constraint_set <- function(SizeConstraintSetId) {
  op <- new_operation(
    name = "GetSizeConstraintSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_size_constraint_set_input(SizeConstraintSetId = SizeConstraintSetId)
  output <- .waf$get_size_constraint_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_size_constraint_set <- waf_get_size_constraint_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_sql_injection_match_set/](https://www.paws-r-sdk.com/docs/waf_get_sql_injection_match_set/) for full documentation.
#'
#' @param SqlInjectionMatchSetId &#91;required&#93; The `SqlInjectionMatchSetId` of the SqlInjectionMatchSet that you want
#' to get. `SqlInjectionMatchSetId` is returned by
#' [`create_sql_injection_match_set`][waf_create_sql_injection_match_set]
#' and by
#' [`list_sql_injection_match_sets`][waf_list_sql_injection_match_sets].
#'
#' @keywords internal
#'
#' @rdname waf_get_sql_injection_match_set
waf_get_sql_injection_match_set <- function(SqlInjectionMatchSetId) {
  op <- new_operation(
    name = "GetSqlInjectionMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_sql_injection_match_set_input(SqlInjectionMatchSetId = SqlInjectionMatchSetId)
  output <- .waf$get_sql_injection_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_sql_injection_match_set <- waf_get_sql_injection_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_web_acl/](https://www.paws-r-sdk.com/docs/waf_get_web_acl/) for full documentation.
#'
#' @param WebACLId &#91;required&#93; The `WebACLId` of the WebACL that you want to get. `WebACLId` is
#' returned by [`create_web_acl`][waf_create_web_acl] and by
#' [`list_web_ac_ls`][waf_list_web_ac_ls].
#'
#' @keywords internal
#'
#' @rdname waf_get_web_acl
waf_get_web_acl <- function(WebACLId) {
  op <- new_operation(
    name = "GetWebACL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_web_acl_input(WebACLId = WebACLId)
  output <- .waf$get_web_acl_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_web_acl <- waf_get_web_acl

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_get_xss_match_set/](https://www.paws-r-sdk.com/docs/waf_get_xss_match_set/) for full documentation.
#'
#' @param XssMatchSetId &#91;required&#93; The `XssMatchSetId` of the XssMatchSet that you want to get.
#' `XssMatchSetId` is returned by
#' [`create_xss_match_set`][waf_create_xss_match_set] and by
#' [`list_xss_match_sets`][waf_list_xss_match_sets].
#'
#' @keywords internal
#'
#' @rdname waf_get_xss_match_set
waf_get_xss_match_set <- function(XssMatchSetId) {
  op <- new_operation(
    name = "GetXssMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$get_xss_match_set_input(XssMatchSetId = XssMatchSetId)
  output <- .waf$get_xss_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$get_xss_match_set <- waf_get_xss_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_activated_rules_in_rule_group/](https://www.paws-r-sdk.com/docs/waf_list_activated_rules_in_rule_group/) for full documentation.
#'
#' @param RuleGroupId The `RuleGroupId` of the RuleGroup for which you want to get a list of
#' ActivatedRule objects.
#' @param NextMarker If you specify a value for `Limit` and you have more `ActivatedRules`
#' than the value of `Limit`, AWS WAF returns a `NextMarker` value in the
#' response that allows you to list another group of `ActivatedRules`. For
#' the second and subsequent
#' [`list_activated_rules_in_rule_group`][waf_list_activated_rules_in_rule_group]
#' requests, specify the value of `NextMarker` from the previous response
#' to get information about another batch of `ActivatedRules`.
#' @param Limit Specifies the number of `ActivatedRules` that you want AWS WAF to return
#' for this request. If you have more `ActivatedRules` than the number that
#' you specify for `Limit`, the response includes a `NextMarker` value that
#' you can use to get another batch of `ActivatedRules`.
#'
#' @keywords internal
#'
#' @rdname waf_list_activated_rules_in_rule_group
waf_list_activated_rules_in_rule_group <- function(RuleGroupId = NULL, NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListActivatedRulesInRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_activated_rules_in_rule_group_input(RuleGroupId = RuleGroupId, NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_activated_rules_in_rule_group_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_activated_rules_in_rule_group <- waf_list_activated_rules_in_rule_group

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_byte_match_sets/](https://www.paws-r-sdk.com/docs/waf_list_byte_match_sets/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `ByteMatchSets`
#' than the value of `Limit`, AWS WAF returns a `NextMarker` value in the
#' response that allows you to list another group of `ByteMatchSets`. For
#' the second and subsequent
#' [`list_byte_match_sets`][waf_list_byte_match_sets] requests, specify the
#' value of `NextMarker` from the previous response to get information
#' about another batch of `ByteMatchSets`.
#' @param Limit Specifies the number of `ByteMatchSet` objects that you want AWS WAF to
#' return for this request. If you have more `ByteMatchSets` objects than
#' the number you specify for `Limit`, the response includes a `NextMarker`
#' value that you can use to get another batch of `ByteMatchSet` objects.
#'
#' @keywords internal
#'
#' @rdname waf_list_byte_match_sets
waf_list_byte_match_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListByteMatchSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_byte_match_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_byte_match_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_byte_match_sets <- waf_list_byte_match_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_geo_match_sets/](https://www.paws-r-sdk.com/docs/waf_list_geo_match_sets/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `GeoMatchSet`s than
#' the value of `Limit`, AWS WAF returns a `NextMarker` value in the
#' response that allows you to list another group of `GeoMatchSet` objects.
#' For the second and subsequent
#' [`list_geo_match_sets`][waf_list_geo_match_sets] requests, specify the
#' value of `NextMarker` from the previous response to get information
#' about another batch of `GeoMatchSet` objects.
#' @param Limit Specifies the number of `GeoMatchSet` objects that you want AWS WAF to
#' return for this request. If you have more `GeoMatchSet` objects than the
#' number you specify for `Limit`, the response includes a `NextMarker`
#' value that you can use to get another batch of `GeoMatchSet` objects.
#'
#' @keywords internal
#'
#' @rdname waf_list_geo_match_sets
waf_list_geo_match_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListGeoMatchSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_geo_match_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_geo_match_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_geo_match_sets <- waf_list_geo_match_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_ip_sets/](https://www.paws-r-sdk.com/docs/waf_list_ip_sets/) for full documentation.
#'
#' @param NextMarker AWS WAF returns a `NextMarker` value in the response that allows you to
#' list another group of `IPSets`. For the second and subsequent
#' [`list_ip_sets`][waf_list_ip_sets] requests, specify the value of
#' `NextMarker` from the previous response to get information about another
#' batch of `IPSets`.
#' @param Limit Specifies the number of `IPSet` objects that you want AWS WAF to return
#' for this request. If you have more `IPSet` objects than the number you
#' specify for `Limit`, the response includes a `NextMarker` value that you
#' can use to get another batch of `IPSet` objects.
#'
#' @keywords internal
#'
#' @rdname waf_list_ip_sets
waf_list_ip_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListIPSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_ip_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_ip_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_ip_sets <- waf_list_ip_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_logging_configurations/](https://www.paws-r-sdk.com/docs/waf_list_logging_configurations/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more
#' `LoggingConfigurations` than the value of `Limit`, AWS WAF returns a
#' `NextMarker` value in the response that allows you to list another group
#' of `LoggingConfigurations`. For the second and subsequent
#' [`list_logging_configurations`][waf_list_logging_configurations]
#' requests, specify the value of `NextMarker` from the previous response
#' to get information about another batch of
#' [`list_logging_configurations`][waf_list_logging_configurations].
#' @param Limit Specifies the number of `LoggingConfigurations` that you want AWS WAF to
#' return for this request. If you have more `LoggingConfigurations` than
#' the number that you specify for `Limit`, the response includes a
#' `NextMarker` value that you can use to get another batch of
#' `LoggingConfigurations`.
#'
#' @keywords internal
#'
#' @rdname waf_list_logging_configurations
waf_list_logging_configurations <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListLoggingConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_logging_configurations_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_logging_configurations_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_logging_configurations <- waf_list_logging_configurations

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_rate_based_rules/](https://www.paws-r-sdk.com/docs/waf_list_rate_based_rules/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `Rules` than the
#' value of `Limit`, AWS WAF returns a `NextMarker` value in the response
#' that allows you to list another group of `Rules`. For the second and
#' subsequent [`list_rate_based_rules`][waf_list_rate_based_rules]
#' requests, specify the value of `NextMarker` from the previous response
#' to get information about another batch of `Rules`.
#' @param Limit Specifies the number of `Rules` that you want AWS WAF to return for this
#' request. If you have more `Rules` than the number that you specify for
#' `Limit`, the response includes a `NextMarker` value that you can use to
#' get another batch of `Rules`.
#'
#' @keywords internal
#'
#' @rdname waf_list_rate_based_rules
waf_list_rate_based_rules <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRateBasedRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_rate_based_rules_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_rate_based_rules_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_rate_based_rules <- waf_list_rate_based_rules

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_regex_match_sets/](https://www.paws-r-sdk.com/docs/waf_list_regex_match_sets/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `RegexMatchSet`
#' objects than the value of `Limit`, AWS WAF returns a `NextMarker` value
#' in the response that allows you to list another group of
#' `ByteMatchSets`. For the second and subsequent
#' [`list_regex_match_sets`][waf_list_regex_match_sets] requests, specify
#' the value of `NextMarker` from the previous response to get information
#' about another batch of `RegexMatchSet` objects.
#' @param Limit Specifies the number of `RegexMatchSet` objects that you want AWS WAF to
#' return for this request. If you have more `RegexMatchSet` objects than
#' the number you specify for `Limit`, the response includes a `NextMarker`
#' value that you can use to get another batch of `RegexMatchSet` objects.
#'
#' @keywords internal
#'
#' @rdname waf_list_regex_match_sets
waf_list_regex_match_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRegexMatchSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_regex_match_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_regex_match_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_regex_match_sets <- waf_list_regex_match_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_regex_pattern_sets/](https://www.paws-r-sdk.com/docs/waf_list_regex_pattern_sets/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `RegexPatternSet`
#' objects than the value of `Limit`, AWS WAF returns a `NextMarker` value
#' in the response that allows you to list another group of
#' `RegexPatternSet` objects. For the second and subsequent
#' [`list_regex_pattern_sets`][waf_list_regex_pattern_sets] requests,
#' specify the value of `NextMarker` from the previous response to get
#' information about another batch of `RegexPatternSet` objects.
#' @param Limit Specifies the number of `RegexPatternSet` objects that you want AWS WAF
#' to return for this request. If you have more `RegexPatternSet` objects
#' than the number you specify for `Limit`, the response includes a
#' `NextMarker` value that you can use to get another batch of
#' `RegexPatternSet` objects.
#'
#' @keywords internal
#'
#' @rdname waf_list_regex_pattern_sets
waf_list_regex_pattern_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRegexPatternSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_regex_pattern_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_regex_pattern_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_regex_pattern_sets <- waf_list_regex_pattern_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_rule_groups/](https://www.paws-r-sdk.com/docs/waf_list_rule_groups/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `RuleGroups` than
#' the value of `Limit`, AWS WAF returns a `NextMarker` value in the
#' response that allows you to list another group of `RuleGroups`. For the
#' second and subsequent [`list_rule_groups`][waf_list_rule_groups]
#' requests, specify the value of `NextMarker` from the previous response
#' to get information about another batch of `RuleGroups`.
#' @param Limit Specifies the number of `RuleGroups` that you want AWS WAF to return for
#' this request. If you have more `RuleGroups` than the number that you
#' specify for `Limit`, the response includes a `NextMarker` value that you
#' can use to get another batch of `RuleGroups`.
#'
#' @keywords internal
#'
#' @rdname waf_list_rule_groups
waf_list_rule_groups <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRuleGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_rule_groups_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_rule_groups_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_rule_groups <- waf_list_rule_groups

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_rules/](https://www.paws-r-sdk.com/docs/waf_list_rules/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `Rules` than the
#' value of `Limit`, AWS WAF returns a `NextMarker` value in the response
#' that allows you to list another group of `Rules`. For the second and
#' subsequent [`list_rules`][waf_list_rules] requests, specify the value of
#' `NextMarker` from the previous response to get information about another
#' batch of `Rules`.
#' @param Limit Specifies the number of `Rules` that you want AWS WAF to return for this
#' request. If you have more `Rules` than the number that you specify for
#' `Limit`, the response includes a `NextMarker` value that you can use to
#' get another batch of `Rules`.
#'
#' @keywords internal
#'
#' @rdname waf_list_rules
waf_list_rules <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_rules_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_rules_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_rules <- waf_list_rules

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_size_constraint_sets/](https://www.paws-r-sdk.com/docs/waf_list_size_constraint_sets/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more
#' `SizeConstraintSets` than the value of `Limit`, AWS WAF returns a
#' `NextMarker` value in the response that allows you to list another group
#' of `SizeConstraintSets`. For the second and subsequent
#' [`list_size_constraint_sets`][waf_list_size_constraint_sets] requests,
#' specify the value of `NextMarker` from the previous response to get
#' information about another batch of `SizeConstraintSets`.
#' @param Limit Specifies the number of `SizeConstraintSet` objects that you want AWS
#' WAF to return for this request. If you have more `SizeConstraintSets`
#' objects than the number you specify for `Limit`, the response includes a
#' `NextMarker` value that you can use to get another batch of
#' `SizeConstraintSet` objects.
#'
#' @keywords internal
#'
#' @rdname waf_list_size_constraint_sets
waf_list_size_constraint_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListSizeConstraintSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_size_constraint_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_size_constraint_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_size_constraint_sets <- waf_list_size_constraint_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_sql_injection_match_sets/](https://www.paws-r-sdk.com/docs/waf_list_sql_injection_match_sets/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more
#' SqlInjectionMatchSet objects than the value of `Limit`, AWS WAF returns
#' a `NextMarker` value in the response that allows you to list another
#' group of `SqlInjectionMatchSets`. For the second and subsequent
#' [`list_sql_injection_match_sets`][waf_list_sql_injection_match_sets]
#' requests, specify the value of `NextMarker` from the previous response
#' to get information about another batch of `SqlInjectionMatchSets`.
#' @param Limit Specifies the number of SqlInjectionMatchSet objects that you want AWS
#' WAF to return for this request. If you have more `SqlInjectionMatchSet`
#' objects than the number you specify for `Limit`, the response includes a
#' `NextMarker` value that you can use to get another batch of `Rules`.
#'
#' @keywords internal
#'
#' @rdname waf_list_sql_injection_match_sets
waf_list_sql_injection_match_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListSqlInjectionMatchSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_sql_injection_match_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_sql_injection_match_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_sql_injection_match_sets <- waf_list_sql_injection_match_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_subscribed_rule_groups/](https://www.paws-r-sdk.com/docs/waf_list_subscribed_rule_groups/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more
#' `ByteMatchSets`subscribed rule groups than the value of `Limit`, AWS WAF
#' returns a `NextMarker` value in the response that allows you to list
#' another group of subscribed rule groups. For the second and subsequent
#' `ListSubscribedRuleGroupsRequest` requests, specify the value of
#' `NextMarker` from the previous response to get information about another
#' batch of subscribed rule groups.
#' @param Limit Specifies the number of subscribed rule groups that you want AWS WAF to
#' return for this request. If you have more objects than the number you
#' specify for `Limit`, the response includes a `NextMarker` value that you
#' can use to get another batch of objects.
#'
#' @keywords internal
#'
#' @rdname waf_list_subscribed_rule_groups
waf_list_subscribed_rule_groups <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListSubscribedRuleGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_subscribed_rule_groups_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_subscribed_rule_groups_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_subscribed_rule_groups <- waf_list_subscribed_rule_groups

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/waf_list_tags_for_resource/) for full documentation.
#'
#' @param NextMarker 
#' @param Limit 
#' @param ResourceARN &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname waf_list_tags_for_resource
waf_list_tags_for_resource <- function(NextMarker = NULL, Limit = NULL, ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_tags_for_resource_input(NextMarker = NextMarker, Limit = Limit, ResourceARN = ResourceARN)
  output <- .waf$list_tags_for_resource_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_tags_for_resource <- waf_list_tags_for_resource

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_web_ac_ls/](https://www.paws-r-sdk.com/docs/waf_list_web_ac_ls/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more `WebACL` objects
#' than the number that you specify for `Limit`, AWS WAF returns a
#' `NextMarker` value in the response that allows you to list another group
#' of `WebACL` objects. For the second and subsequent
#' [`list_web_ac_ls`][waf_list_web_ac_ls] requests, specify the value of
#' `NextMarker` from the previous response to get information about another
#' batch of `WebACL` objects.
#' @param Limit Specifies the number of `WebACL` objects that you want AWS WAF to return
#' for this request. If you have more `WebACL` objects than the number that
#' you specify for `Limit`, the response includes a `NextMarker` value that
#' you can use to get another batch of `WebACL` objects.
#'
#' @keywords internal
#'
#' @rdname waf_list_web_ac_ls
waf_list_web_ac_ls <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListWebACLs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_web_ac_ls_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_web_ac_ls_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_web_ac_ls <- waf_list_web_ac_ls

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_list_xss_match_sets/](https://www.paws-r-sdk.com/docs/waf_list_xss_match_sets/) for full documentation.
#'
#' @param NextMarker If you specify a value for `Limit` and you have more XssMatchSet objects
#' than the value of `Limit`, AWS WAF returns a `NextMarker` value in the
#' response that allows you to list another group of `XssMatchSets`. For
#' the second and subsequent
#' [`list_xss_match_sets`][waf_list_xss_match_sets] requests, specify the
#' value of `NextMarker` from the previous response to get information
#' about another batch of `XssMatchSets`.
#' @param Limit Specifies the number of XssMatchSet objects that you want AWS WAF to
#' return for this request. If you have more `XssMatchSet` objects than the
#' number you specify for `Limit`, the response includes a `NextMarker`
#' value that you can use to get another batch of `Rules`.
#'
#' @keywords internal
#'
#' @rdname waf_list_xss_match_sets
waf_list_xss_match_sets <- function(NextMarker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "ListXssMatchSets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$list_xss_match_sets_input(NextMarker = NextMarker, Limit = Limit)
  output <- .waf$list_xss_match_sets_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$list_xss_match_sets <- waf_list_xss_match_sets

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_put_logging_configuration/](https://www.paws-r-sdk.com/docs/waf_put_logging_configuration/) for full documentation.
#'
#' @param LoggingConfiguration &#91;required&#93; The Amazon Kinesis Data Firehose that contains the inspected traffic
#' information, the redacted fields details, and the Amazon Resource Name
#' (ARN) of the web ACL to monitor.
#' 
#' When specifying `Type` in `RedactedFields`, you must use one of the
#' following values: `URI`, `QUERY_STRING`, `HEADER`, or `METHOD`.
#'
#' @keywords internal
#'
#' @rdname waf_put_logging_configuration
waf_put_logging_configuration <- function(LoggingConfiguration) {
  op <- new_operation(
    name = "PutLoggingConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$put_logging_configuration_input(LoggingConfiguration = LoggingConfiguration)
  output <- .waf$put_logging_configuration_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$put_logging_configuration <- waf_put_logging_configuration

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_put_permission_policy/](https://www.paws-r-sdk.com/docs/waf_put_permission_policy/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the RuleGroup to which you want to
#' attach the policy.
#' @param Policy &#91;required&#93; The policy to attach to the specified RuleGroup.
#'
#' @keywords internal
#'
#' @rdname waf_put_permission_policy
waf_put_permission_policy <- function(ResourceArn, Policy) {
  op <- new_operation(
    name = "PutPermissionPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$put_permission_policy_input(ResourceArn = ResourceArn, Policy = Policy)
  output <- .waf$put_permission_policy_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$put_permission_policy <- waf_put_permission_policy

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_tag_resource/](https://www.paws-r-sdk.com/docs/waf_tag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; 
#' @param Tags &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname waf_tag_resource
waf_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .waf$tag_resource_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$tag_resource <- waf_tag_resource

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_untag_resource/](https://www.paws-r-sdk.com/docs/waf_untag_resource/) for full documentation.
#'
#' @param ResourceARN &#91;required&#93; 
#' @param TagKeys &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname waf_untag_resource
waf_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .waf$untag_resource_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$untag_resource <- waf_untag_resource

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_update_byte_match_set/](https://www.paws-r-sdk.com/docs/waf_update_byte_match_set/) for full documentation.
#'
#' @param ByteMatchSetId &#91;required&#93; The `ByteMatchSetId` of the ByteMatchSet that you want to update.
#' `ByteMatchSetId` is returned by
#' [`create_byte_match_set`][waf_create_byte_match_set] and by
#' [`list_byte_match_sets`][waf_list_byte_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `ByteMatchSetUpdate` objects that you want to insert into or
#' delete from a ByteMatchSet. For more information, see the applicable
#' data types:
#' 
#' -   ByteMatchSetUpdate: Contains `Action` and `ByteMatchTuple`
#' 
#' -   ByteMatchTuple: Contains `FieldToMatch`, `PositionalConstraint`,
#'     `TargetString`, and `TextTransformation`
#' 
#' -   FieldToMatch: Contains `Data` and `Type`
#'
#' @keywords internal
#'
#' @rdname waf_update_byte_match_set
waf_update_byte_match_set <- function(ByteMatchSetId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateByteMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_byte_match_set_input(ByteMatchSetId = ByteMatchSetId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_byte_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_byte_match_set <- waf_update_byte_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_update_geo_match_set/](https://www.paws-r-sdk.com/docs/waf_update_geo_match_set/) for full documentation.
#'
#' @param GeoMatchSetId &#91;required&#93; The `GeoMatchSetId` of the GeoMatchSet that you want to update.
#' `GeoMatchSetId` is returned by
#' [`create_geo_match_set`][waf_create_geo_match_set] and by
#' [`list_geo_match_sets`][waf_list_geo_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `GeoMatchSetUpdate` objects that you want to insert into or
#' delete from an GeoMatchSet. For more information, see the applicable
#' data types:
#' 
#' -   GeoMatchSetUpdate: Contains `Action` and `GeoMatchConstraint`
#' 
#' -   GeoMatchConstraint: Contains `Type` and `Value`
#' 
#'     You can have only one `Type` and `Value` per `GeoMatchConstraint`.
#'     To add multiple countries, include multiple `GeoMatchSetUpdate`
#'     objects in your request.
#'
#' @keywords internal
#'
#' @rdname waf_update_geo_match_set
waf_update_geo_match_set <- function(GeoMatchSetId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateGeoMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_geo_match_set_input(GeoMatchSetId = GeoMatchSetId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_geo_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_geo_match_set <- waf_update_geo_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_update_ip_set/](https://www.paws-r-sdk.com/docs/waf_update_ip_set/) for full documentation.
#'
#' @param IPSetId &#91;required&#93; The `IPSetId` of the IPSet that you want to update. `IPSetId` is
#' returned by [`create_ip_set`][waf_create_ip_set] and by
#' [`list_ip_sets`][waf_list_ip_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `IPSetUpdate` objects that you want to insert into or delete
#' from an IPSet. For more information, see the applicable data types:
#' 
#' -   IPSetUpdate: Contains `Action` and `IPSetDescriptor`
#' 
#' -   IPSetDescriptor: Contains `Type` and `Value`
#' 
#' You can insert a maximum of 1000 addresses in a single request.
#'
#' @keywords internal
#'
#' @rdname waf_update_ip_set
waf_update_ip_set <- function(IPSetId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateIPSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_ip_set_input(IPSetId = IPSetId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_ip_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_ip_set <- waf_update_ip_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_update_rate_based_rule/](https://www.paws-r-sdk.com/docs/waf_update_rate_based_rule/) for full documentation.
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the `RateBasedRule` that you want to update. `RuleId` is
#' returned by [`create_rate_based_rule`][waf_create_rate_based_rule] and
#' by [`list_rate_based_rules`][waf_list_rate_based_rules].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `RuleUpdate` objects that you want to insert into or delete
#' from a RateBasedRule.
#' @param RateLimit &#91;required&#93; The maximum number of requests, which have an identical value in the
#' field specified by the `RateKey`, allowed in a five-minute period. If
#' the number of requests exceeds the `RateLimit` and the other predicates
#' specified in the rule are also met, AWS WAF triggers the action that is
#' specified for this rule.
#'
#' @keywords internal
#'
#' @rdname waf_update_rate_based_rule
waf_update_rate_based_rule <- function(RuleId, ChangeToken, Updates, RateLimit) {
  op <- new_operation(
    name = "UpdateRateBasedRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_rate_based_rule_input(RuleId = RuleId, ChangeToken = ChangeToken, Updates = Updates, RateLimit = RateLimit)
  output <- .waf$update_rate_based_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_rate_based_rule <- waf_update_rate_based_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_update_regex_match_set/](https://www.paws-r-sdk.com/docs/waf_update_regex_match_set/) for full documentation.
#'
#' @param RegexMatchSetId &#91;required&#93; The `RegexMatchSetId` of the RegexMatchSet that you want to update.
#' `RegexMatchSetId` is returned by
#' [`create_regex_match_set`][waf_create_regex_match_set] and by
#' [`list_regex_match_sets`][waf_list_regex_match_sets].
#' @param Updates &#91;required&#93; An array of `RegexMatchSetUpdate` objects that you want to insert into
#' or delete from a RegexMatchSet. For more information, see
#' RegexMatchTuple.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_update_regex_match_set
waf_update_regex_match_set <- function(RegexMatchSetId, Updates, ChangeToken) {
  op <- new_operation(
    name = "UpdateRegexMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_regex_match_set_input(RegexMatchSetId = RegexMatchSetId, Updates = Updates, ChangeToken = ChangeToken)
  output <- .waf$update_regex_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_regex_match_set <- waf_update_regex_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_update_regex_pattern_set/](https://www.paws-r-sdk.com/docs/waf_update_regex_pattern_set/) for full documentation.
#'
#' @param RegexPatternSetId &#91;required&#93; The `RegexPatternSetId` of the RegexPatternSet that you want to update.
#' `RegexPatternSetId` is returned by
#' [`create_regex_pattern_set`][waf_create_regex_pattern_set] and by
#' [`list_regex_pattern_sets`][waf_list_regex_pattern_sets].
#' @param Updates &#91;required&#93; An array of `RegexPatternSetUpdate` objects that you want to insert into
#' or delete from a RegexPatternSet.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_update_regex_pattern_set
waf_update_regex_pattern_set <- function(RegexPatternSetId, Updates, ChangeToken) {
  op <- new_operation(
    name = "UpdateRegexPatternSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_regex_pattern_set_input(RegexPatternSetId = RegexPatternSetId, Updates = Updates, ChangeToken = ChangeToken)
  output <- .waf$update_regex_pattern_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_regex_pattern_set <- waf_update_regex_pattern_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_update_rule/](https://www.paws-r-sdk.com/docs/waf_update_rule/) for full documentation.
#'
#' @param RuleId &#91;required&#93; The `RuleId` of the `Rule` that you want to update. `RuleId` is returned
#' by [`create_rule`][waf_create_rule] and by
#' [`list_rules`][waf_list_rules].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `RuleUpdate` objects that you want to insert into or delete
#' from a Rule. For more information, see the applicable data types:
#' 
#' -   RuleUpdate: Contains `Action` and `Predicate`
#' 
#' -   Predicate: Contains `DataId`, `Negated`, and `Type`
#' 
#' -   FieldToMatch: Contains `Data` and `Type`
#'
#' @keywords internal
#'
#' @rdname waf_update_rule
waf_update_rule <- function(RuleId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_rule_input(RuleId = RuleId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_rule_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_rule <- waf_update_rule

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_update_rule_group/](https://www.paws-r-sdk.com/docs/waf_update_rule_group/) for full documentation.
#'
#' @param RuleGroupId &#91;required&#93; The `RuleGroupId` of the RuleGroup that you want to update.
#' `RuleGroupId` is returned by
#' [`create_rule_group`][waf_create_rule_group] and by
#' [`list_rule_groups`][waf_list_rule_groups].
#' @param Updates &#91;required&#93; An array of `RuleGroupUpdate` objects that you want to insert into or
#' delete from a RuleGroup.
#' 
#' You can only insert `REGULAR` rules into a rule group.
#' 
#' `ActivatedRule|OverrideAction` applies only when updating or adding a
#' `RuleGroup` to a `WebACL`. In this case you do not use
#' `ActivatedRule|Action`. For all other update requests,
#' `ActivatedRule|Action` is used instead of
#' `ActivatedRule|OverrideAction`.
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#'
#' @keywords internal
#'
#' @rdname waf_update_rule_group
waf_update_rule_group <- function(RuleGroupId, Updates, ChangeToken) {
  op <- new_operation(
    name = "UpdateRuleGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_rule_group_input(RuleGroupId = RuleGroupId, Updates = Updates, ChangeToken = ChangeToken)
  output <- .waf$update_rule_group_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_rule_group <- waf_update_rule_group

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_update_size_constraint_set/](https://www.paws-r-sdk.com/docs/waf_update_size_constraint_set/) for full documentation.
#'
#' @param SizeConstraintSetId &#91;required&#93; The `SizeConstraintSetId` of the SizeConstraintSet that you want to
#' update. `SizeConstraintSetId` is returned by
#' [`create_size_constraint_set`][waf_create_size_constraint_set] and by
#' [`list_size_constraint_sets`][waf_list_size_constraint_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `SizeConstraintSetUpdate` objects that you want to insert
#' into or delete from a SizeConstraintSet. For more information, see the
#' applicable data types:
#' 
#' -   SizeConstraintSetUpdate: Contains `Action` and `SizeConstraint`
#' 
#' -   SizeConstraint: Contains `FieldToMatch`, `TextTransformation`,
#'     `ComparisonOperator`, and `Size`
#' 
#' -   FieldToMatch: Contains `Data` and `Type`
#'
#' @keywords internal
#'
#' @rdname waf_update_size_constraint_set
waf_update_size_constraint_set <- function(SizeConstraintSetId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateSizeConstraintSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_size_constraint_set_input(SizeConstraintSetId = SizeConstraintSetId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_size_constraint_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_size_constraint_set <- waf_update_size_constraint_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_update_sql_injection_match_set/](https://www.paws-r-sdk.com/docs/waf_update_sql_injection_match_set/) for full documentation.
#'
#' @param SqlInjectionMatchSetId &#91;required&#93; The `SqlInjectionMatchSetId` of the `SqlInjectionMatchSet` that you want
#' to update. `SqlInjectionMatchSetId` is returned by
#' [`create_sql_injection_match_set`][waf_create_sql_injection_match_set]
#' and by
#' [`list_sql_injection_match_sets`][waf_list_sql_injection_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `SqlInjectionMatchSetUpdate` objects that you want to insert
#' into or delete from a SqlInjectionMatchSet. For more information, see
#' the applicable data types:
#' 
#' -   SqlInjectionMatchSetUpdate: Contains `Action` and
#'     `SqlInjectionMatchTuple`
#' 
#' -   SqlInjectionMatchTuple: Contains `FieldToMatch` and
#'     `TextTransformation`
#' 
#' -   FieldToMatch: Contains `Data` and `Type`
#'
#' @keywords internal
#'
#' @rdname waf_update_sql_injection_match_set
waf_update_sql_injection_match_set <- function(SqlInjectionMatchSetId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateSqlInjectionMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_sql_injection_match_set_input(SqlInjectionMatchSetId = SqlInjectionMatchSetId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_sql_injection_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_sql_injection_match_set <- waf_update_sql_injection_match_set

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_update_web_acl/](https://www.paws-r-sdk.com/docs/waf_update_web_acl/) for full documentation.
#'
#' @param WebACLId &#91;required&#93; The `WebACLId` of the WebACL that you want to update. `WebACLId` is
#' returned by [`create_web_acl`][waf_create_web_acl] and by
#' [`list_web_ac_ls`][waf_list_web_ac_ls].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates An array of updates to make to the WebACL.
#' 
#' An array of `WebACLUpdate` objects that you want to insert into or
#' delete from a WebACL. For more information, see the applicable data
#' types:
#' 
#' -   WebACLUpdate: Contains `Action` and `ActivatedRule`
#' 
#' -   ActivatedRule: Contains `Action`, `OverrideAction`, `Priority`,
#'     `RuleId`, and `Type`. `ActivatedRule|OverrideAction` applies only
#'     when updating or adding a `RuleGroup` to a `WebACL`. In this case,
#'     you do not use `ActivatedRule|Action`. For all other update
#'     requests, `ActivatedRule|Action` is used instead of
#'     `ActivatedRule|OverrideAction`.
#' 
#' -   WafAction: Contains `Type`
#' @param DefaultAction A default action for the web ACL, either ALLOW or BLOCK. AWS WAF
#' performs the default action if a request doesn't match the criteria in
#' any of the rules in a web ACL.
#'
#' @keywords internal
#'
#' @rdname waf_update_web_acl
waf_update_web_acl <- function(WebACLId, ChangeToken, Updates = NULL, DefaultAction = NULL) {
  op <- new_operation(
    name = "UpdateWebACL",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_web_acl_input(WebACLId = WebACLId, ChangeToken = ChangeToken, Updates = Updates, DefaultAction = DefaultAction)
  output <- .waf$update_web_acl_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_web_acl <- waf_update_web_acl

#' This is AWS WAF Classic documentation
#'
#' @description
#' This is **AWS WAF Classic** documentation. For more information, see [AWS WAF Classic](https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html) in the developer guide.
#'
#' See [https://www.paws-r-sdk.com/docs/waf_update_xss_match_set/](https://www.paws-r-sdk.com/docs/waf_update_xss_match_set/) for full documentation.
#'
#' @param XssMatchSetId &#91;required&#93; The `XssMatchSetId` of the `XssMatchSet` that you want to update.
#' `XssMatchSetId` is returned by
#' [`create_xss_match_set`][waf_create_xss_match_set] and by
#' [`list_xss_match_sets`][waf_list_xss_match_sets].
#' @param ChangeToken &#91;required&#93; The value returned by the most recent call to
#' [`get_change_token`][waf_get_change_token].
#' @param Updates &#91;required&#93; An array of `XssMatchSetUpdate` objects that you want to insert into or
#' delete from an XssMatchSet. For more information, see the applicable
#' data types:
#' 
#' -   XssMatchSetUpdate: Contains `Action` and `XssMatchTuple`
#' 
#' -   XssMatchTuple: Contains `FieldToMatch` and `TextTransformation`
#' 
#' -   FieldToMatch: Contains `Data` and `Type`
#'
#' @keywords internal
#'
#' @rdname waf_update_xss_match_set
waf_update_xss_match_set <- function(XssMatchSetId, ChangeToken, Updates) {
  op <- new_operation(
    name = "UpdateXssMatchSet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .waf$update_xss_match_set_input(XssMatchSetId = XssMatchSetId, ChangeToken = ChangeToken, Updates = Updates)
  output <- .waf$update_xss_match_set_output()
  config <- get_config()
  svc <- .waf$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.waf$operations$update_xss_match_set <- waf_update_xss_match_set
