% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_get_decrypted_api_key}
\alias{wafv2_get_decrypted_api_key}
\title{Returns your API key in decrypted form}
\usage{
wafv2_get_decrypted_api_key(Scope, APIKey)
}
\arguments{
\item{Scope}{[required] Specifies whether this is for an Amazon CloudFront distribution or for a
regional application. A regional application can be an Application Load
Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
an Amazon Cognito user pool, an App Runner service, or an Amazon Web
Services Verified Access instance.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{APIKey}{[required] The encrypted API key.}
}
\description{
Returns your API key in decrypted form. Use this to check the token domains that you have defined for the key.

See \url{https://www.paws-r-sdk.com/docs/wafv2_get_decrypted_api_key/} for full documentation.
}
\keyword{internal}
