% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identitystore_operations.R
\name{identitystore_create_user}
\alias{identitystore_create_user}
\title{Creates a user within the specified identity store}
\usage{
identitystore_create_user(
  IdentityStoreId,
  UserName = NULL,
  Name = NULL,
  DisplayName = NULL,
  NickName = NULL,
  ProfileUrl = NULL,
  Emails = NULL,
  Addresses = NULL,
  PhoneNumbers = NULL,
  UserType = NULL,
  Title = NULL,
  PreferredLanguage = NULL,
  Locale = NULL,
  Timezone = NULL
)
}
\arguments{
\item{IdentityStoreId}{[required] The globally unique identifier for the identity store.}

\item{UserName}{A unique string used to identify the user. The length limit is 128
characters. This value can consist of letters, accented characters,
symbols, numbers, and punctuation. This value is specified at the time
the user is created and stored as an attribute of the user object in the
identity store. \code{Administrator} and \code{AWSAdministrators} are reserved
names and can't be used for users or groups.}

\item{Name}{An object containing the name of the user.}

\item{DisplayName}{A string containing the name of the user. This value is typically
formatted for display when the user is referenced. For example, "John
Doe."}

\item{NickName}{A string containing an alternate name for the user.}

\item{ProfileUrl}{A string containing a URL that might be associated with the user.}

\item{Emails}{A list of \code{Email} objects containing email addresses associated with the
user.}

\item{Addresses}{A list of \code{Address} objects containing addresses associated with the
user.}

\item{PhoneNumbers}{A list of \code{PhoneNumber} objects containing phone numbers associated with
the user.}

\item{UserType}{A string indicating the type of user. Possible values are left
unspecified. The value can vary based on your specific use case.}

\item{Title}{A string containing the title of the user. Possible values are left
unspecified. The value can vary based on your specific use case.}

\item{PreferredLanguage}{A string containing the preferred language of the user. For example,
"American English" or "en-us."}

\item{Locale}{A string containing the geographical region or location of the user.}

\item{Timezone}{A string containing the time zone of the user.}
}
\description{
Creates a user within the specified identity store.

See \url{https://www.paws-r-sdk.com/docs/identitystore_create_user/} for full documentation.
}
\keyword{internal}
