% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_get_web_acl_for_resource}
\alias{wafv2_get_web_acl_for_resource}
\title{Retrieves the WebACL for the specified resource}
\usage{
wafv2_get_web_acl_for_resource(ResourceArn)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the resource whose web ACL you want to
retrieve.

The ARN must be in one of the following formats:
\itemize{
\item For an Application Load Balancer:
\code{arn:partition:elasticloadbalancing:region:account-id:loadbalancer/app/load-balancer-name/load-balancer-id }
\item For an Amazon API Gateway REST API:
\verb{arn:partition:apigateway:region::/restapis/api-id/stages/stage-name }
\item For an AppSync GraphQL API:
\code{arn:partition:appsync:region:account-id:apis/GraphQLApiId }
\item For an Amazon Cognito user pool:
\code{arn:partition:cognito-idp:region:account-id:userpool/user-pool-id }
\item For an App Runner service:
\code{arn:partition:apprunner:region:account-id:service/apprunner-service-name/apprunner-service-id }
\item For an Amazon Web Services Verified Access instance:
\code{arn:partition:ec2:region:account-id:verified-access-instance/instance-id }
}}
}
\description{
Retrieves the WebACL for the specified resource.

See \url{https://www.paws-r-sdk.com/docs/wafv2_get_web_acl_for_resource/} for full documentation.
}
\keyword{internal}
