% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaconnectorad_operations.R
\name{pcaconnectorad_create_template}
\alias{pcaconnectorad_create_template}
\title{Creates an Active Directory compatible certificate template}
\usage{
pcaconnectorad_create_template(
  ClientToken = NULL,
  ConnectorArn,
  Definition,
  Name,
  Tags = NULL
)
}
\arguments{
\item{ClientToken}{Idempotency token.}

\item{ConnectorArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
\code{\link[=pcaconnectorad_create_connector]{create_connector}}.}

\item{Definition}{[required] Template configuration to define the information included in
certificates. Define certificate validity and renewal periods,
certificate request handling and enrollment options, key usage
extensions, application policies, and cryptography settings.}

\item{Name}{[required] Name of the template. The template name must be unique.}

\item{Tags}{Metadata assigned to a template consisting of a key-value pair.}
}
\description{
Creates an Active Directory compatible certificate template. The connectors issues certificates using these templates based on the requester’s Active Directory group membership.

See \url{https://www.paws-r-sdk.com/docs/pcaconnectorad_create_template/} for full documentation.
}
\keyword{internal}
