% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identitystore_operations.R
\name{identitystore_list_group_memberships_for_member}
\alias{identitystore_list_group_memberships_for_member}
\title{For the specified member in the specified identity store, returns the
list of all GroupMembership objects and returns results in paginated
form}
\usage{
identitystore_list_group_memberships_for_member(
  IdentityStoreId,
  MemberId,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{IdentityStoreId}{[required] The globally unique identifier for the identity store.}

\item{MemberId}{[required] An object that contains the identifier of a group member. Setting the
\code{UserID} field to the specific identifier for a user indicates that the
user is a member of the group.}

\item{MaxResults}{The maximum number of results to be returned per request. This parameter
is used in the \code{\link[=identitystore_list_users]{list_users}} and
\code{\link[=identitystore_list_groups]{list_groups}} requests to specify how many
results to return in one page. The length limit is 50 characters.}

\item{NextToken}{The pagination token used for the
\code{\link[=identitystore_list_users]{list_users}},
\code{\link[=identitystore_list_groups]{list_groups}}, and
\code{\link[=identitystore_list_group_memberships]{list_group_memberships}} API
operations. This value is generated by the identity store service. It is
returned in the API response if the total results are more than the size
of one page. This token is also returned when it is used in the API
request to search for the next page.}
}
\description{
For the specified member in the specified identity store, returns the list of all \code{GroupMembership} objects and returns results in paginated form.

See \url{https://www.paws-r-sdk.com/docs/identitystore_list_group_memberships_for_member/} for full documentation.
}
\keyword{internal}
