% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_list_admin_accounts_for_organization}
\alias{fms_list_admin_accounts_for_organization}
\title{Returns a AdminAccounts object that lists the Firewall Manager
administrators within the organization that are onboarded to Firewall
Manager by AssociateAdminAccount}
\usage{
fms_list_admin_accounts_for_organization(NextToken = NULL, MaxResults = NULL)
}
\arguments{
\item{NextToken}{When you request a list of objects with a \code{MaxResults} setting, if the
number of objects that are still available for retrieval exceeds the
maximum you requested, Firewall Manager returns a \code{NextToken} value in
the response. To retrieve the next batch of objects, use the token
returned from the prior request in your next request.}

\item{MaxResults}{The maximum number of objects that you want Firewall Manager to return
for this request. If more objects are available, in the response,
Firewall Manager provides a \code{NextToken} value that you can use in a
subsequent call to get the next batch of objects.}
}
\description{
Returns a \code{AdminAccounts} object that lists the Firewall Manager administrators within the organization that are onboarded to Firewall Manager by \code{\link[=fms_associate_admin_account]{associate_admin_account}}.

See \url{https://www.paws-r-sdk.com/docs/fms_list_admin_accounts_for_organization/} for full documentation.
}
\keyword{internal}
