% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_get_rule}
\alias{wafregional_get_rule}
\title{This is AWS WAF CLASSIC documentation}
\usage{
wafregional_get_rule(RuleId)
}
\arguments{
\item{RuleId}{[required] The \code{RuleId} of the Rule that you want to get. \code{RuleId} is returned by
CreateRule and by ListRules.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.
}
\details{
\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Returns the Rule that is specified by the \code{RuleId} that you included in
the \code{GetRule} request.
}
\section{Request syntax}{
\preformatted{svc$get_rule(
  RuleId = "string"
)
}
}

\examples{
\dontrun{
# The following example returns the details of a rule with the ID
# example1ds3t-46da-4fdb-b8d5-abc321j569j5.
svc$get_rule(
  RuleId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
)
}

}
\keyword{internal}
