% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_batch_update_findings}
\alias{securityhub_batch_update_findings}
\title{Used by Security Hub customers to update information about their
investigation into a finding}
\usage{
securityhub_batch_update_findings(FindingIdentifiers, Note, Severity,
  VerificationState, Confidence, Criticality, Types, UserDefinedFields,
  Workflow, RelatedFindings)
}
\arguments{
\item{FindingIdentifiers}{[required] The list of findings to update. \code{BatchUpdateFindings} can be used to
update up to 100 findings at a time.

For each finding, the list provides the finding identifier and the ARN
of the finding provider.}

\item{Note}{}

\item{Severity}{Used to update the finding severity.}

\item{VerificationState}{Indicates the veracity of a finding.

The available values for \code{VerificationState} are as follows.
\itemize{
\item \code{UNKNOWN} -- The default disposition of a security finding
\item \code{TRUE_POSITIVE} -- The security finding is confirmed
\item \code{FALSE_POSITIVE} -- The security finding was determined to be a
false alarm
\item \code{BENIGN_POSITIVE} -- A special case of \code{TRUE_POSITIVE} where the
finding doesn\'t pose any threat, is expected, or both
}}

\item{Confidence}{The updated value for the finding confidence. Confidence is defined as
the likelihood that a finding accurately identifies the behavior or
issue that it was intended to identify.

Confidence is scored on a 0-100 basis using a ratio scale, where 0 means
zero percent confidence and 100 means 100 percent confidence.}

\item{Criticality}{The updated value for the level of importance assigned to the resources
associated with the findings.

A score of 0 means that the underlying resources have no criticality,
and a score of 100 is reserved for the most critical resources.}

\item{Types}{One or more finding types in the format of namespace/category/classifier
that classify a finding.

Valid namespace values are as follows.
\itemize{
\item Software and Configuration Checks
\item TTPs
\item Effects
\item Unusual Behaviors
\item Sensitive Data Identifications
}}

\item{UserDefinedFields}{A list of name/value string pairs associated with the finding. These are
custom, user-defined fields added to a finding.}

\item{Workflow}{Used to update the workflow status of a finding.

The workflow status indicates the progress of the investigation into the
finding.}

\item{RelatedFindings}{A list of findings that are related to the updated findings.}
}
\description{
Used by Security Hub customers to update information about their
investigation into a finding. Requested by master accounts or member
accounts. Master accounts can update findings for their account and
their member accounts. Member accounts can update findings for their
account.
}
\details{
Updates from \code{BatchUpdateFindings} do not affect the value of
\code{UpdatedAt} for a finding.

Master accounts can use \code{BatchUpdateFindings} to update the following
finding fields and objects.
\itemize{
\item \code{Confidence}
\item \code{Criticality}
\item \code{Note}
\item \code{RelatedFindings}
\item \code{Severity}
\item \code{Types}
\item \code{UserDefinedFields}
\item \code{VerificationState}
\item \code{Workflow}
}

Member accounts can only use \code{BatchUpdateFindings} to update the Note
object.
}
\section{Request syntax}{
\preformatted{svc$batch_update_findings(
  FindingIdentifiers = list(
    list(
      Id = "string",
      ProductArn = "string"
    )
  ),
  Note = list(
    Text = "string",
    UpdatedBy = "string"
  ),
  Severity = list(
    Normalized = 123,
    Product = 123.0,
    Label = "INFORMATIONAL"|"LOW"|"MEDIUM"|"HIGH"|"CRITICAL"
  ),
  VerificationState = "UNKNOWN"|"TRUE_POSITIVE"|"FALSE_POSITIVE"|"BENIGN_POSITIVE",
  Confidence = 123,
  Criticality = 123,
  Types = list(
    "string"
  ),
  UserDefinedFields = list(
    "string"
  ),
  Workflow = list(
    Status = "NEW"|"NOTIFIED"|"RESOLVED"|"SUPPRESSED"
  ),
  RelatedFindings = list(
    list(
      ProductArn = "string",
      Id = "string"
    )
  )
)
}
}

\keyword{internal}
