% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspector_operations.R
\name{inspector_set_tags_for_resource}
\alias{inspector_set_tags_for_resource}
\title{Sets tags (key and value pairs) to the assessment template that is
specified by the ARN of the assessment template}
\usage{
inspector_set_tags_for_resource(resourceArn, tags)
}
\arguments{
\item{resourceArn}{[required] The ARN of the assessment template that you want to set tags to.}

\item{tags}{A collection of key and value pairs that you want to set to the
assessment template.}
}
\description{
Sets tags (key and value pairs) to the assessment template that is
specified by the ARN of the assessment template.
}
\section{Request syntax}{
\preformatted{svc$set_tags_for_resource(
  resourceArn = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# Sets tags (key and value pairs) to the assessment template that is
# specified by the ARN of the assessment template.
svc$set_tags_for_resource(
  resourceArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX/template/0-7sbz2...",
  tags = list(
    list(
      key = "Example",
      value = "example"
    )
  )
)
}

}
\keyword{internal}
