% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsmv2_operations.R
\name{cloudhsmv2_create_cluster}
\alias{cloudhsmv2_create_cluster}
\title{Creates a new AWS CloudHSM cluster}
\usage{
cloudhsmv2_create_cluster(SubnetIds, HsmType, SourceBackupId, TagList)
}
\arguments{
\item{SubnetIds}{[required] The identifiers (IDs) of the subnets where you are creating the cluster.
You must specify at least one subnet. If you specify multiple subnets,
they must meet the following criteria:
\itemize{
\item All subnets must be in the same virtual private cloud (VPC).
\item You can specify only one subnet per Availability Zone.
}}

\item{HsmType}{[required] The type of HSM to use in the cluster. Currently the only allowed value
is \code{hsm1.medium}.}

\item{SourceBackupId}{The identifier (ID) of the cluster backup to restore. Use this value to
restore the cluster from a backup instead of creating a new cluster. To
find the backup ID, use DescribeBackups.}

\item{TagList}{Tags to apply to the CloudHSM cluster during creation.}
}
\description{
Creates a new AWS CloudHSM cluster.
}
\section{Request syntax}{
\preformatted{svc$create_cluster(
  SubnetIds = list(
    "string"
  ),
  HsmType = "string",
  SourceBackupId = "string",
  TagList = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
