% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_batch_import_findings}
\alias{securityhub_batch_import_findings}
\title{Imports security findings generated from an integrated third-party
product into Security Hub}
\usage{
securityhub_batch_import_findings(Findings)
}
\arguments{
\item{Findings}{[required] A list of findings to import. To successfully import a finding, it must
follow the \href{https://docs.aws.amazon.com/securityhub/latest/userguide/securityhub-findings-format.html}{AWS Security Finding Format}.
Maximum of 100 findings per request.}
}
\description{
Imports security findings generated from an integrated third-party
product into Security Hub. This action is requested by the integrated
product to import its findings into Security Hub. The maximum allowed
size for a finding is 240 Kb. An error is returned for any finding
larger than 240 Kb.
}
\section{Request syntax}{
\preformatted{svc$batch_import_findings(
  Findings = list(
    list(
      SchemaVersion = "string",
      Id = "string",
      ProductArn = "string",
      GeneratorId = "string",
      AwsAccountId = "string",
      Types = list(
        "string"
      ),
      FirstObservedAt = "string",
      LastObservedAt = "string",
      CreatedAt = "string",
      UpdatedAt = "string",
      Severity = list(
        Product = 123.0,
        Normalized = 123
      ),
      Confidence = 123,
      Criticality = 123,
      Title = "string",
      Description = "string",
      Remediation = list(
        Recommendation = list(
          Text = "string",
          Url = "string"
        )
      ),
      SourceUrl = "string",
      ProductFields = list(
        "string"
      ),
      UserDefinedFields = list(
        "string"
      ),
      Malware = list(
        list(
          Name = "string",
          Type = "ADWARE"|"BLENDED_THREAT"|"BOTNET_AGENT"|"COIN_MINER"|"EXPLOIT_KIT"|"KEYLOGGER"|"MACRO"|"POTENTIALLY_UNWANTED"|"SPYWARE"|"RANSOMWARE"|"REMOTE_ACCESS"|"ROOTKIT"|"TROJAN"|"VIRUS"|"WORM",
          Path = "string",
          State = "OBSERVED"|"REMOVAL_FAILED"|"REMOVED"
        )
      ),
      Network = list(
        Direction = "IN"|"OUT",
        Protocol = "string",
        SourceIpV4 = "string",
        SourceIpV6 = "string",
        SourcePort = 123,
        SourceDomain = "string",
        SourceMac = "string",
        DestinationIpV4 = "string",
        DestinationIpV6 = "string",
        DestinationPort = 123,
        DestinationDomain = "string"
      ),
      Process = list(
        Name = "string",
        Path = "string",
        Pid = 123,
        ParentPid = 123,
        LaunchedAt = "string",
        TerminatedAt = "string"
      ),
      ThreatIntelIndicators = list(
        list(
          Type = "DOMAIN"|"EMAIL_ADDRESS"|"HASH_MD5"|"HASH_SHA1"|"HASH_SHA256"|"HASH_SHA512"|"IPV4_ADDRESS"|"IPV6_ADDRESS"|"MUTEX"|"PROCESS"|"URL",
          Value = "string",
          Category = "BACKDOOR"|"CARD_STEALER"|"COMMAND_AND_CONTROL"|"DROP_SITE"|"EXPLOIT_SITE"|"KEYLOGGER",
          LastObservedAt = "string",
          Source = "string",
          SourceUrl = "string"
        )
      ),
      Resources = list(
        list(
          Type = "string",
          Id = "string",
          Partition = "aws"|"aws-cn"|"aws-us-gov",
          Region = "string",
          Tags = list(
            "string"
          ),
          Details = list(
            AwsCloudFrontDistribution = list(
              DomainName = "string",
              ETag = "string",
              LastModifiedTime = "string",
              Logging = list(
                Bucket = "string",
                Enabled = TRUE|FALSE,
                IncludeCookies = TRUE|FALSE,
                Prefix = "string"
              ),
              Origins = list(
                Items = list(
                  list(
                    DomainName = "string",
                    Id = "string",
                    OriginPath = "string"
                  )
                )
              ),
              Status = "string",
              WebAclId = "string"
            ),
            AwsEc2Instance = list(
              Type = "string",
              ImageId = "string",
              IpV4Addresses = list(
                "string"
              ),
              IpV6Addresses = list(
                "string"
              ),
              KeyName = "string",
              IamInstanceProfileArn = "string",
              VpcId = "string",
              SubnetId = "string",
              LaunchedAt = "string"
            ),
            AwsElbv2LoadBalancer = list(
              AvailabilityZones = list(
                list(
                  ZoneName = "string",
                  SubnetId = "string"
                )
              ),
              CanonicalHostedZoneId = "string",
              CreatedTime = "string",
              DNSName = "string",
              IpAddressType = "string",
              Scheme = "string",
              SecurityGroups = list(
                "string"
              ),
              State = list(
                Code = "string",
                Reason = "string"
              ),
              Type = "string",
              VpcId = "string"
            ),
            AwsS3Bucket = list(
              OwnerId = "string",
              OwnerName = "string"
            ),
            AwsIamAccessKey = list(
              UserName = "string",
              Status = "Active"|"Inactive",
              CreatedAt = "string",
              PrincipalId = "string",
              PrincipalType = "string",
              PrincipalName = "string"
            ),
            AwsIamRole = list(
              AssumeRolePolicyDocument = "string",
              CreateDate = "string",
              RoleId = "string",
              RoleName = "string",
              MaxSessionDuration = 123,
              Path = "string"
            ),
            AwsKmsKey = list(
              AWSAccountId = "string",
              CreationDate = 123.0,
              KeyId = "string",
              KeyManager = "string",
              KeyState = "string",
              Origin = "string"
            ),
            AwsLambdaFunction = list(
              Code = list(
                S3Bucket = "string",
                S3Key = "string",
                S3ObjectVersion = "string",
                ZipFile = "string"
              ),
              CodeSha256 = "string",
              DeadLetterConfig = list(
                TargetArn = "string"
              ),
              Environment = list(
                Variables = list(
                  "string"
                ),
                Error = list(
                  ErrorCode = "string",
                  Message = "string"
                )
              ),
              FunctionName = "string",
              Handler = "string",
              KmsKeyArn = "string",
              LastModified = "string",
              Layers = list(
                list(
                  Arn = "string",
                  CodeSize = 123
                )
              ),
              MasterArn = "string",
              MemorySize = 123,
              RevisionId = "string",
              Role = "string",
              Runtime = "string",
              Timeout = 123,
              TracingConfig = list(
                Mode = "string"
              ),
              VpcConfig = list(
                SecurityGroupIds = list(
                  "string"
                ),
                SubnetIds = list(
                  "string"
                ),
                VpcId = "string"
              ),
              Version = "string"
            ),
            AwsSnsTopic = list(
              KmsMasterKeyId = "string",
              Subscription = list(
                list(
                  Endpoint = "string",
                  Protocol = "string"
                )
              ),
              TopicName = "string",
              Owner = "string"
            ),
            AwsSqsQueue = list(
              KmsDataKeyReusePeriodSeconds = 123,
              KmsMasterKeyId = "string",
              QueueName = "string",
              DeadLetterTargetArn = "string"
            ),
            Container = list(
              Name = "string",
              ImageId = "string",
              ImageName = "string",
              LaunchedAt = "string"
            ),
            Other = list(
              "string"
            )
          )
        )
      ),
      Compliance = list(
        Status = "PASSED"|"WARNING"|"FAILED"|"NOT_AVAILABLE"
      ),
      VerificationState = "UNKNOWN"|"TRUE_POSITIVE"|"FALSE_POSITIVE"|"BENIGN_POSITIVE",
      WorkflowState = "NEW"|"ASSIGNED"|"IN_PROGRESS"|"DEFERRED"|"RESOLVED",
      RecordState = "ACTIVE"|"ARCHIVED",
      RelatedFindings = list(
        list(
          ProductArn = "string",
          Id = "string"
        )
      ),
      Note = list(
        Text = "string",
        UpdatedBy = "string",
        UpdatedAt = "string"
      )
    )
  )
)
}
}

\keyword{internal}
