% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_groups_for_user}
\alias{iam_list_groups_for_user}
\title{Lists the IAM groups that the specified IAM user belongs to}
\usage{
iam_list_groups_for_user(UserName, Marker, MaxItems)
}
\arguments{
\item{UserName}{[required] The name of the user to list groups for.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}
}
\description{
Lists the IAM groups that the specified IAM user belongs to.
}
\details{
You can paginate the results using the \code{MaxItems} and \code{Marker}
parameters.
}
\section{Request syntax}{
\preformatted{svc$list_groups_for_user(
  UserName = "string",
  Marker = "string",
  MaxItems = 123
)
}
}

\examples{
\dontrun{
# The following command displays the groups that the IAM user named Bob
# belongs to.
svc$list_groups_for_user(
  UserName = "Bob"
)
}

}
\keyword{internal}
