# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Security Token Service
#'
#' @description
#' The AWS Security Token Service (STS) is a web service that enables you
#' to request temporary, limited-privilege credentials for AWS Identity and
#' Access Management (IAM) users or for users that you authenticate
#' (federated users). This guide provides descriptions of the STS API. For
#' more detailed information about using this service, go to [Temporary
#' Security
#' Credentials](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp.html).
#' 
#' For information about setting up signatures and authorization through
#' the API, go to [Signing AWS API
#' Requests](https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html)
#' in the *AWS General Reference*. For general information about the Query
#' API, go to [Making Query
#' Requests](https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html)
#' in *Using IAM*. For information about using security tokens with other
#' AWS products, go to [AWS Services That Work with
#' IAM](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html)
#' in the *IAM User Guide*.
#' 
#' If you\'re new to AWS and need additional technical information about a
#' specific AWS product, you can find the product\'s technical
#' documentation at <http://aws.amazon.com/documentation/>.
#' 
#' **Endpoints**
#' 
#' By default, AWS Security Token Service (STS) is available as a global
#' service, and all AWS STS requests go to a single endpoint at
#' `https://sts.amazonaws.com`. Global requests map to the US East (N.
#' Virginia) region. AWS recommends using Regional AWS STS endpoints
#' instead of the global endpoint to reduce latency, build in redundancy,
#' and increase session token validity. For more information, see [Managing
#' AWS STS in an AWS
#' Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
#' in the *IAM User Guide*.
#' 
#' Most AWS Regions are enabled for operations in all AWS services by
#' default. Those Regions are automatically activated for use with AWS STS.
#' Some Regions, such as Asia Pacific (Hong Kong), must be manually
#' enabled. To learn more about enabling and disabling AWS Regions, see
#' [Managing AWS
#' Regions](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html)
#' in the *AWS General Reference*. When you enable these AWS Regions, they
#' are automatically activated for use with AWS STS. You cannot activate
#' the STS endpoint for a Region that is disabled. Tokens that are valid in
#' all AWS Regions are longer than tokens that are valid in Regions that
#' are enabled by default. Changing this setting might affect existing
#' systems where you temporarily store tokens. For more information, see
#' [Managing Global Endpoint Session
#' Tokens](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html#sts-regions-manage-tokens)
#' in the *IAM User Guide*.
#' 
#' After you activate a Region for use with AWS STS, you can direct AWS STS
#' API calls to that Region. AWS STS recommends that you provide both the
#' Region and endpoint when you make calls to a Regional endpoint. You can
#' provide the Region alone for manually enabled Regions, such as Asia
#' Pacific (Hong Kong). In this case, the calls are directed to the STS
#' Regional endpoint. However, if you provide the Region alone for Regions
#' enabled by default, the calls are directed to the global endpoint of
#' `https://sts.amazonaws.com`.
#' 
#' To view the list of AWS STS endpoints and whether they are active by
#' default, see [Writing Code to Use AWS STS
#' Regions](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html#id_credentials_temp_enable-regions_writing_code)
#' in the *IAM User Guide*.
#' 
#' **Recording API requests**
#' 
#' STS supports AWS CloudTrail, which is a service that records AWS calls
#' for your AWS account and delivers log files to an Amazon S3 bucket. By
#' using information collected by CloudTrail, you can determine what
#' requests were successfully made to STS, who made the request, when it
#' was made, and so on.
#' 
#' If you activate AWS STS endpoints in Regions other than the default
#' global endpoint, then you must also turn on CloudTrail logging in those
#' Regions. This is necessary to record any AWS STS API calls that are made
#' in those Regions. For more information, see [Turning On CloudTrail in
#' Additional
#' Regions](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/aggregating_logs_regions_turn_on_ct.html)
#' in the *AWS CloudTrail User Guide*.
#' 
#' AWS Security Token Service (STS) is a global service with a single
#' endpoint at `https://sts.amazonaws.com`. Calls to this endpoint are
#' logged as calls to a global service. However, because this endpoint is
#' physically located in the US East (N. Virginia) Region, your logs list
#' `us-east-1` as the event Region. CloudTrail does not write these logs to
#' the US East (Ohio) Region unless you choose to include global service
#' logs in that Region. CloudTrail writes calls to all Regional endpoints
#' to their respective Regions. For example, calls to
#' sts.us-east-2.amazonaws.com are published to the US East (Ohio) Region
#' and calls to sts.eu-central-1.amazonaws.com are published to the EU
#' (Frankfurt) Region.
#' 
#' To learn more about CloudTrail, including how to turn it on and find
#' your log files, see the [AWS CloudTrail User
#' Guide](https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- sts(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- sts()
#' # 
#' svc$assume_role(
#'   ExternalId = "123ABC",
#'   Policy = "\{\"Version\":\"2012-10-17\",\"Statement\":[\{\"Sid\":\"Stmt1\",\"Effect\":...",
#'   RoleArn = "arn:aws:iam::123456789012:role/demo",
#'   RoleSessionName = "testAssumeRoleSession",
#'   Tags = list(
#'     list(
#'       Key = "Project",
#'       Value = "Unicorn"
#'     ),
#'     list(
#'       Key = "Team",
#'       Value = "Automation"
#'     ),
#'     list(
#'       Key = "Cost-Center",
#'       Value = "12345"
#'     )
#'   ),
#'   TransitiveTagKeys = list(
#'     "Project",
#'     "Cost-Center"
#'   )
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=sts_assume_role]{assume_role} \tab Returns a set of temporary security credentials that you can use to access AWS resources that you might not normally have access to \cr
#'  \link[=sts_assume_role_with_saml]{assume_role_with_saml} \tab Returns a set of temporary security credentials for users who have been authenticated via a SAML authentication response \cr
#'  \link[=sts_assume_role_with_web_identity]{assume_role_with_web_identity} \tab Returns a set of temporary security credentials for users who have been authenticated in a mobile or web application with a web identity provider\cr
#'  \link[=sts_decode_authorization_message]{decode_authorization_message} \tab Decodes additional information about the authorization status of a request from an encoded message returned in response to an AWS request \cr
#'  \link[=sts_get_access_key_info]{get_access_key_info} \tab Returns the account identifier for the specified access key ID \cr
#'  \link[=sts_get_caller_identity]{get_caller_identity} \tab Returns details about the IAM user or role whose credentials are used to call the operation \cr
#'  \link[=sts_get_federation_token]{get_federation_token} \tab Returns a set of temporary security credentials (consisting of an access key ID, a secret access key, and a security token) for a federated user \cr
#'  \link[=sts_get_session_token]{get_session_token} \tab Returns a set of temporary credentials for an AWS account or IAM user 
#' }
#'
#' @rdname sts
#' @export
sts <- function(config = list()) {
  svc <- .sts$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.sts <- list()

.sts$operations <- list()

.sts$metadata <- list(
  service_name = "sts",
  endpoints = list("*" = list(endpoint = "https://sts.amazonaws.com", global = TRUE), "us-gov-*" = list(endpoint = "sts.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "sts.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "STS",
  api_version = "2011-06-15",
  signing_name = NULL,
  json_version = "",
  target_prefix = ""
)

.sts$service <- function(config = list()) {
  handlers <- new_handlers("query", "v4")
  new_service(.sts$metadata, handlers, config)
}
