% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_delete_account_alias}
\alias{iam_delete_account_alias}
\title{Deletes the specified AWS account alias}
\usage{
iam_delete_account_alias(AccountAlias)
}
\arguments{
\item{AccountAlias}{[required] The name of the account alias to delete.

This parameter allows (through its \href{http://wikipedia.org/wiki/regex}{regex pattern}) a string of characters
consisting of lowercase letters, digits, and dashes. You cannot start or
finish with a dash, nor can you have two dashes in a row.}
}
\description{
Deletes the specified AWS account alias. For information about using an
AWS account alias, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html}{Using an Alias for Your AWS Account ID}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$delete_account_alias(
  AccountAlias = "string"
)
}
}

\examples{
# The following command removes the alias mycompany from the current AWS
# account:
\donttest{svc$delete_account_alias(
  AccountAlias = "mycompany"
)}

}
\keyword{internal}
