% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_service_linked_role}
\alias{iam_create_service_linked_role}
\title{Creates an IAM role that is linked to a specific AWS service}
\usage{
iam_create_service_linked_role(AWSServiceName, Description,
  CustomSuffix)
}
\arguments{
\item{AWSServiceName}{[required] The service principal for the AWS service to which this role is
attached. You use a string similar to a URL but without the http:// in
front. For example: \code{elasticbeanstalk.amazonaws.com}.

Service principals are unique and case-sensitive. To find the exact
service principal for your service-linked role, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html}{AWS Services That Work with IAM}
in the \emph{IAM User Guide}. Look for the services that have \strong{Yes} in the
\strong{Service-Linked Role} column. Choose the \strong{Yes} link to view the
service-linked role documentation for that service.}

\item{Description}{The description of the role.}

\item{CustomSuffix}{A string that you provide, which is combined with the service-provided
prefix to form the complete role name. If you make multiple requests for
the same service, then you must supply a different \code{CustomSuffix} for
each request. Otherwise the request fails with a duplicate role name
error. For example, you could add \code{-1} or \code{-debug} to the suffix.

Some services do not support the \code{CustomSuffix} parameter. If you
provide an optional suffix and the operation fails, try the operation
again without the suffix.}
}
\description{
Creates an IAM role that is linked to a specific AWS service. The
service controls the attached policies and when the role can be deleted.
This helps ensure that the service is not broken by an unexpectedly
changed or deleted role, which could put your AWS resources into an
unknown state. Allowing the service to control the role helps improve
service stability and proper cleanup when a service and its role are no
longer needed. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html}{Using Service-Linked Roles}
in the \emph{IAM User Guide}.
}
\details{
To attach a policy to this service-linked role, you must make the
request using the AWS service that depends on this role.
}
\section{Request syntax}{
\preformatted{svc$create_service_linked_role(
  AWSServiceName = "string",
  Description = "string",
  CustomSuffix = "string"
)
}
}

\keyword{internal}
